package comms.core;
/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.io.*;
import java.io.EOFException;
import java.io.IOException;
import java.util.*;

public class Connection extends Thread {

  private CommsStream stream;
  private MessageQueue messageQueue;
  private QueueAssign qAssign;

  public Connection(String n, CommsStream s, MessageQueue q, QueueAssign qa) {
    //name = n;
    super(n);
    stream = s;
    messageQueue = q;
    qAssign = qa;
    //stop = false;
  }

  public boolean isActive() {
    return (stream != null);
  }

  /*public void replaceStream(CommsStream s) {
    //System.out.println("Connection.replaceStream()");
    stream = s;
  }*/

  public synchronized void setQueue(MessageQueue q) {
    messageQueue = q;
  }

  public synchronized void sendMessage(Message m) throws IOException {
    if(stream != null) {
      stream.sendMessage(m);
    }
    else {
      throw new IOException("No connection...");
    }
  }

  public synchronized MessageQueue getQueue() {
    return messageQueue;
  }

  public void run() {
    //System.out.println("in Connection.run()");
    Message m = null;
    boolean dead = false;

    while (!dead) {
      try {
	m = stream.readMessage();
	//System.out.println("Connection.run(), message: "+m.getMessage());
	m.setCorrespondent(getName());
        synchronized(this) {
          messageQueue.add(m);
        }
      } 
      catch (EOFException e) {
	try {
	  // kill this connection thread if it suddenly disconnects, make a new
	  // connection thread later upon reconnect
	  //this.stop();
	  stream.close();
	}
	catch(Exception ex) {
	  System.out.println(ex);
	}
	finally {
	  stream = null;
	  dead = true;
          //if this entity was set to revert to default on disconnect
	  //then revert it. the revert function won't let you revert
	  //non-revertable entities
	  if(qAssign.revert(getName())) {
            //if this was a revertable connection, then stick
            //the disconnected message into the
            //queue so that the user can react to the disconnection
            //and automatica revert to default queue
            Message md = new Message(Communications.kDISCONNECTED);
            md.setCorrespondent(getName());
            synchronized(this) {
              messageQueue.add(md);
            }
	  }
	}
      }
      catch (IOException e) {
	e.printStackTrace();
      }
    }
  }

  public void close() throws IOException {
    this.stop();
    //if this entity was set to revert to default on disconnect
    //then revert it. the revert function won't let you revert
    //non-revertable entities
    if(qAssign.revert(getName())) {
      //if this was a revertable connection, then stick
      //the disconnected message into the
      //queue so that the user can react to the disconnection
      //and automatically revert to default queue
      Message md = new Message(Communications.kDISCONNECTED);
      md.setCorrespondent(getName());
      synchronized(this) {
        messageQueue.add(md);
      }
    }
    if(stream != null) {
      try {
	stream.close();
      } catch (IOException ioe) {
	stream = null;
	throw ioe;
      }
      stream = null;
    }
  }

  protected void finalize() throws Throwable {
    try {
      close();
    }
    catch(Exception e) {
    }
    stream = null;
    messageQueue = null;
    qAssign = null;
    super.finalize();
  }
}
