package comms.core;

/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.io.IOException;
import java.net.*;

public class CommsStream {
  
  private CommsInputStream in;
  private CommsOutputStream out;
  //private Message currentMessage; // last message sent or read

  public CommsStream(PhoneNumber p) throws IOException {
    System.out.println(p);
    Socket s = new Socket(p.getHostname(), p.getPortNumber());
    in = new CommsInputStream(s.getInputStream());
    out = new CommsOutputStream(s.getOutputStream());
  }

  public CommsStream(String hostname, int port) throws IOException {
    Socket s = new Socket(hostname, port);
    in = new CommsInputStream(s.getInputStream());
    out = new CommsOutputStream(s.getOutputStream());
  }

  public CommsStream(Socket s) throws IOException {
    in = new CommsInputStream(s.getInputStream());
    out = new CommsOutputStream(s.getOutputStream());
  }

  public Message readMessage() throws IOException {
    //currentMessage = new Message(in.readMessage());
    //return currentMessage;
    /*
      String message = in.readMessage();
      int firstBreak = message.indexOf(' ');
      int secondBreak = message.indexOf(' ',firstBreak+1);
      
      String newTo = message.substring(0,firstBreak-1);
      String newFrom = message.substring(firstBreak+1,secondBreak-1);
      Message newMessage = new Message(message.substring(secondBreak+1));
      newMessage.setTo(newTo);
      newMessage.setFrom(newFrom);
      return newMessage;
    */
    String[] messParts = in.readMessage();
    //messParts[1] and messParts[2] are either both null or both non-null
    return new Message(messParts[0],
                       (messParts[1]==null) ? Message.kUNKNOWN : messParts[1],
                       (messParts[2]==null) ? Message.kUNKNOWN : messParts[2]);
  }

  public void sendMessage(Message m) throws IOException {
    //currentMessage = m;
    //currentMessage.setTimeStamp();
    //System.out.println("sending: "+m.getMessage());
    /*
      if(m.getTo() == null) {
      m.setTo(new String("UNKNOWN"));
      }
      if(m.getFrom() == null) {
      m.setFrom(new String("UNKNOWN"));
      }
      out.writeMessage(m.getTo() + " " + m.getFrom() + " " + m.getMessage());
    */
    out.writeMessage(m.getMessage(),
                     (m.getTo()==null) ? Message.kUNKNOWN : m.getTo(),
                     (m.getFrom()==null) ? Message.kUNKNOWN : m.getFrom());
  }
  
  public void sendMessage(String s) throws IOException {
    //currentMessage = new Message(s);
    //currentMessage.setTimeStamp();
    out.writeMessage(s,Message.kUNKNOWN,Message.kUNKNOWN);
  }
  
  public void close() throws IOException {
    in.close();
    out.close();
  }

  protected void finalize() throws Throwable {
    in = null;
    out = null;
    //currentMessage = null;
    super.finalize();
  }
}
