package comms.core;

/**
  * @author Jeffrey Lam <Odin@CMU.edu>
  *
  */

import java.io.IOException;
import java.net.*;

public class CommsServer extends ServerSocket {

  /** sets up a server socket on a random free port  */
  public CommsServer() throws IOException {
    super(0);
  }

  public CommsServer(int portNumber) throws IOException {
    super(portNumber);
  }

  public CommsServer(int portNumber, int backlog) throws IOException {
    super(portNumber, backlog);
  }
  
  public CommsServer(int portNumber, int backlog, InetAddress bindAddress)
    throws IOException {

    super(portNumber, backlog, bindAddress);
  }
  
  public CommsStream acceptConnection() throws IOException {
    return new CommsStream(this.accept());
  }

  protected void finalize() throws Throwable {
    super.finalize();
  }
}
