package comms.core;
import java.io.OutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CommsOutputStream extends DataOutputStream {

  public CommsOutputStream(OutputStream os) {
    super(os);
  }
  
  public void writeMessage(String message, String toField,
                           String fromField) throws IOException {
    //attach directly to the end of the stream and save a string
    //concatenation
    //message = message + '\000';
    // null character needed to communicate with
    // C clients/servers

    int totalMessageLength =
      toField.length()+1+fromField.length()+1+message.length()+1;

    //write length of the message first
    writeByte(totalMessageLength%256);
    writeByte(totalMessageLength/256%256);
    writeByte(totalMessageLength/65536%256);
    writeByte(totalMessageLength/16777216%256);
    //write the Using To From field indicator byte
    //write the to/from fields
    writeBytes(toField);
    writeByte((int) ' ');
    writeBytes(fromField);
    writeByte((int) ' ');
    writeBytes(message);
    //null char needed to communicate with C clients/servers
    writeByte('\000');
    flush();
  }
}
