package comms.core;

import java.io.InputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class CommsInputStream extends DataInputStream {
  public CommsInputStream(InputStream is) {
    super(is);
  }

  /**
   *  Reads a message from the input.
   *  retvals should have at least three places.
   *  retVal[0] will contain the message string.
   *  retVal[1] will contain the to string (may be null )
   *  retVal[2] will contain the from string (may be null)
   *  the to and from fields will only be non-null when the message
   *  had a two and from field embedded
   */
  public String[] readMessage() throws IOException {
    String[] retVals = new String[3];
    
    int b1 = readUnsignedByte();
    int b2 = readUnsignedByte();
    int b3 = readUnsignedByte();
    int b4 = readUnsignedByte();
    
    // save time on computation
    int messageLength = b1 + b2*256  + b3*65536 + b4*16777216;
    byte messageBytes[] = new byte[messageLength];
    readFully(messageBytes);
    
    //the lengths of the two and from fields
    //including one space for each
    int lenTo=0;
    int lenFrom=0;
    //convert the To and From fields from bytes to String
    if(((lenTo = findByte((byte)' ', messageBytes,0)) != -1) &&
       ((lenFrom = findByte((byte)' ', messageBytes,lenTo+1)) != -1)) {
      lenFrom = lenFrom-lenTo-1;
      //to field
      retVals[1] = new String(messageBytes, 0, lenTo,"ISO8859_1");
      //System.out.println("To: "+retVals[1]);        
      //from field
      retVals[2] = new String(messageBytes, lenTo+1, lenFrom,"ISO8859_1");
      //System.out.println("From: "+retVals[2]);  
      //add the trailing spaces to the length count
      lenTo++;
      lenFrom++;
    }
    else {
      lenTo = 0;
      lenFrom = 0;
    }
    if(messageBytes[messageLength-1] != 0) {
      retVals[0] = new String(messageBytes, lenTo+lenFrom,
                              messageLength-lenTo-lenFrom,"ISO8859_1");
    }
    else 
    {
      retVals[0] = new String(messageBytes, lenTo+lenFrom,
                              messageLength-lenTo-lenFrom-1,"ISO8859_1");
    }
    //System.out.println("Message: "+retVals[0]);
    //convert the Message bytes to String
    return retVals;
  }

  /** locate the first occurence of the target byte
      in the source array starting from index st
      returns the targets index in source or -1 if not found
  */
  private int findByte(byte target, byte[] source, int st) {
    if( source == null || st < 0 ) {
      return -1;
    }

    for( ; st < source.length ; st++) {
      if( source[st] == target ) {
        return st;
      }
    }
    return -1;
  }
}
