package comms.core;

import java.awt.*;
import java.io.IOException;

/**
 *
 * @author Ted Pham (telamon@CMU.EDU)
 * @version .01
 */

public class ComTest extends Frame implements Runnable {
  
  Communications comm;

  TextArea textArea1;
  TextArea textArea2;
  TextArea textArea3;
  Panel panel1;
  Panel panel2;
  Button button2;
  Label label1;
  TextField textField1;
  TextField textField2;

  public ComTest(String name, String dirIP, int dirPort) throws Exception {
    super();
    comm = new Communications(name, dirIP, dirPort, false, true);
    initComponents (dirIP,dirPort);
    setTitle(name);
    validate();
    pack();
    show();
    Thread worker = new Thread(this);
    worker.setDaemon(true);
    worker.start();
  }

  private void initComponents (String dirIP, int dirPort) {
    
    setLayout (new BorderLayout ());
    textArea1 = new TextArea ("",8,40,TextArea.SCROLLBARS_VERTICAL_ONLY);
    //textArea1.setFont (new Font ("Dialog", 0, 18));
    textArea1.setEditable (false);
    add (textArea1, "Center");

    panel1 = new Panel ();
    panel1.setLayout (new FlowLayout ());

      label1 = new Label("Message:");
      //label1.setFont(new Font ("Dialog", 0, 18));
      panel1.add(label1);

      textField1 = new TextField ("",5);
      //textField1.setFont (new Font("Dialog",0,18));
      panel1.add (textField1);
      textField2 = new TextField ("",30);
      //textField2.setFont (new Font ("Dialog", 0, 18));
      panel1.add (textField2);

      button2 = new Button ();
      button2.setLabel ("Send");
      panel1.add (button2);

    add (panel1, "North");

    panel2 = new Panel();
    panel2.setLayout (new BorderLayout());

      textArea2 = new TextArea("Directory:\t"+dirIP+"\t\t"+dirPort+"\n"+
			       comm.getMyName()+":\t"+
			       comm.getLocalHost()+"\t"+
			       comm.getLocalPort(),3,60,
			       TextArea.SCROLLBARS_VERTICAL_ONLY);
      //textArea2.setFont ( new Font("Dialog",0,18));
      textArea2.setEditable(false);
      panel2.add(textArea2,"North");
    
      textArea3 = new TextArea("",4,60,TextArea.SCROLLBARS_VERTICAL_ONLY);
      //textArea3.setFont( new Font("Dialog",0,18));
      textArea3.setEditable(false);
      panel2.add(textArea3,"South");

    add(panel2,"South");
  }

  public synchronized boolean handleEvent(Event e){
    if(e.id == e.WINDOW_DESTROY) {
      shutdown();
      return true;
    }
    else if(e.id == e.ACTION_EVENT) {
      if(e.target == button2) {
	try {
	  if(!textField1.getText().equals("") && 
	     !textField2.getText().equals("")) {
	    comm.sendMessage(textField1.getText(),
			     new Message(textField2.getText(),"MAX","ERMA"));
	    textArea1.append("S <"+textField1.getText()+">: "
			     +textField2.getText()+"\n");
	  }
	}
	catch(Exception ex) {
	  textArea3.append("Error: Can't send to "+textField1.getText()+"\n");
	}
        return true;
      }
    }
    return super.handleEvent(e);
  }

  public void run() {
    while(true) {
      Message m = comm.readNextMessage();            
      String mString = m.getMessage();
      textArea1.append("R <"+m.getCorrespondent()+">: "+mString+"\n");
    }
  }

  private void shutdown() {
    comm.shutdown();
    this.dispose();
    System.exit(1);
  }

  static void printUsage() {
    System.err.println("Usage: java ComTest <name> " + 
		       "<directory hostname> <directory port>");
    System.exit(1);
  }

  public static void main(String[] args) {
    try {
      if(args.length < 3) {
	printUsage();
      }
      
      ComTest theTest = 
	new ComTest(args[0],args[1],Integer.parseInt(args[2]));
    }
    catch(Exception e) {
      if(e instanceof NumberFormatException) {
        e.printStackTrace();
        System.out.println(e.getMessage());
	printUsage();
      }
      else {
	//e.printStackTrace();
	System.err.println("Error:");
	System.err.println(e.getMessage());
      }
    }
  }
}
