/* Stub Module, by Andrea Byrnes */

package adaptive.modulemanager;

import adaptive.core.*;
//import adaptive.agents.PBAStub;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

/** A Stub for run time viewing of the system.  This is needed to 
  * accurately show how the different agents are interacting and 
  * communicating with each other when they are running on different 
  * machines.  (Not yet) A click on a stub module should show packet 
  * statistics for it's communications.
  * $Log: StubModule.java,v $
  * Revision 1.1.2.8  2000/05/22 18:46:45  jrj
  * moved PBAStub from adaptive.agents to adaptive.core
  *
  */

public class StubModule extends adaptive.modulemanager.Module {
  private IOPort thisPort;

  /* for background color */
  private boolean isMacro;
  /* Is this stub a RightStub or a LeftStub */
  private int side;
  /* What host is displaying this Stub */
  private String display;

  /* Left stubs only have inputs, Right stubs only have outputs */
  public static final int LEFT = IOPort.INPUT;
  public static final int RIGHT = IOPort.OUTPUT;

  /* The basics for initializing the Stub.  Used in the other constructors. */
  public StubModule(boolean localInit,int debugLevel ){
    super(false,debugLevel); //calls init now
    agent = new PBAStub();
    ((PBAStub)agent).setAgentDescription(new AgentDescription("stub","adaptive.core.PBAStub"));
    if(localInit) localInit();
  }

  /** Makes an empty right or left Stub.
    *
    * @param lr StubModule.LEFT or StubModule.RIGHT, depending on which
    *           side you like.
    */
  public StubModule(int lr, boolean localInit,int debugLevel ){
    this(false,debugLevel);
    if( (side == RIGHT) || (side == LEFT) )
      side = lr;
    else {
      System.err.println("You suck!  A type other than RIGHT or LEFT was specified!!");
      side = LEFT;
    }
    if(localInit) localInit();
  }


  /** Takes in the adaptive.modulemanager.Module that this object will represent on other hosts.
    *
    * @param m The adaptive.modulemanager.Module to represent
    * @param dispHost The host that will display this stub
    * @param lr Left-sided or Right-sided stub
    */
  /* public StubModule(Module m, String dispHost, int lr){
     super(true); //Not going to call init()
     System.out.println("Module Constructor called for some reason...  :( ");
     
     display = dispHost;
     module = m;
     //System.out.println("StubModule being created with:"+m+":"+dispHost+":"+lr);
     if( (side == RIGHT) || (side == LEFT) )
     side = lr;
     else {
     System.err.println("You suck!  A type other than RIGHT or LEFT was specified!!");
     side = LEFT;
     }
     
     /* Copied from super(m) because the function structure there is 
		  screwey and I couldn't get things set up with the proper Agent 
		  Description *
		  agent=m.getAgent();
		  displayedClass=m.displayedClass;
		  owner=m.owner;
		  moduleSize=new Dimension(m.moduleSize);
		  //    init();	    
		  backgroundColor=m.backgroundColor;
		  //localInit();
       
		  /* To reset the ports, I'm going to make a replacement AgentDescription *
			  AgentDescription ad = new AgentDescription();
			  if(!(m instanceof StubModule)) {
			  AgentDescription oldAD = m.getAgentDescription();
			  //AgentDescription ad = new AgentDescription();
			  ad.setName(new String(oldAD.getName()));
			  ad.setRunLocation(new String(oldAD.getRunLocation()));
			  ad.setSource(oldAD.getSource());
			  ad.setType(new String(oldAD.getType()));
			  if(oldAD.getState() != null)
			  ad.setState(((Hashtable)oldAD.getState()).clone());
			  } else 
			  ad.setType(m.getClassType());
       
			  /* Now, go through the ConnectLines on this module and only add ports
				  for the lines that will be drawn for this display host (dispHost) *
				  localInit();
				  Enumeration eLines;
				  if(side == LEFT) {
				  System.out.println("Making a LEFT");
				  /* Moved to localInit()
					  inputMapping = new Mapping(m.getNumInputLines()+1);
					  //System.out.println("  Making "+m.getNumInputLines()+
					  //		 " inputConnectLines.");
					  inputConnectLines = new Vector(m.getNumInputLines());
					  inputConnectLines.setSize(m.getNumInputLines());
					  outputConnectLines = new Vector(0);
					  outputConnectLines.setSize(0);
					  //System.out.println("inputConnectLines: "+inputConnectLines.size());
					  //System.out.println("m.inputConnectLines[0]: "+m.inputConnectLines.elementAt(0));
					  *
					  eLines = m.getInputConnectLines();
					  } else { //if(side == RIGHT)
					  System.out.println("Making a RIGHT");
					  /* Moved to localInit()
						  outputMapping = new Mapping(m.getNumOutputLines()+1);
						  outputConnectLines = new Vector(m.getNumOutputLines());
						  outputConnectLines.setSize(m.getNumOutputLines());
						  inputConnectLines = new Vector(0);
						  inputConnectLines.setSize(0);
						  *
						  eLines = m.getOutputConnectLines();
						  }
       
						  Object o;
						  ConnectLine cl;
						  adaptive.modulemanager.Module otherEnd;
						  IOPort otherPort;
						  int portCount = 0;
       
						  while(eLines.hasMoreElements()) {
						  o = eLines.nextElement();
						  //System.out.println("<stub:110> "+o.getClass());
						  if(o instanceof ConnectLine) {
						  cl = (ConnectLine)o;
						  //System.out.println("<stub:113> "+cl.toString2());
						  //if(cl != null) {
       
						  /* This module is at the other end of the ConnectLine from this stub *
							  if(side == LEFT) {
							  otherPort = cl.getOutputPort();
							  otherEnd = otherPort.getModule();
							  if( (otherPort.getPortType() == IOPort.OUTPUT) && 
							  (dispHost.compareTo(otherEnd.getHostName()) == 0) ) {
							  //System.out.println("inputConnectLines: "+inputConnectLines.size());
							  /* while(cl.getInputPort().getPortNumber()>=inputMapping.numMapped()){
								  inputMapping.setMap(inputMapping.numMapped(),null);
								  }
								  *
								  //System.out.println("numMapped: "+inputMapping.numMapped());
								  setInputMapping(cl);
								  //System.out.println("inputConnectLines["+
								  //	       cl.getInputPort().getPortNumber()+"]: "+
								  //	       inputConnectLines.elementAt(cl.getInputPort()
								  //					   .getPortNumber()));
								  ad.setInputMapping(new InputLocation(otherEnd.getName(),
								  otherPort.getPortNumber(),
								  cl.getInputPort().getPortNumber()),
								  cl.getInputPort().getPortNumber());
								  //cl.getInputPort().getPortNumber(),otherEnd,
								  //otherPort.getPortNumber());
								  portCount++;
								  //removeOutputMapping(cl);
								  continue;
								  }
								  /* if this is a RIGHT, o will be a vector, not a ConnectLine, so 
									  this is useless here...
									  } else { //if(side == RIGHT)
									  otherPort = cl.getInputPort();
									  otherEnd = otherPort.getModule();
									  System.out.println("disp: "+dispHost+" to: "+
									  otherEnd.getHostName());
									  if( /*(otherPort.getPortType() == IOPort.INPUT) && *
											  (dispHost.compareTo(otherEnd.getHostName()) == 0) ) {
											  setOutputMapping(cl);
											  portCount++;
											  //removeInputMapping(cl);
											  continue;
											  }
											  *
											  } //end if LEFT/else if RIGHT
	  
											  //	otherEnd = otherPort.getModule();
	  
											  /*	if(dispHost.compareTo(otherEnd.getHostName()) == 0){
													ad.addInputMapping(new InputLocation(otherEnd.getName(),
													otherPort.getPortNumber(),
													otherPort.getPortNumber()));
													if(side == LEFT)
													setInputMapping(cl);
													else  //if(side == RIGHT)
													setOutputMapping(cl);
		
													portCount++;
		
													}
													*
	
													} else if(o instanceof Vector){ /* then we're making a RIGHT; outputs 
																								  can be mapped to more than one input*
																								  Vector v = (Vector)o;
																								  for(int i = 0; i<v.size(); i++) {
																								  cl = (ConnectLine)v.elementAt(i);
																								  otherPort = cl.getInputPort();
																								  otherEnd = otherPort.getModule();
																								  if(dispHost.compareTo(otherEnd.getHostName()) == 0){
																								  setOutputMapping(cl);
																								  portCount++;
																								  break; 
																								  }
																								  }
																								  }
																								  } //end the eLines loop
					   
																								  /* Stubs only have inputs OR outputs, but not both. *
																									  if(side == LEFT) {
																									  System.out.println("PortCount: "+portCount);
																									  ad.setNumInputs(portCount);
																									  ad.setNumOutputs(0);
																									  } else {  //if(side == RIGHT)
																									  System.out.println("PortCount: "+portCount);
																									  ad.setNumOutputs(portCount);
																									  ad.setNumInputs(0);
																									  }
																									  setAgentDescription(ad);
																									  //init();
																									  /* insead of calling init() (since it uses numbers I don't like...) *
																										  //localInit();
																										  lines = new Vector(getNumInputLines()+getNumOutputLines());
																										  addLineRectangles();
																										  selectedPort=-1;
																										  resizing=false;
	  
																										  /*    if(!(m instanceof StubModule))
																												  module = (Module)m.clone();
																												  *
																												  }
  */


  /* create a StubModule from the name */
  public StubModule(String s, ManagerModel mm, boolean isMacro,int debugLevel){
    super(true,debugLevel); //doesn't call init()
    setName(s);
    setOwner(mm);
    this.isMacro = isMacro;

    if(isMacro) {
      backgroundColor = new Color(0x55,0xdd,0x77); // got this from Macro.java
      this.isMacro = isMacro;
      System.out.println("<> STUB!! name:"+s);
    }
    
    setupAgent();
    
  }

  /*  public StubModule(AgentDescription ad){
      super(true); //doesn't call init()
      name = ad.getName();
      setupAgent();
      }
  */


  /** This will now be the main way to make a stub Module.  Since we know now
    * that Stubs will only have one port, we only need to send in the IOPort
    * from the module we're representing, and set up the name and type 
    * from that.
    */
  public StubModule(IOPort iop, String dispHost, int lr, ManagerModel mm,
						  int debugLevel){
    super(true,debugLevel); //calls init now...
    agent = new PBAStub(lr);
    agentDescription=new AgentDescription("stub","adaptive.core.PBAStub");
    ((PBAStub)agent).setAgentDescription(agentDescription);
    agentDescription.setRunLocation(iop.getModule().getHostName());
    side = lr;
    display = dispHost;
    thisPort = iop;
    owner = mm;

    /* Set up the name properly */
    String type, port = "null";
    int source = 5;
    if(iop.getModule() instanceof Macro) {
      Macro c = (Macro)iop.getModule();
      isMacro = true;
      if(iop.isInput()) {
	type = c.getInputPortType(iop.getPort()).getName();
	source = (((MacroDescription)c.getAgentDescription())
		  .getAgentDescriptionFor(c.getInputAgent(iop.getPort())
					  .getAgentName())).getSource();
      } else {
	type = c.getOutputPortType(iop.getPort()).getName();
	MacroDescription cd = (MacroDescription)c.getAgentDescription();
	PortLocation pl = c.getInputAgent(iop.getPort());
	//PL null here...
	System.out.println("## PL: "+pl+"; NUM: "+iop.getPort());
	//AgentDescription ad = cd.getAgentDescriptionFor(pl.getAgentName());
	
	/* WARNING:  The following is a total hack because something is 
	   wrong with the damn MacroDescription */
	source = AgentDescription.LOCAL_FILE;
	/* end Total Hack */
	
	port = iop.getPortString();
      }
    } else {  //it's not a macro
      type = iop.getModule().getAgentDescription().getType();
      source = iop.getModule().getAgentLocation();
      port = iop.getPortString();
      setName(type+":"+String.valueOf(source)+":"+port);
      setupAgent();
    }    
    setName(type+":"+String.valueOf(source)+":"+port);

    //  setupAgent();
    ((PBAStub)agent).setSide(lr);
    ((PBAStub)agent).setDisplay(dispHost);
    ((PBAStub)agent).setAgentDescription(agentDescription);
    port = iop.getPortString();
    
    if(side == LEFT){
      agent.setInputPortName(port,0);
      agent.setInputPortType(iop.getModule()
									  .getPortType(iop.getType(),
														iop.getPort()),0);
    } else {
      agent.setOutputPortName(port,0);
      agent.setOutputPortType(iop.getModule()
										.getPortType(iop.getType(),
														 iop.getPort()),0);
    }

    localInit();
  }

  /** Takes in the Agent that this object will represent on other hosts.
    *  I don't think this constructor is necessary...
    * @param a The Agent to represent
    */
  public StubModule(Agent a,int debugLevel){
    super(a,debugLevel);
    System.out.println("## This constructor shouldn't be needed...");
    try {
      if(name == null)
		  name = a.getID();
      //      System.out.println("<> NAME: "+name);
      setupAgent();
    } catch (Throwable t) {
      System.out.println("PBAStub shouldn't be loaded into the broswer.");
    }
  }

  /* Takes in a Stub module.  Used for cloning. */
  public StubModule(StubModule s, int lr, boolean isMacro,int debugLevel){
    super((Module)s,debugLevel);//calls init now

    side = lr;

    if(isMacro) {
      backgroundColor = new Color(0x55,0xdd,0x77);
      this.isMacro = isMacro;
    }

    setName(s.getName());
    name = s.getName();

    /* I want to be able to call setupAgent() here, but sometimes when the 
       name is set, there are still problems.  This is due to problems with 
       the PortLocations in the macros */
    if(name.indexOf(":") > 0) {
      //      System.out.println("Hello. My name is: "+name);
      //      setupAgent(); //calls localInit
    }

    agentDescription.setRunLocation(s.getHostName());
    displayedClass=s.displayedClass;
    owner=s.owner;
    moduleSize=new Dimension(s.moduleSize);
    localInit();
  }


  /** Initialize stuff specific to Stubs. */
  public void localInit(){
    resizeShape = new Rectangle();
    moveShape = new Rectangle();
    moduleSize = new Dimension(20,40);
    setBounds(0,0,moduleSize.width, moduleSize.height);

    if(isMacro) {
      backgroundColor = new Color(0x55,0xdd,0x77);
      this.isMacro = isMacro;
    }

    lines = new Vector(1);
    addLineRectangles();

    if(side == LEFT){
      inputLineSpacing = moduleSize.height/2;
		// inputMapping = new Mapping(1);
      //outputMapping = new Mapping(0);
      inputConnectLines = new Vector(1);
      inputConnectLines.setSize(1);
      outputConnectLines = new Vector(0);
      outputConnectLines.setSize(0);
      //agentDescription.setNumInputs(1);
      //agentDescription.setNumOutputs(0);
    } else {
      outputLineSpacing = moduleSize.height/2;
      //inputMapping = new Mapping(0);
      //outputMapping = new Mapping(1);
      outputConnectLines = new Vector(1);
      outputConnectLines.setSize(1);
      inputConnectLines = new Vector(0);
      inputConnectLines.setSize(0);
      //agentDescription.setNumInputs(0);
      //agentDescription.setNumOutputs(1);
	 }

    if(agent == null){
      agent = new PBAStub(side);
    }
    setPaint(true);
    selectedPort=-1;
    resizing=false;
    initialized=true;
  }


  /* This one probably isn't necessary, but it's used in this class a few 
     times, so I won't get rid of it yet. */
  private void setSide(int lr){
    side = lr;
  }

  /* Used in the test function still, but it should be phased 
     out and removed. */
  public int getSide(){
    return side;
  }

  /* Set the name of the host machine where this Stub will be drawn (again, 
   *   probably not necessary)
   */
  private void setDisplay(String hostName){
    display = hostName;
  }

  /** Returns a clone of this object.
    */
  public Object clone(){
    StubModule retVal = new StubModule(this,side,isMacro,debugLevel);
    retVal.setAgentDescription(agentDescription);
    if(this.name.indexOf(":") > 0) {
      retVal.setOwner(owner);
    }
    agentDescription.setRunLocation(this.getHostName());
    return retVal;
  }

  /** Draw text inside the stub.  The agent class and the host where the
    *   represented adaptive.modulemanager.Module is running are displayed.
    *   <!-- on seperate lines, of course -->
    *
    * @param g The graphics context of the module
    * @param offset The offset of the module.
    * @param highlight whether or not the module is highlighted
    */
  protected void drawText(Graphics g, Point offset,boolean highlight) {
    /* This should be commented out when I get the MouseListener working 
       to register when the mouse is over a stub.  When that happens, no 
       text will appear until the mouse is over the stub. */
    g.setFont(labelBoxFont);
    String s = name;
    s = name.substring(0,s.indexOf(":"));
    //    System.out.println("## modclass: "+modClass);
    /* Get the agent name after the first two dots
       (ie: adaptive.agents.PBAgent -> PBAgent),
       and get rid of the "PBA", it's a little redundant... */
    s = s.substring(s.indexOf(".",s.indexOf(".")+1)+1);

    if(s.startsWith("PBA"))
      s = s.substring(s.indexOf('A')+1);
    else
      isMacro = true;

    /* Now add on the port */
    //    s = s+":"+getPortName();
    g.drawString(s,Xinset+5+offset.x,moduleSize.height/2-6+offset.y);
 
    /* Put its host on there too */
    g.drawString(agentDescription.getRunLocation(),Xinset+5+offset.x, 
					  moduleSize.height/2+15+offset.y);
  }


  /* Since Stub modules are so small, the text is really cumbersome to look 
   * at everywhere.  Instead, the text will appear when the mouse is over 
   * the module, and that will make things a lot less cluttered. 
   */
  private void drawText(Graphics g, Point offset) {
    g.setFont(labelBoxFont);
    String s = name;
    s = name.substring(0,s.indexOf(":"));
    //    System.out.println("## modclass: "+modClass);
    /* Get the agent name after the first two dots
       (ie: adaptive.agents.PBAgent -> PBAgent),
       and get rid of the "PBA", it's a little redundant... */
    s = s.substring(s.indexOf(".",s.indexOf(".")+1)+1);

    if(s.startsWith("PBA"))
      s = s.substring(s.indexOf('A')+1);
    else
      isMacro = true;

    /* Now add on the port */
    //    s = s+":"+getPortName();
    g.drawString(s,Xinset+5+offset.x,moduleSize.height/2-6+offset.y);
 
    /* Put its host on there too */
    g.drawString(agentDescription.getRunLocation(),Xinset+5+offset.x, 
					  moduleSize.height/2+15+offset.y);
  }

  /** Draw the outline and/or other graphics the module requires
    *   to be displayed on the canvas.
    *
    * @param g The graphics context of the module
    * @param offset The offset of the module on the screen
    * @param highlight whether or not to highlight to module
    */
  protected void drawModuleGraphics(Graphics g,Point offset,boolean highlight){
    int x;
    //int lineY;
    Polygon poly;
    
    int n = getNumInputs();
    if(n == 0) side = RIGHT;
    else side = LEFT;

    /*  <<<<<<< StubModule.java
	
	String port = name.substring(name.lastIndexOf(":")+1);
	//    System.out.println("<> PORT format: "+port);
	int t = (port.charAt(0) == 'I') ? 0 : 1 ;
	int q = Integer.parseInt(String.valueOf(port.charAt(1)));
	Class portType = getPortType(t,q);
	=======
    */

    // Class portType = getPortType(name.substring(name.lastIndexOf(":")+1));
	 String s = name.substring(name.lastIndexOf(":")+1);
	 Class portType=getPortType(s.charAt(0)=='I'?IOPort.INPUT:IOPort.OUTPUT,
										 Integer.parseInt(s.substring(1)));
    if(portType == null)
      if(side == RIGHT){
	int colon1 = name.indexOf(":");
	int colon2 = name.lastIndexOf(":");
	String type = name.substring(0,colon1);
	int source = Integer.parseInt(name.substring(colon1+1,colon2));
	String portInfo = name.substring(colon2+1);
	
	/* ++++ should change once the other references to browserModel are 
	   taken care of */
	System.out.println("<> name: "+name);
	Module m = ((ManagerModel)owner).getModuleManager()
	  .getBrowserModel().getModule("adaptive.core.PBAStub",source);
	
	if(m != null){
	  if(side == RIGHT)
	    agent.setOutputPortType(m.getPortType(portInfo.charAt(0)=='I'?
						  IOPort.INPUT:IOPort.OUTPUT,
						  Integer.parseInt
						  (portInfo.substring(1))),0);
	}
      }

    /* All of the Stub is to fit into the module coordinate space.  So 
     *   to make room for the port lines, we'll cut 7 pixels off each end. */
    if(side == LEFT) {
      int[] xInts = {7,20,15,20,15,20,15,20,15,20, 7};
      int[] yInts = {0, 0, 5,10,15,20,25,30,35,40,40};
      for(int i = 0; i<11; i++){
		  xInts[i] += offset.x;
		  yInts[i] += offset.y;
      }
      poly = new Polygon(xInts, yInts,11);
    } else { //if(side == RIGHT)
      int[] xInts = {13, 0, 5, 0, 5, 0, 5, 0, 5, 0,13};
      int[] yInts = { 0, 0, 5,10,15,20,25,30,35,40,40};
      for(int i = 0; i<11; i++){
		  xInts[i] += offset.x;
		  yInts[i] += offset.y;
      }
      poly = new Polygon(xInts, yInts,11);
    }

    if(isMacro)
      backgroundColor = new Color(0x55,0xdd,0x77);

    g.setColor(backgroundColor);
    g.fillPolygon(poly);
    g.setColor(normalColor);
    
    /* This is Yatish's comment, I'm not sure what it means yet... */
    // draw the rectangle.  this is also used in the mousemoved part
    // so if you change this, change the part in mousemoved.  
    g.drawPolygon(poly);

    if(side == LEFT)
      for (x=0;x<agentDescription.getNumInputs();x++) {
		  drawPortLine(g,offset,IOPort.INPUT,x,false);
      }
    else //if(side == RIGHT)
      for (x=0;x<agentDescription.getNumOutputs();x++) {
		  drawPortLine(g,offset,IOPort.OUTPUT,x,false);
      }

    g.setColor(normalColor);		  
  }

  /** Get the location of where we should draw the line to connect the
    *	specified input port.  
    *
    * @return a Point in the parents coordinate system.
    */
  protected Point getInputLineLocation(int inputNumber) {
    Point p = getLocation();
    return (new Point(p.x,(inputNumber+1)*inputLineSpacing+p.y));
  }
  
  /** Get the location of where we should draw the line to conenct the
    *	specified output port.
    *
    * @return a Point in the parent's coordinate system.
    */
  protected Point getOutputLineLocation(int outputNumber) {
    Point p = getLocation();
    return (new Point(p.x+moduleSize.width,
							 p.y+(outputNumber+1)*outputLineSpacing));
  }

  /** Draw a port line.
    *
    * @param g The graphics context for this module.
    * @param o The offset of the module
    * @param type The type of port input/output
    * @param port The port number
    * @param highlight Is the line highlighted
    */
  protected void drawPortLine(Graphics g,Point o,int type,int port,boolean highlight) {
    /* The comments in here are for in case we want to change the port 
       lines from '-' to '>' and '<'  I tried it once and didn't like it 
       much, but I left it here in case it seems a way to go in the future. */
    Point p = new Point();
    Point l=getLocation();

    if (type==IOPort.INPUT) {
      p= getInputLineLocation(port);
      p.x=p.x-l.x;
      p.y=p.y-l.y;
      l.x=p.x+Xinset;
      l.y=p.y;
      
    } else if (type==IOPort.OUTPUT) {
      p= getOutputLineLocation(port);			
      p.x=p.x-l.x;//-Xinset;
      p.y=p.y-l.y;
      l.x=p.x-Xinset;
      l.y=p.y;
      
    }
    g.drawLine(p.x+o.x,p.y+o.y,l.x+o.x,p.y+o.y);
    //g.drawLine(p.x+o.x,p.y+o.y-5,l.x+o.x,p.y+o.y);
    if (highlight) {
      g.drawLine(p.x+o.x,p.y-1+o.y,l.x+o.x,p.y-1+o.y);
      g.drawLine(p.x+o.x,p.y+1+o.y,l.x+o.x,p.y+1+o.y);
    }

  }
  
  /* On principle, I don't thin k you should be able to resize Stubs.  I'm 
     leaving this here in case someone else disagrees.  */

  /* This initializes stuff, so I need the function, but I don't think 
	*   being able to resize a Stub makes much sense... (so it should be
	*   a private function, unfortunately Java doesn't like that, so I'll
	*   probably end up renaming this so that I can make it private...)
	*
	* @param x X coordinate of the point to check.
	* @param y Y coordinate of the point to check. 
	*
	public void  resizeModule(int x, int y) {
    
	x=x;
	y=y;
    
	moduleSize.width=x;
	moduleSize.height=y;
	setSize(moduleSize.width,moduleSize.height);
	((Rectangle)resizeShape).setBounds(moduleSize.width-(Xinset)-6,
	moduleSize.height-(Yinset)-6,5,5);
	((Rectangle)moveShape).setBounds(Xinset+1,Yinset,
	moduleSize.width-(Xinset*2)-2,
	moduleSize.height-(Yinset*2)-1);
    
	// now we need to determine a good linespacing for the port lines
    
	// First try and place each line with the default line spacing
	if(side == LEFT) {
	System.out.println("$$ ad: "+agentDescription
	+"; numInputs: "+agentDescription.getNumInputs());
	int lastLineLoc=(agentDescription.getNumInputs()+1)*minInputLineSpacing;
	if (lastLineLoc<=moduleSize.height-2) {
	// There is enough space so we should try and center
	// the lines
	if (agentDescription.getNumInputs()>0)
	inputLineSpacing=moduleSize.height/(agentDescription.getNumInputs()+1);
	} else 
	inputLineSpacing=minInputLineSpacing;
	} else { //if(side = RIGHT)
	int lastLineLoc=(agentDescription.getNumOutputs()+1)*minOutputLineSpacing;
	if (lastLineLoc<=moduleSize.height-2) {
	if (agentDescription.getNumOutputs()>0)
	outputLineSpacing=moduleSize.height/(agentDescription.getNumOutputs()+1);
	} else
	outputLineSpacing=minOutputLineSpacing;
	}
    
	if (!initialized) return;
	addLineRectangles();
	adjustConnectLines();
	if (owner instanceof ModuleManager) 
	((ModuleManager)owner).repaint();
	}
  */
  
  public IOPort getPort(){
    return thisPort;
  }

  public String toString(){
    String lr;
    Class portClass;
    if(side == LEFT){
      lr = "LEFT";
      portClass = getInputPortType(0);
    } else {
      lr = "RIGHT";
      portClass = getOutputPortType(0);
    }
    return ("Stub:"+lr+":"+portClass+":"+agent+":"+agentDescription+
				":"+display);
  }

  private void setupAgent(){
    /* name & moduleManager already set! */
    /* Get a module the same way Yatish does...
       format for the name is Class:Location:Port */
    String name = getName();
    int colon1 = name.indexOf(":");
    int colon2 = name.lastIndexOf(":");
    String type = name.substring(0,colon1);
    int source = Integer.parseInt(name.substring(colon1+1,colon2));
    String portInfo = name.substring(colon2+1);
    adaptive.modulemanager.Module m;

    /* 0 for Input, 1 for Output */
    int portType;
    if (portInfo.charAt(0)=='I') {
      side = LEFT;
      portType = 0;
    } else { //if (portInfo.charAt(0)=='O') 
      side = RIGHT;
      portType = 1;
    }

    int portNum = (new Integer(portInfo.substring(1))).intValue();

    if(isMacro)
      System.out.println("<2> STUB!! name:"+name);

    try{
      /* ++++ should change once the other references to browserModel are 
	 taken care of */
      System.out.println("<> "+((ManagerModel)owner).getModuleManager());
      m = ((ManagerModel)owner).getModuleManager()
	.getBrowserModel().getModule(type,source);
      
      if(m == null) { //then use another method to try to get the module
	/* This method will work if I've gotten a macro. */
	int dawt = type.indexOf('.');
	String name2 = type.substring(dawt+1);
	//      System.out.println("## CHECK: name: "+name2+"; type:"+type+
	//		 "; portInfo: "+portInfo);
	ManagerModel mod;
	m = ((ManagerModel)owner).getModule(name2);
	if(m == null) {
	  Enumeration e = ((ManagerModel)owner).getModuleManager().getModels();
	  String modelName = new String();
	  while (e.hasMoreElements()) {
	    mod = (ManagerModel)e.nextElement();
	    modelName = mod.getSystemName();
	    if(modelName.startsWith("Running")) {
	      modelName =modelName.substring(mod.getSystemName().indexOf("'")+1);
	      modelName = modelName.substring(0,modelName.indexOf("'"));
	      break;
	    }
	  }
	  e = ((ManagerModel)owner).getModuleManager().getModels();
	  while (e.hasMoreElements()) {
	    mod = (ManagerModel)e.nextElement();
	    if(mod.getSystemName().compareTo(modelName) == 0) {
	      m = mod.getModule(name2);
	      break;
	    }
	  }
	}
	
	MacroDescription cd = (MacroDescription)m.getAgentDescription();
	PortLocation pl;
	if(portType == 0) // -->input
	  pl = cd.getInputAgent(portNum);
	else
	  pl = cd.getOutputAgent(portNum);
	
	dawt = pl.getAgentName().indexOf('_');
	type =(String)("adaptive.agents."+pl.getAgentName().substring(0,dawt));
	
	/* ++++ should change once the other references to browserModel are 
	   taken care of */
	m = ((ManagerModel)owner).getModuleManager()
	  .getBrowserModel().getModule(type,source);
	
      }
      
      if(m != null) {
	/* Set up agent */
	agent = new PBAStub(side);
	Agent sillyAgent = m.getAgent();
	
	if(side == LEFT){
	  agent.setInputPort(sillyAgent.getInputPort(portNum),0);
	  /* <<<<<<< StubModule.java
	     agent.setInputPortName(m.getPortName(portInfo),0);
	     agent.setInputPortType(m.getPortType(portType,portNum),0);
	     =======
	  */
	  agent.setInputPortName(m.getPortName(portInfo.charAt(0)=='I'?
					       IOPort.INPUT:IOPort.OUTPUT,
					       Integer.parseInt
					       (portInfo.substring(1))),0);
	  agent.setInputPortType(m.getPortType(portInfo.charAt(0)=='I'?
					       IOPort.INPUT:IOPort.OUTPUT,
					       Integer.parseInt
					       (portInfo.substring(1))),0);
	  
	} else {
	  agent.setOutputPort(sillyAgent.getOutputPort(portNum),0);
	  agent.setOutputPortName(m.getPortName(portInfo.charAt(0)=='I'?
						IOPort.INPUT:IOPort.OUTPUT,
						Integer.parseInt
						(portInfo.substring(1))),0);
	  
	  agent.setOutputPortType(m.getPortType(portInfo.charAt(0)=='I'?
						IOPort.INPUT:IOPort.OUTPUT,
						Integer.parseInt
						(portInfo.substring(1))),0);
	}
	
	/* All agentDescription setting code should go here */
	agentDescription = new AgentDescription(name,
						"adaptive.core.PBAStub");
	
	if(side == LEFT){
	  agentDescription.setNumInputs(1);
	  agentDescription.setNumOutputs(0);
	} else {
	  agentDescription.setNumInputs(0);
	  agentDescription.setNumOutputs(1);
	}
	
	localInit();
	
      } else {
		  System.out.println("<stubMod:871> Couldn't find module of type "+type);
      }
    } catch (Exception exc) {
      System.err.println("ERROR(sddd): "+exc);
      //exc.printStackTrace();
    }
  }

}
