package adaptive.modulemanager;
import java.awt.*;


/**
  * StatusWindow displays a picture and a TextArea that contains all
  * the previous error/status messages.
  *
  * @author Yatish Patel
  * @version 1.0
  * $Log: StatusWindow.java,v $
  * Revision 1.2.4.1  2000/03/07 02:22:43  jrj
  * Changed layout and status listings so that stuff could resize properly.
  *
  *
  */
public class StatusWindow extends Frame
{
  private int[] stopSignX = new int[8];
  private int[] stopSignY = new int[8];
  private int[] stopSignBorderX = new int[8];
  private int[] stopSignBorderY = new int[8];
  private Font stopSignFont;
  private boolean isError=false;
  private TextArea status;
  private ModuleManager parent;
  private Font font;
  
  private TextField lblModuleName;
  private TextField lblClassName;
  private TextField lblPortType;
  private TextField lblPortName;
  
  private FunkyThread funkyThread;
  private boolean wink;
  
  public StatusWindow(ModuleManager p)
    {
      GridBagLayout gbl=new GridBagLayout();
      this.setLayout(gbl);
      GridBagConstraints gbc=new GridBagConstraints();
      Panel face=new Panel();
      face.setSize(10,10);
      setGBC(gbc,0,0,1,1,0,100);
      gbc.ipadx=70;
      gbl.setConstraints(face,gbc);
      add(face);
      gbc.ipadx=0;
      Panel display=new Panel();
      setGBC(gbc,1,0,3,1,0,100);
      gbc.fill=GridBagConstraints.BOTH;
      gbl.setConstraints(display,gbc);
      add(display);
      Panel statusLines=new Panel();
      setGBC(gbc,4,0,1,1,100,100);
      gbc.fill=GridBagConstraints.BOTH;
      gbl.setConstraints(statusLines,gbc);
      add(statusLines);
      statusLines.setLayout(new GridLayout(8,1));
      // String[] s=(Toolkit.getDefaultToolkit().getFontList());
      //for (int x=0;x<s.length;x++) 
      //	 System.out.println(s[x]);
      //   Label signPlaceHolder=new Label("               ");
      //face.add(signPlaceHolder);

      stopSignFont=new Font("SansSerif",Font.BOLD,20);
      font = new Font("SansSerif",Font.PLAIN,12);
      wink=false;
      
      // Define the coordinates for the stop sign. first the border
      // then the red part
      stopSignBorderX[0]=10;
      stopSignBorderX[1]=stopSignBorderX[0]+20;
      stopSignBorderX[2]=stopSignBorderX[1]+30;	 
      stopSignBorderX[3]=stopSignBorderX[2]+20;	
      stopSignBorderX[4]=stopSignBorderX[3];	
      stopSignBorderX[5]=stopSignBorderX[2];	
      stopSignBorderX[6]=stopSignBorderX[1];	
      stopSignBorderX[7]=stopSignBorderX[0];	
      
      
      stopSignBorderY[0]=65;
      stopSignBorderY[1]=stopSignBorderY[0]-20;
      stopSignBorderY[2]=stopSignBorderY[1];	 
      stopSignBorderY[3]=stopSignBorderY[0];	
      stopSignBorderY[4]=stopSignBorderY[0]+30;	
      stopSignBorderY[5]=stopSignBorderY[4]+20;	
      stopSignBorderY[6]=stopSignBorderY[5];	
      stopSignBorderY[7]=stopSignBorderY[4];
      
      stopSignX[0]=12;
      stopSignX[1]=stopSignX[0]+19;
      stopSignX[2]=stopSignX[1]+28;	 
      stopSignX[3]=stopSignX[2]+18;	
      stopSignX[4]=stopSignX[3];	
      stopSignX[5]=stopSignX[2];	
      stopSignX[6]=stopSignX[1];	
      stopSignX[7]=stopSignX[0];	
      
      
      stopSignY[0]=67;
      stopSignY[1]=stopSignY[0]-19;
      stopSignY[2]=stopSignY[1];	 
      stopSignY[3]=stopSignY[0];	
      stopSignY[4]=stopSignY[0]+27;	
      stopSignY[5]=stopSignY[4]+18;	
      stopSignY[6]=stopSignY[5];	
      stopSignY[7]=stopSignY[4];
      
      
      parent=p;
      setTitle("Status Window");
      //setLayout(null);
      
      status=new TextArea("",15,50,TextArea.SCROLLBARS_VERTICAL_ONLY);
      //status=new TextArea();
      status.setEditable(false);
      //status.setBounds(100,30,280,150);
      status.setFont(font);
      display.add(status);
      
      Label l = new Label("Module Name:");
      //	l.setBounds(385,30,115,15);
      l.setFont(font);
      statusLines.add(l);

      lblModuleName=new TextField("None Selected      ");
      lblModuleName.setEditable(false);
      //lblModuleName.setBounds(390,50,115,15);
      lblModuleName.setFont(font);
      statusLines.add(lblModuleName);
      
      l = new Label("Module Class:");
      //		l.setBounds(385,70,115,15);
      l.setFont(font);
      statusLines.add(l);
      
      lblClassName=new TextField("None Selected      ");
      lblClassName.setEditable(false);
      //lblClassName.setBounds(390,90,115,15);
      lblClassName.setFont(font);
      statusLines.add(lblClassName);
      
      l = new Label("Port Type:");
      //		l.setBounds(385,110,115,15);
      l.setFont(font);
      statusLines.add(l);
      
      lblPortType = new TextField("None Selected      ");
      lblPortType.setEditable(false);
      //lblPortType.setBounds(390,130,115,15);
      lblPortType.setFont(font);
      statusLines.add(lblPortType);
      
      l = new Label("Port Name:");
      //		l.setBounds(385,150,115,15);
      l.setFont(font);
      statusLines.add(l);
      
      lblPortName = new TextField("None Selected      ");
      lblPortName.setEditable(false);
      //		lblPortName.setBounds(390,170,115,15);
      lblPortName.setFont(font);
      statusLines.add(lblPortName);
      
      pack();
      //setSize(550,200);
      
      WindowListener windowListener=new WindowListener();	
      MouseListener mouseListener=new MouseListener();
      addMouseListener(mouseListener);
      addWindowListener(windowListener);
      
      
      funkyThread= new FunkyThread(this);
      funkyThread.start();
    }
  
  public StatusWindow(ModuleManager m,Font f) {
    this(m);
    font=f;
  }

  public void paint(Graphics g) {
    if (isError) {
      g.setColor(Color.white);
      g.fillPolygon(stopSignBorderX,stopSignBorderY,8);
      g.setColor(Color.red);
      g.fillPolygon(stopSignX,stopSignY,8);
      g.setColor(Color.black);
      
      g.setFont(stopSignFont);
      g.drawString("STOP",stopSignX[0]+7,stopSignY[7]-3);
    } else {
      
      g.setColor(Color.yellow);
      g.fillOval(stopSignBorderX[0],stopSignBorderY[1],stopSignBorderX[3]-stopSignBorderX[0],stopSignBorderY[6]-stopSignBorderY[1]);
      g.setColor(Color.black);
      
      if (wink) 
	g.drawLine(stopSignBorderX[1],stopSignBorderY[0]+3,stopSignBorderX[1]+8,stopSignBorderY[0]+3);
      else
	g.fillOval(stopSignBorderX[1],stopSignBorderY[0],8,8);
      
      g.fillOval(stopSignBorderX[2]-8,stopSignBorderY[0],8,8);
      g.drawArc(stopSignBorderX[1],stopSignBorderY[4]-10,stopSignBorderX[5]-stopSignBorderX[6],stopSignBorderY[6]-stopSignBorderY[7],0,-180);
    }
  }
  
  
  public void setWink(boolean t) {
    if (!isError) {
      wink=t;
      Graphics g=getGraphics();
      if (wink) {
	g.setColor(Color.yellow);
	g.fillOval(stopSignBorderX[1],stopSignBorderY[0],8,8);
	g.setColor(Color.black);
	g.drawLine(stopSignBorderX[1],stopSignBorderY[0]+3,stopSignBorderX[1]+8,stopSignBorderY[0]+3);
      }
      else {
	g.setColor(Color.yellow);
	g.drawLine(stopSignBorderX[1],stopSignBorderY[0]+3,stopSignBorderX[1]+8,stopSignBorderY[0]+3);				
	g.setColor(Color.black);
	g.fillOval(stopSignBorderX[1],stopSignBorderY[0],8,8);
      }
    }
  }
  protected void setGBC(GridBagConstraints gbc, int gx, int gy,
			int gw, int gh, int wx, int wy){
    //utility function for using GridBagLayout
    gbc.gridx=gx;
    gbc.gridy=gy;
    gbc.gridwidth=gw;
    gbc.gridheight=gh;
    gbc.weightx=wx;
    gbc.weighty=wy;
  }
  /**
    * Set the warning flag.
    *
    * @param warning True or false if there is a warning
    */
  public void setWarning(boolean warning) {
  }
  
  
  /**
    * Set the error flag.  
    *
    * @param error True or false if there is an error
    */
  public void setError(boolean error) {
    if (isError==error) return;
    isError=error;
    repaint();
  }
  
  /**
    *	Sets the status message in the box.
    *
    *	@param message The new status message.
    */
  public void setMessage(String message) {
    status.append(message+"\n\n");
	 }
  
  /**
    * Displays the name of the specified module in the window
    *
    * @param name The name of the Module
    */
  public void setModuleName(String name) {
    lblModuleName.setText(name);
  }
  
  /**
	  * Displays the class of the module in the window
	  *
	  * @param className The name of the class
	  */
  public void setModuleClass(String className) {
    lblClassName.setText(className);
  }
  
  /**
    * Displays the port type of the module in the window
    *
    * @param portType The type of port
    */
  public void setPortType(String portType) {
    lblPortType.setText(portType);
  }
  
  
  /******************************************************************
   * <!
   * Method: setPortName()
   *
   * Description:
   * >
   * Displays the port name of the module in the window
   * 
   * @param portName the name of port
   * 
   * @return
   *
   * @exception 
   ******************************************************************/
    public void setPortName(String portName) {
      	  lblPortName.setText(portName);
    }


  /**
    * Set the module info
    *
    * @param module The module
    */
  public void setStatusInfo(Module m) {
    setModuleName(m.getName());
    String moduleClass=m.getClassType();
    setModuleClass(moduleClass.substring(moduleClass.lastIndexOf(".")+1)); 
    setPortType("");
    setPortName("");
  }
  
  class MouseListener extends java.awt.event.MouseAdapter {
    public void mouseClicked(java.awt.event.MouseEvent event) {
      setError(false);
      if (event.getClickCount()>=3) {
	if (funkyThread.isAlive()) 
	  funkyThread.stop();
	else
	  funkyThread.start();
      }
    }
  }
  
  // Event listener classes
  class WindowListener extends java.awt.event.WindowAdapter
  {
    public void windowClosing(java.awt.event.WindowEvent event)
      {
	parent.closeStatusWindow();
	//((StatusWindow)event.getSource()).setVisible(false);
      }
  }
  
  
}

class FunkyThread extends Thread {
  StatusWindow statusWindow;
  
  public FunkyThread(StatusWindow p) {
    statusWindow = p;
  }
  public void run() {
    double randomNumber;
    while (true) {				
      randomNumber = Math.random();
      try {
	// Wink every 2-7 minutes..
	sleep(60*100*(2+(int)(randomNumber*7)));
	statusWindow.setWink(true);
	sleep(300);
	statusWindow.setWink(false);
	//System.out.println("wink");
      } catch (Exception e) {
	System.err.println(e);
      }
      
    }
  }
  
  
}
