package adaptive.modulemanager;

/**
 * State Editor interface to allow the agent to modify it's internal state.
 * The GUI will call editState when the user asks to edit the internal state.
 * One possible way to implement edit state would be to open a dialog box
 * that allows the user to edit specific fields.  Then save it all back to
 * the object and return it so the gui can save it in the configuration file.
 *
 * @version 1.0
 * @author Yatish Patel
 */
public interface StateEditor {
  
  //public Object getState();
  //public void setState();
  
  /** 
	* Once this function is called, the StateEditor object will be
	* responsible for interactions with the user, and saving the state
	* back to the module when the user is done.  Other possible actions
	* that may need to be taken include updating the displayed data (if
	* the user requests) and saving the state back to the module without
	* closing the window.  When saving the state back to the module, the
	* window should not be undisplayed until the data has been saved back
	* to the module without problems.  If there is an error while saving
	* the state, an error message should appear and the user must enter
	* valid data before allowed to close the window.
	*
	* @param parent The frame that will be the parent of the frame
	*               displayed by the state editor
	* @param mod The module whose state is to be edited.
	*/
  public void editState( adaptive.modulemanager.Module mod );
  
}
