package adaptive.modulemanager;
import java.awt.*;

/**
 * A rectangle class. The only difference between this and a normal awt
 * rectangle is this one allows negative widths and heights
 */
public class SelectRectangle extends Rectangle {
  
  public SelectRectangle(int x, int y, int w, int d) {
	 super(x,y,w,d);
  }
  
  public boolean contains(int x, int y) {	 
	 Rectangle t;
	 
	 if ((width<0) && (height>=0)) 
		t = new Rectangle(this.x+width,this.y,Math.abs(width),height);	
	 else if ((width<0) && (height<0)) 
		t = new Rectangle(this.x+width,this.y+height,Math.abs(width),Math.abs(height));	
	 else  if ((width>=0) && (height<0)) 
		t = new Rectangle(this.x,this.y+height,width,Math.abs(height));
	 else
		t = new Rectangle(this.x,this.y,width,height);

	 return t.contains(x,y);

  }
  
  public void draw(Graphics g) {
	 if ((width<0) && (height>=0)) 
		g.drawRect(this.x+width,this.y,Math.abs(width),height);	
	 else if ((width<0) && (height<0)) 
		g.drawRect(this.x+width,this.y+height,Math.abs(width),Math.abs(height));	
	 else  if ((width>=0) && (height<0)) 
		g.drawRect(this.x,this.y+height,width,Math.abs(height));
	 else
		g.drawRect(this.x,this.y,width,height);
	 
  }
  
  //public boolean contains(Point p) {
  // return this.contains(p.x,p,y);
  //}
  
	 
  
  
  
}
