/* This is the view that you see after hitting the "run" button on the 
 * ModuleManager */

package adaptive.modulemanager;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import adaptive.core.*;
import java.io.*;
import comms.core.*;

/* I think this class should be default exposure, and not public */
public class RunView extends View {
  
  private View activeView;
  private int debugLevel;
  private ModuleManager moduleManager;
  
  public RunView(ManagerModel m, ModuleManager p,View v, int dl){
    super(m,p);
    debugLevel = dl;
    activeView = v;
    moduleManager = p;
    System.out.println("<> Starting RunView...");
    startRunWindow(m);
  }

  private Vector makeMacroModels(Vector v, MacroDescription cd, Point p){
    AgentDescription ad, ad2;
    Enumeration e = cd.getAgents();
    Hashtable macroModels = new Hashtable();
    InputLocation il;
    ManagerModel mmodel, mod2;
    adaptive.modulemanager.Module remoteMod, newModule;
    String hostName, remoteHost;

    /* Place all the agents */
    while(e.hasMoreElements()) {
      ad = (AgentDescription)e.nextElement();
      newModule = moduleManager.getBrowserModel().getModule(ad.getType(), 
							    ad.getSource());
      newModule.setAgentDescription(ad);
      hostName = ad.getRunLocation();
      System.out.println(hostName);
      if(ad instanceof MacroDescription) {
	/* I dunno...  makeMacroModels(v,ad,p); */
      }
      if((mmodel = (ManagerModel)macroModels.get(hostName)) == null) {
	mmodel = new ManagerModel(moduleManager,debugLevel);
	mmodel.setSystemName(hostName);
      }
      for(int i = 0; i < ad.getNumInputs(); i++) {
	il = ad.getInputMapping(i);
	
	StubModule stan;
	if( (ad2 = cd.getAgent(il.getAgentID())) != null) {
	  /* It'll be null if the provider isn't in the macro */
	  remoteMod = new RectangleModule(ad2,debugLevel);
	  remoteHost = remoteMod.getHostName();
	  if(remoteHost.compareTo(hostName) != 0) {
	    /* then they're on different hosts */
	    /* (1) put this stub on the remote host */
	    if((mod2 = (ManagerModel)macroModels.get(remoteHost)) == null) {
	      mod2 = new ManagerModel(moduleManager,debugLevel);
	      mod2.setSystemName(remoteHost);
	    }
	    stan = new StubModule(ad.getType()+":"+
				  ad.getSource()+":I"+i,activeView.getModel(),
				  false,debugLevel);
	    stan.getAgentDescription().setInputMapping(new InputLocation(remoteMod.getName(),i,0),0);
	    
	    mod2.placeModule(p.x+remoteMod.getSize().width+20, 
			     p.y+(remoteMod.getSize().height/4),
			     stan.getName(), stan);
	    macroModels.put(remoteHost,mod2);
	    
	    /* (2) put a stub for the remote module on this host
	       (make a new stub for newmodule on hostname too) */
	    stan = new StubModule(ad2.getType()+":"+
				  ad2.getSource()+":O"+i,activeView.getModel(),
				  false,debugLevel);
	    newModule.getAgentDescription().setInputMapping(new InputLocation(stan.getName(),0,i),i);
	    
	    mmodel.placeModule(p.x-stan.getSize().width-20, 
			       p.y+(newModule.getSize().height/4),
			       stan.getName(), stan);
	  }
	} else {//if ad2  *is*  null
	  /*** I don't think this is actually possible with reasonable 
	       amounts of computation.  Either (1) this is just left out and 
	       the extra ports are empty, (2) macros are 'flattened' and 
	       don't show up as macros in the runtime view (perhaps with an 
	       "I'm-in-a-macro" label), (3) macros are reorganized and 
	       rewritten, or (4) a lot of GUI is reorganized and rewritten.
	  ***/
	  ;
	}
      }
      mmodel.placeModule(p.x, p.y, newModule.getName(), newModule);
      macroModels.put(hostName,mmodel);
    }
    
    /* Draw the lines */
    Enumeration modules, keez = macroModels.keys();
    while(keez.hasMoreElements()) {
      hostName = (String)keez.nextElement();
      mmodel = (ManagerModel)macroModels.get(hostName);
      modules = mmodel.getModules();
      while(modules.hasMoreElements()) {
		  newModule = (Module)modules.nextElement();
		  for(int i = 0; i < newModule.getNumInputs(); i++) {
			 il = newModule.getAgentDescription().getInputMapping(i);
			 if(il != null) { /* if it's null, it isn't mapped */
				remoteMod = mmodel.getModule(il.getAgentID());
				if(remoteMod == null) /* then it's not in this macro */
				  System.out.println("RemoteMod still null  :( ");
				else {
				  mmodel.drawLine(remoteMod, il.getOutputNum(),IOPort.OUTPUT);
				  mmodel.drawLine(newModule, i, IOPort.INPUT);
				}
			 }
		  }
      }  /* loop and get the next module in this model */
    }  /* loop and get new model */

    /* Make the macros and fill the vector to return */
    keez = macroModels.keys();
    while(keez.hasMoreElements()) {
      hostName = (String)keez.nextElement();
      mmodel = (ManagerModel)macroModels.get(hostName);
      mmodel.createInternalMapping();
      ConfigAndLayout cal = mmodel.toSystemConfiguration();
      Macro macro = new Macro(moduleManager,cal.systemConfiguration,
			      cal.layout,debugLevel);
      macro.setHostName(hostName);
      macro.setName(cd.getName());
      macro.setPrefix(hostName);
      /* I'm trying to get the prefix set to the host so that we can open 
			the macro (of the same name) on different hosts at the same time, 
			but it isn't working */
      //macro.setOwner(bruce);
      macro.generatePortTypes(moduleManager.getBrowserModel());
      v.addElement(macro);
    }

    return v;
  }
  
  /* Helper function for getting placement of the host macros in the 
     runWindow */
  private Point getHostPosition(int which, int total) {
    /* there isn't a constant I can use, but the default dimensions of a 
       module are 80x80.  The column width and row height include this and 
       spacing between the modules */
    int colWidth = 80+20;
    int rowHeight = colWidth;

    /* find the dimensions of the polygon (how many modules high/wide) */
    int height = (int)( (total+1)/2 );
    int width = height + (height % 2);

    int col;
    int row = (int)( (which+1)/2 );
    if( (which%2) == 0 ) { //then it's even and goes on the right half...
      col = (int)(width/2)-1 +row;
      if(row > height/2) //then it's in the bottom half
		  col = (int) width-(height/2 - (row-1)) -1;
    } else {
      col = (int)(width/2) -row;
      if(row > height/2) //then it's in the bottom half
		  col = (int) (height/2 - (row-1));
    }

    /* Position of this module */
    return (new Point((col+1)*colWidth, (row-1)*rowHeight));
  }


  /** Build a macro-like structure for each host and display in a new View.
    *
    * @param oldModel The ManagerModel for the System Edit view (which is 
    *   to be replaced by one for the Run Time view
    * <!--  by: Andrea Byrnes  -->
    */
  private void startRunWindow(ManagerModel oldModel) {
    ManagerModel newModel = new ManagerModel(moduleManager,debugLevel);
    newModel.setSystemName("Running '" + oldModel.getSystemName() + "'");    
    
    /* Holds a ManagerModel for each host, indexed by hostName */
    Hashtable runModels = new Hashtable(5);
    adaptive.modulemanager.Module currentModule, macroModule;
    ManagerModel manMod;
    String hostName = "";
    Enumeration macroADs;
    AgentDescription ad;
    int numHosts = 0;

    /* Go through all the modules in oldModel first and sort into
       ManagerModels by host. */
    for(Enumeration modules = oldModel.getModules();
		  modules.hasMoreElements();) {
      currentModule = (Module)modules.nextElement();
      
      /* If the macro is 'pegged', it is shown as a macro and not 
	 opened for the runtime view */
      if(currentModule instanceof Macro)
	if( !((Macro)currentModule).isPegged() ) {
	  Vector macros = new Vector();
	  /* So this is suppossed to be a function that recurses macros and 
	     makes a run-time view specific to each machine on which it has a 
	     piece running.  The vector returned will contain all the macros 
	     with their embedded run-time views (and then all we have to do 
	     back here is place them  :) */
	  macros = makeMacroModels(macros,
				   (MacroDescription)currentModule.getAgentDescription(),
				   currentModule.getLocation());
	  /* Place all the macros just made... */
	  for(int i = 0; i < macros.size(); i++) {
	    macroModule = (Macro)macros.elementAt(i);
	    /* Prefix isn't getting set correctly...  can't open the 
	       macro on more than one host at a time  :(  */
	    hostName = macroModule.getHostName();
	    if((manMod = (ManagerModel)runModels.get(hostName)) == null) {
	      manMod = new ManagerModel(moduleManager,debugLevel);
	      manMod.setSystemName(hostName);
	    }
	    manMod.placeModule(currentModule.getLocation().x, 
			       currentModule.getLocation().y, 
			       macroModule.getName(), macroModule);
	    runModels.put(manMod.getSystemName(),manMod);
	    
	  }
	  
	  continue;
	}
      /* The following code should be executed if the macro is pegged 
	 or if the module isn't a macro */
      hostName = currentModule.getHostName();
      /* If the ManagerModel is null, this hostName hasn't been found yet. */
      if((manMod = (ManagerModel)runModels.get(hostName)) == null){
	System.out.println("** "+moduleManager);
	manMod = new ManagerModel(moduleManager,debugLevel);
	++numHosts;
      }
      Point p = currentModule.getLocation();
      manMod.placeModule(p.x,p.y,currentModule.getName(),
			 (Module)currentModule.clone());
      
      runModels.put(hostName, manMod);
    } //ends module loop
    System.out.println();
    
    
    /* Put all the right stubs in all the right places.  Go through all 
       the models and look at all the ConnectLines on each of the modules. */
    Enumeration lines = oldModel.getLines();
    IOPort in, out;
    adaptive.modulemanager.Module inModule, outModule;
    /***/ int q = 0;
    while(lines.hasMoreElements()) {
      /* let's see if we can do this with just inputConnectLines... */
      ConnectLine cl = (ConnectLine)lines.nextElement();
      in = cl.getInputPort();
      out = cl.getOutputPort();
      inModule = in.getModule();
      outModule = out.getModule();
      if(inModule.getHostName().compareTo(outModule.getHostName()) != 0) {
	/* Different hosts */
	manMod = (ManagerModel)runModels.get(inModule.getHostName());
	currentModule =new StubModule(out,inModule.getHostName(),
				      out.getType(),manMod,debugLevel);
	currentModule.setHostName(outModule.getHostName());
	/* Figure out where to place the stub based on (1)where the port on 
	   the remote module is located in the module panel, and (2)what 
	   port number it is on the remote module so that the stubs can be 
	   staggered */
	Point p = outModule.getOutputLineLocation(out.getPort());
	currentModule.setLocation(p.x-20, p.y-20);
	if( (out.getPort() %2) == 0 ) 
	  currentModule.setLocation(p.x-40, p.y-20);
	p = currentModule.getLocation();
	/* Only place the stub if there's not already one there */
	if((macroModule = manMod.getModule(currentModule.getName())) == null)
	  manMod.placeModule(p.x,p.y,currentModule.getName(),currentModule);
	runModels.put(inModule.getHostName(),manMod);
	
	manMod = (ManagerModel)runModels.get(outModule.getHostName());
	currentModule = new StubModule(in,outModule.getHostName(),
				       in.getType(),manMod,debugLevel);
	currentModule.setHostName(inModule.getHostName());
	/* Figuring out the location for this stub now */
	p = inModule.getInputLineLocation(in.getPort());
	currentModule.setLocation(p.x+20, p.y-20);
	if( (in.getPort() %2) == 0 ) 
	  currentModule.setLocation(p.x+40, p.y-20);
	p = currentModule.getLocation();
	manMod.placeModule(p.x,p.y,currentModule.getName(),currentModule);
	runModels.put(outModule.getHostName(),manMod);
      }  /* end of if(different hosts) */
    }  /* end lines/(hosts) loop */
    
    /* Go through the lines in oldModel deciding which lines need to be
       drawn in the inner Models and which need to be drawn in the
       runtime view. */
    Hashtable macroLines = new Hashtable(10);
    lines = oldModel.getLines();
    adaptive.modulemanager.Module inMod, outMod, newInMod, newOutMod;
    while(lines.hasMoreElements()) {
      ConnectLine cl = (ConnectLine)lines.nextElement();
      outMod = cl.getOutputPort().getModule();
      inMod = cl.getInputPort().getModule();
      if(outMod.getHostName().compareTo(inMod.getHostName()) != 0) {
	/* Different hosts, so look for a stub... */
	manMod = (ManagerModel)runModels.get(outMod.getHostName());
	newOutMod = manMod.getModule(outMod.getName());
	newInMod = manMod.getModule(inMod.getClassType()+":"+
				    inMod.getAgentLocation()+":"+
				    cl.getInputPort().getPortString());
	if( (newOutMod instanceof Module) && (newInMod instanceof Module) ) {
	  /* Start drawing the line */
	  if(newOutMod.getName().compareTo(cl.getStartModule().getName()) == 0)
	    /* Same name, so this line "starts" at the output port */
	    manMod.drawLine(newOutMod, cl.getOutputPort().getPort(),
			    IOPort.OUTPUT);
	  else  /* The line "starts" at the input port */
	    manMod.drawLine(newInMod, 0,IOPort.INPUT);
	  
	  /* If there's more than 2 bends in cl, we should probably put them 
	     into the new line too.  They have to be done in order, which 
	     is why we make sure we get the right starting port above. */
	  ConnectLine newLine = manMod.getCurrentLine();
	  if(cl.getNumberOfBendPoints() > 2){
	    Enumeration bends = cl.getBendPoints();
	    while(bends.hasMoreElements())
	      newLine.addBend((Point)bends.nextElement());
	  }
	  
	  /* Stop drawing */
	  if(newOutMod.getName().compareTo(cl.getStartModule().getName()) == 0)
	    //same name
	    manMod.drawLine(newInMod, 0, IOPort.INPUT);	    
	  else
	    manMod.drawLine(newOutMod, cl.getOutputPort().getPort(),
			    IOPort.OUTPUT);
	}
	/* Don't forget to put the new-and-improved model in the Hashtable */
	runModels.put(outMod.getHostName(),manMod);
	
	/* Now repeat the process for the model of the other host */
	manMod = (ManagerModel)runModels.get(inMod.getHostName());
	newOutMod = manMod.getModule(outMod.getClassType()+":"+
				     outMod.getAgentLocation()+":"+
				     cl.getOutputPort().getPortString());
	newInMod = manMod.getModule(inMod.getName());
	if( (newOutMod instanceof Module) && (newInMod instanceof Module) ) {
	  /* Start drawing the line */
	  if(newOutMod.getName().compareTo(cl.getStartModule().getName()) == 0)
	    //same name
	    manMod.drawLine(newOutMod, 0, IOPort.OUTPUT);
	  else
	    manMod.drawLine(newInMod, cl.getInputPort().getPort(),
			    IOPort.INPUT);
	  
	  /* If there's more than 2 bends in cl, we should probably put them 
	     into the new line too... */
	  ConnectLine newLine = manMod.getCurrentLine();
	  if(cl.getNumberOfBendPoints() > 2){
	    Enumeration bends = cl.getBendPoints();
	    while(bends.hasMoreElements())
	      newLine.addBend((Point)bends.nextElement());   
	  }
	  
	  /* Stop drawing */
	  if(newOutMod.getName().compareTo(cl.getStartModule().getName()) == 0)
	    manMod.drawLine(newInMod, cl.getInputPort().getPort(),
			    IOPort.INPUT);
	  else
	    manMod.drawLine(newOutMod, 0, IOPort.OUTPUT);
	}
	/* Don't forget to put the new-and-improved model in the Hashtable */
	runModels.put(inMod.getHostName(),manMod);
	
	/* And store this line so it can be drawn in the main view */
	if(!macroLines.containsKey(outMod.getHostName()+inMod.getHostName()) &&
	   !macroLines.containsKey(inMod.getHostName()+outMod.getHostName()))
	  macroLines.put(outMod.getHostName()+inMod.getHostName(),cl);
      } else { /* Both ends of this line are on the same host */
	manMod = (ManagerModel)runModels.get(outMod.getHostName());
	/* Get the cloned modules */
	newOutMod = manMod.getModule(outMod.getName());
	newInMod = manMod.getModule(inMod.getName());
	if( (newOutMod instanceof Module) && (newInMod instanceof Module) ) {
	  /* Start drawing the line */
	  manMod.drawLine(newOutMod, cl.getOutputPort().getPort(),
			  cl.getOutputPort().getType());
	  /* Stop drawing */
	  manMod.drawLine(newInMod, cl.getInputPort().getPort(),
			  cl.getInputPort().getType());
	  /**/
	}
	/* Don't forget to put the new-and-improved model in the Hashtable */
	runModels.put(outMod.getHostName(),manMod);
      }
    } /* lines loop */

    
    /* Go through each model and get ConfigAndLayouts via 
       toSystemConfiguration() and make a HostMacro out of each one, placing
       it in the newModel with model.placeModule() */
    int x = 1;
    for(Enumeration hosts = runModels.keys();hosts.hasMoreElements();x++) {
      hostName = (String)hosts.nextElement();
      if((manMod = (ManagerModel)runModels.get(hostName)) != null) {
	manMod.createInternalMapping();
	ConfigAndLayout cal = manMod.toSystemConfiguration();
	HostMacro hm = new HostMacro(hostName, cal,moduleManager,debugLevel);
	hm.setOwner(newModel);
	Point p = getHostPosition(x,numHosts);
	newModel.placeModule(p.x,p.y,hostName,hm);
      }
    }
    
    moduleManager.openView(newModel, 
			   ("Running '"+oldModel.getSystemName()+"'"));
    
    int side = -1;
    Vector sides = new Vector();
    ConnectLine cl;
    lines = macroLines.keys();
    while(lines.hasMoreElements()) {
      cl = (ConnectLine)macroLines.get(lines.nextElement());
      outMod = newModel.getModule(cl.getOutputPort().getModule().getHostName());
      inMod = newModel.getModule(cl.getInputPort().getModule().getHostName());
      
      /*
	System.out.println("<> CHECK:: what's in the newModel??");
	for(Enumeration e = newModel.getModules();e.hasMoreElements();)
	System.out.println("  "+e.nextElement().getClass().getName());
      */
      
      side = ((HostMacro)outMod).addPort(cl);
      ((HostMacro)inMod).addPort(cl);
      sides.addElement(new Integer(side));
    }
    
    HostMacro start,end;
    lines = macroLines.keys();
    for(int i = 0;lines.hasMoreElements(); i++) {
      cl = (ConnectLine)macroLines.get(lines.nextElement());
      start = (HostMacro)newModel.getModule(cl.getOutputPort()
					    .getModule().getHostName());
      end = (HostMacro)newModel.getModule(cl.getInputPort()
					  .getModule().getHostName());
      
      side = ((Integer)sides.elementAt(i)).intValue();
      if(side == IOPort.OUTPUT) {
	newModel.drawLine(start,start.getNumOutputsMapped(),IOPort.OUTPUT);
	newModel.drawLine(end, end.getNumInputsMapped(), IOPort.INPUT);
      } else {
	newModel.drawLine(start,start.getNumInputsMapped(), IOPort.INPUT);
	newModel.drawLine(end, end.getNumOutputsMapped(), IOPort.OUTPUT);
      }
    }
    
    activeView.update(null, null); //this method doesn't use it's arguments...
    activeView.show();
    
  }


}
