package adaptive.modulemanager;

import java.io.IOException;
import java.net.Socket;
import java.net.ServerSocket;
import java.lang.InterruptedException;
import java.util.Vector;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import adaptive.core.*;
import adaptive.core.net.*;

public class Redirector extends Thread
{

  // To track how many Co-ordinators this module manager has
  // connected to..
  private int numberOfConnections;
  private Vector connections;

  // The server socket to accept connections. Open on
  // a specified port ?
  private ServerSocket serverSocket ;
  
  // If there is a default to open the serverSocket on
  // use this
  private int serverPort = 8700;
  // the socket to accept new connections
  private Socket incomingConnection;

  /** The constructor for the Redirector class
    *
    * @throws IOException - Thrown if the ServerSocket could not be opened
    */
  public Redirector() throws IOException
    {
      try {
      // Open the socket to accept connections
      serverSocket = new ServerSocket (serverPort);
      System.out.println("ServerSocket opened on "+serverPort);
      // Initialize the Vector to hold more than one connection.
      // Reasonable number of initial connections = 3(?) with a 
      // size increment of 5 
      connections = new Vector (3,5);
      }
      catch (IOException e )
	{
	  System.out.println ("Debugging Code : Failed to open a serverSocket on port "+ serverPort );
	  throw e;
	}

    }

 /** The constructor for the Redirector class
    *
    * @param userServerPort - Specify which port the Redirector should be working on
    * @throws IOException - Thrown if the ServerSocket could not be opened
    */
  public Redirector(int userServerPort) throws IOException
    {
      try {
      // Open the socket to accept connections
      serverSocket = new ServerSocket (userServerPort);

      // Initialize the Vector to hold more than one connection.
      // Reasonable number of initial connections = 3(?) with a 
      // size increment of 5 
      connections = new Vector (3,5);
      }
      catch (IOException e )
	{
	  System.out.println ("Debugging Code : Failed to open a serverSocket on port "+ userServerPort );
	  throw e;
	}
    }

  public static void main (String [] args )
    {

      boolean run = true;
      try
	{
	  Redirector red = new Redirector();
	  System.out.println("Starting Redirector now on port 8700");
	  red.start();
	}
      catch (IOException e)
	{
	  System.out.println("Debugging Code: IOException thrown when trying to instantiate a Redirector ");
	}
      System.out.println("Redirector up and running now");
     

    }

  // Accept connections to the Redirector from the ModuleManager
  // here. 
  public void run()
    {
      // TODO : accept a socket connection here using the ServerSocket.
      // Things to plan: 
      // 1. How to do bookkeeping.. track the number of connections 
      // made by a Module Manger to . 
      // 2. How do we die ?

      // Recovery on an Exception.. do we die ? do 


      numberOfConnections = 1 ;
      boolean loopforever = true;
      try {
	do
	  {
	    System.out.println("Waiting for a connection...");
	    incomingConnection = serverSocket.accept();
	    CoordinatorThread ct = new CoordinatorThread ( numberOfConnections , incomingConnection );
	    System.out.println("Accepted connection" + numberOfConnections );
	    connections.addElement ( ct );
	    numberOfConnections++;
	    ct.start();
	    // We have a connection from a Module Manager
	  }
	while ( loopforever == true );
      }
      catch  (IOException e)
	{
	  loopforever = false; // should not be required
	  System.out.println ("Debugging Code : The Server socket failed to accept");
	}

    }

}
  


class CoordinatorThread extends Thread
{
  Socket socket,cdrSocket;
  int coordNumber;
  
  

  CoordinatorThread ( int cn , Socket sck )
    {
      socket = sck;
      coordNumber = cn;
    }

  public void run()
    {
      ObjectInputStream ois = null;
      ObjectOutputStream oos = null;
      ObjectOutputStream cdrOutStream = null;
      ObjectInputStream cdrInStream = null;
      boolean success = false;
      Vector connectParams = null;
      String cdrHost ;
      int cdrPort;
      InputOutputThread cinfoTOcoord , coordTOcinfo;

      // Try communicating with the CoordinatorInfo instantiation here
      try 
	{
	  ois = new ObjectInputStream(socket.getInputStream());
	  oos = new ObjectOutputStream(socket.getOutputStream());
	  oos.flush();
	  System.out.println("Trying to identify a ModuleManager at the other end");
	  if ( HandshakeProtocol.goodSender (HandshakeProtocol.kIAMAMODULEMANAGER,HandshakeProtocol.kIAMAREDIRECTOR,ois,oos) )
	    {
	      success = true;
	      System.out.println("Handshake was successful");
	      // Now we have to get the object that has the information representing 
	      // The connection parmas are going to be a Vector of size 2. 
	      // The Vector contains - at location 0 - host (String)
	      //                     - at location 1 - port (Integer). 
	      connectParams = (Vector) ois.readObject();
	    }
	  else {
	    System.out.println("Bad ID at sender end...");
	    // Does the following return terminate the thread ?
	    return;
	  }
	}
      catch (Exception e ) // Catching both IOException and ClassNotFoundException
	{
	  System.out.println ("Debugging Code : Failed to communicate with the CoordinatorInfo part of \nthe ModuleManger in thread " + coordNumber);
	   try {
	     ois.close();
	     System.out.println("Debugging Code :Closed ois");
	   }
	   catch (IOException ioe) {
	     System.out.println("Debugging Code : Error closing ois");
	   }
	   try {
	     oos.close();
	     System.out.println("Debugging Code : Closed oos" );
	   }
	   catch (IOException ioe) {
	     System.out.println("Debugging Code :Error closing oos" );
	   }
	   try{
	     socket.close();
	     System.out.println("Debugging Code :Closed socket");
	   }
	   catch (IOException ioe) {
	     System.out.println("Debugging Code  Error closing socket" );
	   }
	   //Kill thread
	   return;
	}
      

      // if there was a success in connection with CoordinatorInfo, 
      if ( success == true )
	{
	  // Open streams with the Coordinator. Then thread the thing
	  // so that depending on information flow, it is redirected
	  // to the appropriate place
	  cdrHost = (String) connectParams.elementAt(0);
	  cdrPort = ((Integer) connectParams.elementAt(1)).intValue();
	  // Opening a connection to the Coordinator
	  try 
	    {
	      cdrSocket = new Socket(cdrHost,cdrPort);
	      
	      cdrOutStream = new ObjectOutputStream(cdrSocket.getOutputStream());
	      cdrInStream = new ObjectInputStream(cdrSocket.getInputStream());

	      // Set up two threads to redirect information.
	      cinfoTOcoord = new InputOutputThread ( ois , cdrOutStream );
	      coordTOcinfo = new InputOutputThread ( cdrInStream , oos );
	      cinfoTOcoord.start();
	      coordTOcinfo.start();
	    }
	  catch (Exception e)
	    {
	       System.out.println("Debugging Code  Unable to contact Coordinator at host "+cdrHost+" and at port " +cdrPort );
	    }
	  
	} // end if ( success == true )
      System.out.println("End of CoordinatorThread in Redirector reached.");
    }

}

class InputOutputThread extends Thread
{
  private ObjectInputStream ois = null;
  private ObjectOutputStream oos = null;
  boolean read = true;
  Object o;
  public InputOutputThread ( ObjectInputStream ois , ObjectOutputStream oos )
    {
      this.ois = ois;
      this.oos = oos;
    }

  public void run()
    {
      while ( read == true )
	{
	  try
	    {
	      o = ois.readObject();
	    }
	  catch (ClassNotFoundException e)
	    {
	      System.out.println("Debugging Code : Exception "+e+" thrown while trying to read");
	    }
	  catch (IOException e)
	    {
	      System.out.println("Debugging Code : Exception "+e+" thrown while trying to read Should shut down now.");	   
	      read = false;
	      
	      // Try to shut down the Object input stream.
	      try 
		{
		  ois.close();
		}
	      catch (IOException ex)
		{
		  System.out.println ("Error while closing ois");
		}
	       //  return;
	    }
	  try
	    {
	      oos.writeObject(o);
	      oos.flush();
	    }
	  catch (IOException e)
	    {
	      System.out.println("Debugging Code : Exception "+e+" thrown while trying to write Should shut down now.");

	      // Try to close down the object output stream
	      try 
		{
		  oos.close();
		}
	      catch (IOException ex)
		{
		  System.out.println ("Error while closing ois");
		}
	      
	      try 
		{
		  ois.close();
		}
	      catch (IOException ex)
		{
		  System.out.println ("Error while closing ois in oos");
		}

	      return;
	    }

	  if ( read == false )
	    {
	      try
		{ 
		  oos.close();
		}
	      catch (IOException e)
		{
		  // System.out.println ("Error while closing ois");
		}

	      

	    }
	}
    }
}
