/*
	Module Class
	By: Yatish Patel
*/

package adaptive.modulemanager;
import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;
import java.awt.event.*;
import adaptive.core.*;
import java.lang.reflect.*;

/**
 * RectangleModule class
 *
 * Draws a rectangular module
 *
 * @author Yatish Patel <yatish@cmu.edu>
 * @version 1.0
 * $Log: RectangleModule.java,v $
 * Revision 1.4.2.9  2000/06/06 00:23:27  jrj
 * changed so it will synchronize the ports with the Agent when it loads
 * a file. also flipped around the appearance of the output ports.
 *
 * Revision 1.4.2.8  2000/05/20 19:11:36  jrj
 * fixed a couple more macro bugs.  Took preliminary steps toward making
 * fully recursive macros in MacroDescription.  Have not yet made changes
 * that would damage save file.
 *
 * Revision 1.4.2.7  2000/05/18 04:17:17  jrj
 * changed ports to be more arrow shaped
 *
 * Revision 1.4.2.6  2000/05/15 22:40:01  jrj
 * Made fixes to macros so that they work.  Changed the executing macro
 * so that it is recursive, can be manipulated as a whole, and its ports
 * can be asked for directly as if it were any other BasicPortAgent.
 * Made several other changes to simplify and assist these changes.
 * Finally purged the last remaining bit of things named clump.
 *
 */
public class RectangleModule extends adaptive.modulemanager.Module 
{


  
  public RectangleModule(int debugLevel) {
    super(debugLevel);
    agentDescription.setNumInputs(1);
    agentDescription.setNumOutputs(1);
		  
  }
  public RectangleModule(Agent a,int debugLevel)
    {
      super(a,debugLevel);
    }

  public RectangleModule(boolean b,int debugLevel) {
    super(b,debugLevel);
  }
  
  public RectangleModule(Module m,int debugLevel) {
    super(m,debugLevel); 
  }

  /* Added by Andrea so that we can make modules from AgentDesctiptions */
  public RectangleModule(AgentDescription ad,int debugLevel) {
    super(ad,debugLevel); 
  }



  /*
    public RectangleModule(Class c) {
    super(c);
    }

    public RectangleModule(Object p,String mID,String name,int i, int o)
    {
    super(p,mID,name,i,o);
    }
  */

  protected void localInit() {
    resizeShape = new Rectangle();
    moveShape = new Rectangle();
    resizeModule(moduleSize.width,moduleSize.height);
    //moduleClass=getClass().getName();
    // Create the resize rectangle, when the users mouse cursor is
    // over this rectangle the module will be resized if the user
    // clicks and drags.
    //resizeShape= new Rectangle(moduleSizeX-(Xinset)-6,moduleSizeY-(Yinset)-6,5,5);

    // The move shape is the same as the resize, if the user clicks
    // and drags and he is over the move shape, the module will be
    // moved.
    //moveShape=new Rectangle(Xinset+1,Yinset,moduleSizeX-(Xinset*2)-2,moduleSizeY-(Yinset*2)-1);
  }

  public Object clone() {
      RectangleModule rt= new RectangleModule(this,debugLevel);
      return rt;
      // return cloneSerializableObject(this);
  }

  /**
    * Draw text inside the module.  Will display either the name
    * of the module, or the module class.  When this method is called
    * from paint() the offset is 0.  When this method 
    *
    * @param g The graphics context of the module
    * @param offset The offset of the module.
    * @param highlight whether or not the module is highlighted
    */
  protected void drawText(Graphics g, Point offset,boolean highlight) {
    g.setFont(labelBoxFont);

    // If the module is in the toolbar, than display it's class, otherwise
    // we don't want to see the class name
    String moduleClass=agentDescription.getType();
    if ((moduleClass !=null) && (owner instanceof BrowserModel))
				// Get the agent name after the first two dots
				// ie: adaptive.agents.PBAgent -> PBAgent
      //      g.drawString(moduleClass.substring(moduleClass.indexOf(".",moduleClass.indexOf(".")+1)+1),Xinset+3+offset.x,moduleSize.height/2+4+offset.y);
      g.drawString(moduleClass.substring(moduleClass.lastIndexOf(".")+1),Xinset+3+offset.x,moduleSize.height/2+4+offset.y);
    // If the module has a name display it.
    if (agentDescription.getName() !=null) 
      g.drawString(agentDescription.getName(),Xinset+4+offset.x,moduleSize.height/2+4+offset.y);		  
  }



  /**
    * Draw the outline and/or other graphics the module requires
    * to be displayed on the canvas.
    *
    * @param g The graphics context of the module
    * @param offset The offset of the module on the screen
    * @param highlight whether or not to highlight to module
    */
  protected void drawModuleGraphics(Graphics g, Point offset,boolean highlight) 
    {
      int x;
      int lineY;



      if (highlight) {
	g.setColor(backSelectedColor);
	g.fillRect(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
	g.setColor(selectedColor);
	g.drawRect(Xinset+2+offset.x,Yinset+1+offset.y,moduleSize.width-(Xinset*2)-4,moduleSize.height-(Yinset*2)-3);
      } else {
	g.setColor(backgroundColor);
	g.fillRect(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
	g.setColor(normalColor);

      }
      // draw the rectangle.  this is also used in the mousemoved part
      // so if you change this, change the part in mousemoved.

			 
      g.drawRect(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);

	  
      for (x=0;x<agentDescription.getNumInputs();x++) {
	drawPortLine(g,offset,IOPort.INPUT,x,false);
      }
      for (x=0;x<agentDescription.getNumOutputs();x++) {
	drawPortLine(g,offset,IOPort.OUTPUT,x,false);
      }
      g.setColor(normalColor);		  
    }
  /**
    *	Get the location of where we should draw the line to connect the
    *	specified input port.  
    *
    *	@return a Point in the parents coordinate system.
    */
  protected Point getInputLineLocation(int inputNumber)
    {
      Point p = getLocation();		
      return (new Point(p.x,(inputNumber+1)*inputLineSpacing+p.y));		 
		  
    }

  /**
    *	Get the location of where we should draw the line to conenct the
    *	specified output port.
    *
    *	@return a Point in the parent's coordinate system.
    */
  protected Point getOutputLineLocation(int outputNumber)
    {
      //System.out.println("correct");
      Point p = getLocation();
      return (new Point(p.x+moduleSize.width,p.y+(outputNumber+1)*outputLineSpacing));
    }

  /**
    * Draw a port line.
    *
    * @param g The graphics context for this module.
    * @param o The offset of the module
    * @param type The type of port input/output
    * @param port The port number
    * @param highlight Is the line highlighted
    */
  protected void drawPortLine(Graphics g, Point o,int type, int port,boolean highlight)
    {
      int mouthWidth=minInputLineSpacing-2;
      Point p = new Point();
      Point temp;
      Point l=getLocation();
      if (type==IOPort.INPUT) {
	p= getInputLineLocation(port);  
	p.x=p.x-l.x;  
	p.y=p.y-l.y;  
	l.x=p.x+Xinset;  //reuse l as closed end of >
	l.y=p.y;              
      } else if (type==IOPort.OUTPUT) {  
	p= getOutputLineLocation(port);		 	
	p.x=p.x-l.x;
	p.y=p.y-l.y;  
	l.x=p.x-Xinset;  //reuse l as closed end of >
	l.y=p.y; 
	temp=l;//turn it around
	l=p;
	p=temp;
	  
      }  

      /*     g.drawLine(p.x+o.x,p.y+o.y,l.x+o.x,p.y+o.y);    
      if (highlight) {   
	g.drawLine(p.x+o.x,p.y-1+o.y,l.x+o.x,p.y-1+o.y);   
	g.drawLine(p.x+o.x,p.y+1+o.y,l.x+o.x,p.y+1+o.y);   
	}  
      */

      //draw port
      g.drawLine(o.x+p.x,o.y+p.y+mouthWidth,o.x+l.x,o.y+l.y);
      g.drawLine(o.x+p.x,o.y+p.y-mouthWidth,o.x+l.x,o.y+l.y);

      if (highlight){
	  g.drawLine(o.x+p.x,o.y+p.y+mouthWidth-1,o.x+l.x,o.y+l.y);
	  g.drawLine(o.x+p.x,o.y+p.y-mouthWidth+1,o.x+l.x,o.y+l.y);
	  g.drawLine(o.x+p.x,o.y+p.y+mouthWidth-2,o.x+l.x,o.y+l.y);
	  g.drawLine(o.x+p.x,o.y+p.y-mouthWidth+2,o.x+l.x,o.y+l.y);
      }
    }	  


  /**
    * Resize the module to the spcified size.
    *
    * @param x X coordinate of the point to check.
    * @param y Y coordinate of the point to check. 
    */
  public void  resizeModule(int x, int y) {

    x=x;
    y=y;
		
    moduleSize.width=x;
    moduleSize.height=y;
    setSize(moduleSize.width,moduleSize.height);
    ((Rectangle)resizeShape).setBounds(moduleSize.width-(Xinset)-6,moduleSize.height-(Yinset)-6,5,5);
    ((Rectangle)moveShape).setBounds(Xinset+1,Yinset,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
		  
		  
    // now we need to determine a good linespacing for the port lines
		  
    // First try and place each line with the default line spacing
    int lastLineLoc=(agentDescription.getNumInputs()+1)*minInputLineSpacing;
    if (lastLineLoc<=moduleSize.height-2) {
				// There is enough space so we should try and center
				// the lines
      if (getNumInputs()>0)
	inputLineSpacing=moduleSize.height/(getNumInputs()+1);
    } else 
      inputLineSpacing=minInputLineSpacing;

    lastLineLoc=(getNumOutputs()+1)*minOutputLineSpacing;
    if (lastLineLoc<=moduleSize.height-2) {
      if (agentDescription.getNumOutputs()>0)
	outputLineSpacing=moduleSize.height/(getNumOutputs()+1);
    } else
      outputLineSpacing=minOutputLineSpacing;

    if (!initialized) return;
    addLineRectangles();
    adjustConnectLines();
    if (owner instanceof ModuleManager) 
      ((ModuleManager)owner).repaint();
    //System.out.println("in="+inputLineSpacing+" out="+outputLineSpacing);
  }






}
