package adaptive.modulemanager;
import java.util.Vector;

/**
 * Multiple mapping allows more than one mapping per port.  We need
 * this for the outputs because each output can have any number of
 * inputs that it feeds.
 */
public class MultipleMapping implements  java.io.Serializable 
{

	private Vector data;
	
  /**
	 * Create a new MultipleMapping of a given size
	 *
	 * @param size The size of the MultipleMapping
	 */
	public MultipleMapping(int size) {	
	  data = new Vector(size);
	  for (int x=0;x<size;x++)
		 data.addElement(null); 
	}

  /**
	 *	Returns the mapping to a specific port in this mapping.
	 *
	 * @param portNumber the port to get the mapping of
	 * @return The mapping for the specified port
	 */
	public IOPort getMap(int portNumber)
	{
		return (IOPort)data.elementAt(portNumber);
	}

  /**
	 *	Returns the number of mapped inputs/outputs in this mapping.
	 *
	 * @return the number of mappings
	 */
	public int numMapped()
	{
		return data.size();
	}

	/*
	*	Set the mapping for a specific port
	*/
  /*
	public void setMap(int portNumber,Module m, String port)
	{
		 if (data.elementAt(portNumber)!=null) {
			  Vector v = (Vector)data.elementAt(portNumber);
			  v.addElement(new IOPort(m,port));
		 } else {
			  Vector v = new Vector(3,3);
			  v.addElement(new IOPort(m,port));
			  data.setElementAt(v,portNumber);
		 }
	}
	*/

  /**
	 *	Set the mapping for a specific port
	 *
	 * @param portNumber the port number to map
	 * @param port the port to map to
	 */
	public void setMap(int portNumber,IOPort port)
	{
		 if (data.elementAt(portNumber)!=null) {
			  Vector v = (Vector)data.elementAt(portNumber);
			  v.addElement(port);
		 } else {
			  Vector v = new Vector(3,3);
			  v.addElement(port);
			  data.setElementAt(v,portNumber);
		 }

//data.setElementAt(port,portnum);
	}

	 public void removeMap(int portnum)
	 {
		  data.setElementAt(null,portnum);
	 }

}
