package adaptive.modulemanager;
import java.awt.*;
import adaptive.core.*;
import java.awt.event.*;

public class ModuleToolbar extends Frame
{
  private adaptive.modulemanager.Module selectedModule;
  private Label status;
  private ModuleManager parent;
  public ScrollPane scrollPane;
  private Panel modulePanel;
  private int panelX = 1000;
  private int panelY = 1000;
  private GridBagConstraints constraints;
  private Font font;

	public ModuleToolbar(ModuleManager p)
	{
		parent=p;
		selectedModule=null;
		setTitle("Module Toolbar");
		//setSize(150,400);
		setLayout(new BorderLayout());

		scrollPane = new ScrollPane();
		//validate();
		//pack();
		//		setLayout(null);
		//scrollPane.setLayout(new FlowLayout());
		//scrollPane.setSize(150,400);
		/*
		  constraints=new GridBagConstraints();
		  constraints.weightx=0;
		  constraints.weighty=0;
		  constraints.gridwidth=1;
		  constraints.gridheight=1;		
		  constraints.gridx=GridBagConstraints.RELATIVE;
		  constraints.gridy=GridBagConstraints.RELATIVE; 
		*/
		modulePanel=new Panel();
		modulePanel.setLayout(new ModuleLayout(ModuleLayout.VERTICAL));
		//modulePanel.setSize(150,400);
		//scrollPane.setSize(150,400);
		scrollPane.add(modulePanel);
		scrollPane.doLayout();
		
		scrollPane.setLocation(8,30);
		add(scrollPane,"Center");
		pack();
		setSize(150,400);
		MouseListener mouseListener = new MouseListener();
		ComponentListener componentListener = new ComponentListener();
		WindowListener windowListener=new WindowListener();	
		KeyListener keyListener=new KeyListener();
		modulePanel.addKeyListener(keyListener);
		addKeyListener(keyListener);
		addWindowListener(windowListener);
		addComponentListener(componentListener);
		modulePanel.addMouseListener(mouseListener);
	}

  public ModuleToolbar(ModuleManager m,Font f) {
	 this(m);
	 font=f;
  }

	 public void addModule(Module a)
	 {
		  modulePanel.add(a,constraints);
		  
	 }


	 /**
	  * Clears all the modules from the toolbar
	  */
	 public void clear() {
		  modulePanel.removeAll();
		  modulePanel.repaint();
		  
	 }


	 /**
	  * Selects the specified agent and highlights it so the user knows
	  * what he clicked.
	  */
	 public void selectAgent(Module m)
	 {
		// if the same agent was selected than deselect it
		if (selectedModule==m) {
		  //parent.selectAgent(null);
		  selectedModule=null;
		  return;
		}
		//else 
		  //parent.selectAgent(m);
		
		// If something else is selected, unselect it before selecting
		// the new module
		if (selectedModule!=null) {
		  selectedModule.setSelected(false);
		}
		
		selectedModule=m;
		if (m!=null) m.setSelected(true);
		
	 }
  
  public adaptive.modulemanager.Module getSelectedModule() {
	 System.out.println("returning "+selectedModule);
	 return selectedModule;
  }
  
  public void resizeScrollPane (Dimension d) {
		//System.out.println(d);
		// panelX=d.width-15;
	 //scrollPane.setSize(d.width-15,d.height-40);
	 //modulePanel.setSize(d.width-15,panelY);
	 modulePanel.setSize(d.width-15,d.height-40);
	 
		scrollPane.doLayout();		
		pack();	  		
	 }

   // Event listener classes
   class WindowListener extends java.awt.event.WindowAdapter
   {
      public void windowClosing(java.awt.event.WindowEvent event)
      {
			parent.closeModuleToolbar();
         //((StatusWindow)event.getSource()).setVisible(false);
      }
		 
   }
	class ComponentListener extends java.awt.event.ComponentAdapter
	{
		 public void componentResized(java.awt.event.ComponentEvent evt)
		 {
			  Component c = evt.getComponent();
			  resizeScrollPane(c.getSize());		  
		 }
	}
  class KeyListener extends KeyAdapter
  {
	 /*
	  * Triggered whenever a key is pressed 
	  */
	 public void keyPressed(KeyEvent evt)
	 {
		parent.dispatchEvent(evt);
		
	 }
  }  
  class MouseListener extends MouseAdapter {
	 public void mouseClicked(java.awt.event.MouseEvent evt) {
		Panel p =(Panel)evt.getComponent();
		Component c=p.getComponentAt(evt.getX(),evt.getY());
		if (c instanceof Module) {
		  selectAgent((Module)c);
		  parent.setCurrentTool(parent.PLACE);
		}
		
		
		
	 }
  }
  
}
