package adaptive.modulemanager;

import adaptive.core.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Enumeration;

/*****************************************************************************
 *
 * Copyright 2000, Institute for Complex Engineered Systems,
 *                 Carnegie Mellon University
 * PROJECT: Self-adaptive Software
 * DESCRIPTION: properties for a module in Module Manager
 *
 * @author Yatish?
 *
 * REVISION HISTORY:
 *
 * $Log: ModulePropertiesWindow.java,v $
 * Revision 1.6.2.8  2000/05/15 22:40:01  jrj
 * Made fixes to macros so that they work.  Changed the executing macro
 * so that it is recursive, can be manipulated as a whole, and its ports
 * can be asked for directly as if it were any other BasicPortAgent.
 * Made several other changes to simplify and assist these changes.
 * Finally purged the last remaining bit of things named clump.
 *
 * Revision 1.6.2.7  2000/04/28 04:14:37  jrj
 * rewrote part of the state editing stuff so that it works like it
 * should and so that agents actually can provide their own state editor
 *
 *
 * 
 ****************************************************************************/
public class ModulePropertiesWindow extends Frame implements ActionListener, ItemListener
{

  /** The module we're looking at */
  private adaptive.modulemanager.Module module;

  private Enumeration moduleList;
  
  /** choice box to choose either input or output */
  private Choice lstType;

  /** The location of the agent */
  private Choice lstLocation;
  /** The run mode capability of this module **/
  private Choice runMode;
  /** The parent model */
  private ManagerModel parent;

  /** List of all input/output  numbers */
  private List lstIO;
  /** List of all groups */
  private List lstGroups;
  /** textbox that holds the selected ports/groups */
  private TextField txtPorts;
  /** The name of the module */
  private TextField txtModuleName;
  /** The host where the agent will run */
  private TextField txtHostName;

  private TextField txtModuleSizeX,txtModuleSizeY;
  
  private Label lblType;
  private Label lblGroup;
  private Font font;
  private List lstInputPortNames,lstOutputPortNames;
  private TextField txtInputPortName,txtOutputPortName;
  private Button btnInputChange,btnOutputChange;
  
  public ModulePropertiesWindow(Object m,ManagerModel pr,int x,int y)
  {
	 //module=m;
	 parent=pr;

	 font = new Font("SansSerif",Font.PLAIN,12);
	 //setLayout(new BorderLayout());
	 setLayout(new GridBagLayout());
	 //setBounds(x,y,250,360);
	 setLocation(x,y);
	 setFont(font);
	 
	 GridBagConstraints cLabel= new GridBagConstraints();
	 GridBagConstraints cText = new GridBagConstraints();	 
	 GridBagConstraints cBox = new GridBagConstraints();
	 GridBagConstraints cButton = new GridBagConstraints();
	 // don't expand at all
	 cLabel.weightx=0;
	 cLabel.weighty=0;
	 cLabel.fill=GridBagConstraints.BOTH;
	 cLabel.anchor=GridBagConstraints.WEST;
	 
	 
	 // only expand in the x direction
	 cText.weightx=100;
	 cText.weighty=0;
	 cText.fill=GridBagConstraints.BOTH;
	 cText.anchor=GridBagConstraints.WEST;
	 cText.insets=new Insets(0,5,0,5);
	 
	 // expand in both x and y
	 cBox.weightx=100;
	 cBox.weighty=100;
	 cBox.fill=GridBagConstraints.BOTH;
	 cBox.insets=new Insets(0,3,0,3);

	 cButton.weightx=0;
	 cButton.weighty=0;
	 cButton.fill=GridBagConstraints.BOTH;
	 cButton.anchor=GridBagConstraints.CENTER; 
	 //Panel north = new Panel();
	 // setLayout(new GridLayout(4,2));

	 Label l = new Label("Name:");
	 //l.setBounds(7,30,50,32);
	 l.setFont(font);
	 add(l,1,1,1,1,cLabel);
		  
	 txtModuleName = new TextField();
	 //txtModuleName.setBounds(60,30,185,32);
	 txtModuleName.setFont(font);
	 add(txtModuleName,2,1,2,1,cText);

         l = new Label("Run Mode:");
         l.setFont(font);
         add(l,1,2,1,1,cLabel);

         runMode = new Choice();
         add(runMode,2,2,3,1,cText);
         
	 l = new Label("Location:");
	 //l.setBounds(7,63,55,32);
	 l.setFont(font);
	 add(l,1,3,1,1,cLabel);
         
	 lstLocation=new Choice();
	 lstLocation.add("Local File System");
	 lstLocation.add("Agent Server");
	 //lstLocation.setBounds(70,63,180,32);
	 add(lstLocation,2,3,3,1,cText);


	 l = new Label("Host:");
	 //l.setBounds(7,100,30,35);
	 l.setFont(font);
	 add(l,1,4,1,1,cLabel);

	 l = new Label("Size:");
	 //l.setBounds(7,135,50,35);
	 l.setFont(font);
	 add(l,1,5,1,1,cLabel);

	 Panel sizePanel = new Panel();
	 sizePanel.setLayout(new FlowLayout(FlowLayout.LEFT));

	 txtModuleSizeX = new TextField(4); 
	 //txtModuleSizeX.setBounds(60,135,40,35);
	 txtModuleSizeX.setFont(font);
	 sizePanel.add(txtModuleSizeX);	  

	 l = new Label("X");
	 //l.setBounds(103,135,10,35);
	 l.setFont(font);
	 sizePanel.add(l);	
	  
	 txtModuleSizeY = new TextField(4);
	 //txtModuleSizeY.setBounds(120,135,40,35);
	 txtModuleSizeY.setFont(font);
	 sizePanel.add(txtModuleSizeY);

	 add(sizePanel,2,5,2,1,cText);
	 
	 txtHostName = new TextField("No Change");
	 //txtHostName.setBounds(60,90,185,30);
	 txtHostName.setFont(font);
	 add(txtHostName,2,4,2,1,cText);

	 l = new Label("Input Port        Name");
	 //l.setBounds(7,150,120,30);
	 l.setFont(font);
	 add(l,1,6,3,1,cLabel);

	 lstInputPortNames = new List();
	 lstInputPortNames.setFont(font);
	 //lstInputPortNames.setBounds(7,180,235,100);
	 lstInputPortNames.addItemListener(this);
	 add(lstInputPortNames,1,7,3,4,cBox);

	 txtInputPortName= new TextField("");
	 txtInputPortName.setFont(font);
	 //txtInputPortName.setBounds(7,285,175,30);
	 txtInputPortName.addActionListener(this);
	 add(txtInputPortName,2,11,2,1,cText);
	 
	 btnInputChange = new Button("Change");
	 btnInputChange.setFont(font);
	 // btnInputChange.setBounds(185,285,60,30);
	 btnInputChange.addActionListener(this);
	 add(btnInputChange,1,11,1,1,cButton);

	 l = new Label("Output Port        Name");
	 //l.setBounds(7,150,120,30);
	 l.setFont(font);
	 add(l,1,12,3,1,cLabel);

	 lstOutputPortNames = new List();
	 lstOutputPortNames.setFont(font);
	 //lstOutputPortNames.setBounds(7,180,235,100);
	 lstOutputPortNames.addItemListener(this);
	 add(lstOutputPortNames,1,13,3,4,cBox);

	 txtOutputPortName= new TextField("");
	 txtOutputPortName.setFont(font);
	 //txtOutputPortName.setBounds(7,285,175,30);
	 txtOutputPortName.addActionListener(this);
	 add(txtOutputPortName,2,17,2,1,cText);
	 
	 btnOutputChange = new Button("Change");
	 btnOutputChange.setFont(font);
	 // btnInputChange.setBounds(185,285,60,30);
	 btnOutputChange.addActionListener(this);
	 add(btnOutputChange,1,17,1,1,cButton);

	 // If we are only dealing with one module, then set all the info
	 // in the fields
	 if (m instanceof Module) {
		module=(Module)m;
		Dimension d=module.getSize();
		setTitle("Type: "+module.getClassType().substring(module.getClassType().indexOf(".",module.getClassType().indexOf(".")+1)+1));
		txtHostName.setText(module.getHostName());
		txtModuleSizeY.setText(String.valueOf(d.height));
		txtModuleSizeX.setText(String.valueOf(d.width));
                if( (module.getRunModeCapability() &
                     Agent.LOOP_ONLY) != 0) {
                  runMode.add("Loop Only");
                }
                if( (module.getRunModeCapability() &
                     Agent.EVENT_ONLY) != 0) {
                  runMode.add("Event Only");
                }
                if( (module.getRunModeCapability() ==
                     Agent.EVENT_OR_LOOP) ) {
                  runMode.add("Loop Or Event");
                }
                switch(module.getRunMode()) {
                  case Agent.LOOP_ONLY:
                    runMode.select("Loop Only");
                    break;
                  case Agent.EVENT_ONLY:
                    runMode.select("Event Only");
                    break;
                  case Agent.EVENT_OR_LOOP:
                    runMode.select("Loop Or Event");
                    break;
                }
                
		lstLocation.select(module.getAgentLocation());
		if (module.getName()!=null) txtModuleName.setText(module.getName());
		StringBuffer sb= new StringBuffer("     ");
		for (int k=0;k<module.getNumInputs();k++) {
		  sb=sb.insert(0,String.valueOf(k));
		  sb.setLength(5);
		  lstInputPortNames.add(sb.toString()+"          "+module.getInputPortName(k));
		  // System.out.println("k="+k+" "+module.getInputPortName(k));
		  sb=new StringBuffer("     ");
		}
		for (int k=0;k<module.getNumOutputs();k++) {
		  sb=sb.insert(0,String.valueOf(k));
		  sb.setLength(5);
		  lstOutputPortNames.add(sb.toString()+"          "+module.getOutputPortName(k));
		  // System.out.println("k="+k+" "+module.getInputPortName(k));
		  sb=new StringBuffer("     ");
		}
		
	 } else if (m instanceof Enumeration) {
		// if we are dealing with multiple modules, then don't set the info
		// because it could be different for the different modules.
		moduleList=(Enumeration)m;
		module=null;
		txtModuleName.setEnabled(false);
		txtModuleName.setText("Multiple Selected");
                runMode.setEnabled(false);
		lstLocation.add("No Change");
		lstLocation.select(2);
		lstInputPortNames.setEnabled(false);
		btnInputChange.setEnabled(false);
		txtInputPortName.setEnabled(false);
		setTitle("Module Properties");
	 }
	 

	 /*
		lstType=new Choice();
		lstType.add("Input");
		lstType.add("Output");
		lstType.setBounds(65,85,100,30);
		lstType.addItemListener(this);
		lstType.setFont(font);
		add(lstType);
		  

		l = new Label("Number/Label:");
		l.setBounds(7,120,82,30);
		l.setFont(font);
		add(l);

		txtPorts = new TextField();
		txtPorts.setBounds(90,120,150,30);
		txtPorts.setFont(font);
		add(txtPorts);
	 */
	 //Panel center = new Panel();
	 //center.setLayout(new GridLayout(1,3));
		  
	 Button b = new Button("Edit State");
	 //b.setBounds(10,325,80,30);
		  
	 //b.setEnabled(false);
	 b.addActionListener(this);
	 add(b,1,18,1,1,cButton);

	 cButton.weightx=50;
	 
	 b = new Button("Ok");
	 //b.setBounds(100,325,60,30);
	 b.addActionListener(this);
	 b.setFont(font);
	 add(b,2,18,1,1,cButton);

	 b = new Button("Cancel");
	 //b.setBounds(170,325,60,30);
	 b.addActionListener(this);
	 b.setFont(font);
	 add(b,3,18,1,1,cButton);
	 
	 pack();
	 
	 
	 //pack();
	 //add(north,"North");
	 //add(center);

	 Mouselistener mouseListener = new Mouselistener();
	 // KeyListener keyListener = new KeyListener();
	 WindowListener windowListener = new WindowListener();
		  

	 addWindowListener(windowListener);
	 addMouseListener(mouseListener);
	 //addKeyListener(keyListener);
  }

  private void add(Component c,int x, int y, int w, int h,
						 GridBagConstraints gbc) {
	 gbc.gridx=x;
	 gbc.gridy=y;
	 gbc.gridwidth=w;
	 gbc.gridheight=h;
	 add(c,gbc);
  }
  
	 
  /*
	* Closes the window
	*/
  private void closeWindow()
  {
	 setVisible(false);
	 dispose();
  }

  private void populateListBox()
  {
	 lstIO.removeAll();
	 if (lstType.getSelectedItem().equals("Input")) 				
		for (int x=0;x<module.getNumInputs();x++)
		  lstIO.add(String.valueOf(x));

	 if (lstType.getSelectedItem().equals("Output")) 				
		for (int x=0;x<module.getNumOutputs();x++)
		  lstIO.add(String.valueOf(x));		  
  }
  /*
	* Show the bottom half of the window
	*/
  private void showLists()
  {
	 if (lblType==null) {
		lblType = new Label(lstType.getSelectedItem()+"s:");
		lblType.setBounds(7,200,60,15);
		lblType.setFont(font);
		add(lblType);
	 }
	 if (lblGroup==null) {
		lblGroup = new Label("Groups:");
		lblGroup.setBounds(90,200,100,15);
		lblGroup.setFont(font);
		add(lblGroup);
	 }
	 if (lstIO==null) {
		lstIO = new List(15,true);
		lstIO.setBounds(10,215,50,232);
		lstIO.addItemListener(this);
		populateListBox();				
		add(lstIO);
	 } else lstIO.setVisible(true);
	 if (lstGroups==null) {
		lstGroups = new List(15,true);
		lstGroups.setBounds(90,215,130,232);

		add(lstGroups);
	 } else lstGroups.setVisible(true);
			  
	 //setSize(250,500);
  }

  /*
   * Hide the bottom half of the window
   */
  private void hideLists()
  {
	 setSize(250,200);
	 lstIO.setVisible(false);
	 lstGroups.setVisible(false);
		  
  }

  /*
   * Called whenever an action is performed
   */
  public void actionPerformed(ActionEvent event)
    {
      Object o = event.getSource();
      if (o==btnInputChange) {
	if (lstInputPortNames.getSelectedIndex()>=0) {
	  int i = lstInputPortNames.getSelectedIndex();
	  StringBuffer sb=new StringBuffer("     ");
	  sb.insert(0,String.valueOf(i));
	  sb.setLength(5);
	  lstInputPortNames.replaceItem(sb+"          "+
					txtInputPortName.getText(),i);
	} else {
	  txtInputPortName.setText("Change What?");
	}
	
      } else if(o==btnOutputChange) {
	if (lstOutputPortNames.getSelectedIndex()>=0) {
	  int i = lstOutputPortNames.getSelectedIndex();
	  StringBuffer sb=new StringBuffer("     ");
	  sb.insert(0,String.valueOf(i));
	  sb.setLength(5);
	  lstOutputPortNames.replaceItem(sb+"          "+
					 txtOutputPortName.getText(),i);
	} else {
	  txtInputPortName.setText("Change What?");
	}
      } else
	if (o instanceof Button){
	    String s = ((Button)o).getLabel();
	    if (s.equals("Cancel"))
	      closeWindow();
	    else if (s.equals("Ok")) {
	      
	      if (parent instanceof ManagerModel) {
		// if the module is not null, change it's properties
		if (module!=null) {
		  boolean isNameValid;
		  if (txtModuleName.getText().equals(module.getName())) 
		    isNameValid=true;
		  else
		    isNameValid=((ManagerModel)parent).validModuleName(txtModuleName.getText().trim().replace(' ','_'));
		  if (isNameValid) {
		    ((ManagerModel)parent).renameModule(module,txtModuleName.getText().trim().replace(' ','_'));
		    String hostName = txtHostName.getText();
                    String newRunMode = runMode.getSelectedItem();
		    if (newRunMode!=null){//it will be null for a macro
		      if(newRunMode.equals("Loop Only")) {
			module.setRunMode(Agent.LOOP_ONLY);
		      }
		      else if(newRunMode.equals("Event Only")) {
			module.setRunMode(Agent.EVENT_ONLY);
		      }
		      else if(newRunMode.equals("Event Or Loop")) {
			module.setRunMode(Agent.EVENT_OR_LOOP);
		      }
		    }
                    int loc = lstLocation.getSelectedIndex();
		    module.setAgentLocation(loc);
		    module.setHostName(hostName);
		    if(module instanceof Macro) {
		      //Set all the modules in this macro to run in 
		      // this location too
		      ((MacroDescription)module.getAgentDescription()).
			changeHost(hostName);/*,module.getAgentLocation());*/
		      // Do we also change the source?
		    }
		    int k;
		    String portName;
		    for (k=0;k<lstOutputPortNames.getItemCount();k++) {
		      portName=lstOutputPortNames.getItem(k);
		      portName=portName.substring(portName.lastIndexOf(" ")+1);
		      module.setOutputPortName(portName,k);
		    }
		    for (k=0;k<lstInputPortNames.getItemCount();k++) {
		      portName=lstInputPortNames.getItem(k);
		      portName=portName.substring(portName.lastIndexOf(" ")+1);
		      module.setInputPortName(portName,k);
		    }
		    module.resizeModule(Integer.parseInt(txtModuleSizeX.getText()),
					Integer.parseInt(txtModuleSizeY.getText()));
		    
		    //module.repaint();
		    closeWindow();
		  } else {
		    ErrorDialog d = new ErrorDialog(this,"Invalid " + 
						    "module name.",true);
		    d.setLocation(getLocation());
		    d.show();
		  }
		} else {
		  // if the module is null, then we're dealing with multiple
		  // modules.  we need to change all there properties.
		  // we only change the fields if they are not empty
		  while (moduleList.hasMoreElements()) {
		    module=(Module)moduleList.nextElement();
		    if (!txtHostName.getText().equals("No Change")) {
		      module.setHostName(txtHostName.getText());
		    }
		    
		    if (lstLocation.getSelectedIndex()!=2) 
		      module.setAgentLocation(lstLocation.getSelectedIndex());
		    
		    if ((!txtModuleSizeX.getText().equals("")) 
			&& (!txtModuleSizeY.getText().equals(""))) {
		      module.resizeModule(Integer.parseInt
					  (txtModuleSizeX.getText()),
					  Integer.parseInt
					  (txtModuleSizeY.getText()));
		    }
		    
		  }
		  closeWindow();
		} 
		((ManagerModel)parent).setSaved(false);
	      }
	      
	      /*
		String selected = txtPorts.getText();
		if (selected.indexOf(",")>=0) {
		// Currently the code does NOT support selecting mapping
		// multiple inputs/outputs, but it will soon.	 
		ErrorDialog d= new ErrorDialog(this,
		"Multiple ports currently not supported.",true);
		d.setLocation(getLocation());
		d.show();
		} else {
		if (lstType.getSelectedItem().equals("Input"))
		((ModuleManager)parent).selectPort(new 
		IOPort(module,"I"+selected));
		if (lstType.getSelectedItem().equals("Output"))
		((ModuleManager)parent).selectPort(new 
		IOPort(module,"O"+selected));
		
		closeWindow();
		}
		
	      */
	    } //*Matches    s.equals("Ok")
	    /*
	      else if (s.equals("Show Lists")) {
	      ((Button)o).setLabel("Hide Lists");
	      showLists();
	      }
	      else if (s.equals("Hide Lists")) {
	      ((Button)o).setLabel("Show Lists");
	      hideLists();
	      }
	    */
	    else if (s.equals("Edit State")) {
	      // Dan's edit state thing should be called from here
	      // how to determine which state editor to use?
	      // for now, if state is a an array of strings, then use default
	      StateEditor stateEd;
	      stateEd=module.getAgent().getStateEditor(this);
	      if (stateEd==null){
		  System.out.println("No state editor provided by agent, trying default");
		  stateEd= new DefaultStateEditor(this);
	      }
	      stateEd.editState( module );
	    }
	    
	  }
      
    }
  
  public void itemStateChanged(ItemEvent event)
    {
	 Object o = event.getSource();
	 if (o==lstInputPortNames) {
		String portName=lstInputPortNames.getSelectedItem();
		//System.out.println(portName);
		portName=portName.substring(portName.lastIndexOf(" ")+1);
		txtInputPortName.setText(portName);
	 } else if(o==lstOutputPortNames) {
		String portName=lstOutputPortNames.getSelectedItem();
		//System.out.println(portName);
		portName=portName.substring(portName.lastIndexOf(" ")+1);
		txtOutputPortName.setText(portName);
	 } else if (o == lstIO) {
		String[] selected=((List)o).getSelectedItems();
		String selectedList= new String();
		int x=0;
		for (x=0;x<selected.length;x++)
		  selectedList= selectedList.concat(selected[x]+",");		
		if (x==0) 
		  txtPorts.setText("");
		else
		  txtPorts.setText(selectedList.substring(0,selectedList.length()-1));
	 } else if (o == lstType) {
		if (lblType!=null) {					
		  lblType.setText(lstType.getSelectedItem()+"s:");
		  populateListBox();
		}
		
	 }
	 
  }

  class Mouselistener extends java.awt.event.MouseAdapter
  {
	 public void mouseClicked(java.awt.event.MouseEvent event)
	 {
		//System.out.println("X= "+event.getX()+" Y= "+event.getY());
	 }
	 
  }	 

  class WindowListener extends java.awt.event.WindowAdapter
  {
	 public void windowClosing(java.awt.event.WindowEvent event)
	 {
		closeWindow();
	 }
  }


  class KeyListener extends KeyAdapter
  {
	 /* 
	  * Triggered whenever a key is pressed. For right now just pass it 
	  * on to the parent.
	  */
		  
	 public void keyPressed(KeyEvent evt)
	 {
			
		//parent.dispatchEvent(evt);
	 } 
  }


}
