package adaptive.modulemanager;
import java.util.*;

import java.awt.*;
public class ModulePanel extends Panel {
  Graphics offGraphics;
  Image offImage;
  Dimension offDimension;
  
  public void paint(Graphics g) {
	 update(g);	 
	 //System.out.println("paint");
  }

  public void update(Graphics g) {
    Dimension d = getSize();
	 //System.out.println("update");
    //Create the offscreen graphics context, if no good one exists.
    if ( (offGraphics == null)
			|| (d.width != offDimension.width)
			|| (d.height != offDimension.height) ) {
      offDimension = d;
      offImage = createImage(d.width, d.height);
      offGraphics = offImage.getGraphics();
    }
    
    //Erase the previous image.
    offGraphics.setColor(getBackground());
    offGraphics.fillRect(0, 0, d.width, d.height);
    offGraphics.setColor(Color.black);	
    
    View m = (View)(getParent().getParent());
    
    SelectRectangle selectRectangle=m.getModel().getSelectRectangle();
    //System.out.println("panel paint");
    int x = getComponentCount();
    Component c[] = getComponents();
    Point topLeft;
    Dimension wh;
    Point bottomRight=new Point();
    
    // Selects all the modules that are inside the selection rectangle
    for (int y=0;y<x;y++) {
      if (selectRectangle!=null) {
		  topLeft=c[y].getLocation();
		  wh=c[y].getSize();
		  bottomRight.setLocation(wh.width+topLeft.x,wh.height+topLeft.y);
		  // Check to make the the rectangle contaiins the top left, and the
		  // bottom right to make sure the whole component is in the rectangle
		  if ((selectRectangle.contains(topLeft) 
				 && (selectRectangle.contains(bottomRight)))) {
			 ((Module)c[y]).setSelected(true);
			 m.getModel().addSelectedModule((Module)c[y]);
			 //m.highlightLines((Module)c[y],true);
		  }
		  else { 
			 ((Module)c[y]).setSelected(false);
			 m.getModel().removeSelectedModule((Module)c[y]);
		  }  
      }		  
    }
    
    Enumeration e;	 
    e = m.getModel().getLines(); //.elements();
    ConnectLine cl;
    while (e.hasMoreElements()) {
      //System.out.println("draw line");
      
      cl = (ConnectLine)e.nextElement();
      cl.drawLine(offGraphics,null);
    }
    
    // We highlight any modules that are in the rectangle
    //int x = getComponentCount();
    //Component c[] = getComponents();
    for (int y=0;y<x;y++) {
      ((Module)c[y]).drawModule(offGraphics,c[y].getLocation());
    }
    
    
    if (selectRectangle!=null) {	
      offGraphics.setColor(Color.black);
      selectRectangle.draw(offGraphics);		  
    }
    g.drawImage(offImage, 0, 0, this);
    
  }
  
}
