package adaptive.modulemanager;

import java.awt.*;

/**
 * Layout manager that allows things to be layed out vertically or
 * horizontally.  If Vertical is specified, the objects are displayed
 * vertically until there is no more room, then they rap to the next
 * column.  If horizontal is specified, the objects are displayed
 * in rows until there is no more room, then it raps to the next row.
 */
public class ModuleLayout implements LayoutManager
{

	 public static final int HORIZONTAL = 0;
	 public static final int VERTICAL = 1;

    private int vgap;
    private int minWidth = 0, minHeight = 0;
    private int preferredWidth = 0, preferredHeight = 0;
    private boolean sizeUnknown = true;
	 private int direction;

    public ModuleLayout(int dir) {
        vgap=5;
		  direction=dir;
    }

	 // public ModuleLayout(int v) {
    //    vgap = v;
	 // }

    /* Required by LayoutManager. */
    public void addLayoutComponent(String name, Component comp) {
    }

    /* Required by LayoutManager. */
    public void removeLayoutComponent(Component comp) {
    }

  /**
	* Set the preferred size and all that jazz.  
	*/
  private void setSizes(Container parent) {
	 int nComps = parent.getComponentCount();
	 Dimension d = null;
	 int x=0;
	 int y=0;
	 int maxWidth=parent.getSize().width;
	 int maxHeight=parent.getSize().height;
	 int prevRowHeight=0,prevColWidth=0;
	 Insets insets = parent.getInsets();
	 
	 //Reset preferred/minimum width and height.
	 preferredWidth = 0;
	 preferredHeight = 0;
	 minWidth = 0;
	 minHeight = 0;
	 Component c;
	 //System.out.println("parent_dim="+parent.getSize());
	 //System.out.println("numcomp="+nComps);
	 for (int i = 0; i < nComps; i++) {
		c = parent.getComponent(i);
		if (c.isVisible()) {
		  d = c.getPreferredSize();
		  
		  if (direction==HORIZONTAL) {
			 prevRowHeight=Math.max(prevRowHeight,d.height);
			 if (x +d.width +2 > maxWidth - insets.right) {
				//System.out.println("rowheight="+prevRowHeight);
				if (i!=0) { 
				  preferredHeight=preferredHeight+prevRowHeight;
				  prevRowHeight=d.height;	 
				}
				x=insets.left+2;
				
			 } 
			 x=x+d.width+2;
			 
			 
		  } else {
			 prevColWidth=Math.max(prevColWidth,d.width);
			 if (y+d.height+2>maxHeight - insets.bottom) {
				if (i!=0) {
				  preferredWidth=preferredWidth+prevColWidth;
				  prevColWidth=d.width;
				}
				y=insets.top+2;
			 }
			 y=y+d.height+2;
		  }
		  
		  minWidth = Math.max(c.getMinimumSize().width, 
									 minWidth);
		  minHeight = preferredHeight;
		}
	 }
	 if (direction==HORIZONTAL) {
		preferredHeight=preferredHeight+prevRowHeight;
		preferredWidth=maxWidth;
	 } else {
		preferredWidth=preferredWidth+prevColWidth;
		preferredHeight=maxHeight;
	 }
	 //System.out.println("preffered "+preferredHeight);
	 
  }


    /* Required by LayoutManager. */
    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.getComponentCount();

        setSizes(parent);

        //Always add the container's insets!
        Insets insets = parent.getInsets();
        dim.width = preferredWidth 
                    + insets.left + insets.right;
        dim.height = preferredHeight 
                     + insets.top + insets.bottom;
		  

		  //System.out.println("I prefer: "+dim);	  
		  //Dimension pardim = parent.getSize();
		  //System.out.println("Parent is: "+pardim);
        sizeUnknown = false;
		  
        return dim;
    }

    /* Required by LayoutManager. */
    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension(0, 0);
        int nComps = parent.getComponentCount();

        //Always add the container's insets!
        Insets insets = parent.getInsets();
        dim.width = minWidth 
                    + insets.left + insets.right;
        dim.height = minHeight 
                     + insets.top + insets.bottom;

        sizeUnknown = false;

        return dim;
    }

    /* Required by LayoutManager. */
    /* 
     * This is called when the panel is first displayed, 
     * and every time its size changes. 
     * Note: You CAN'T assume preferredLayoutSize or 
     * minimumLayoutSize will be called -- in the case 
     * of applets, at least, they probably won't be. 
     */
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        //int maxWidth = parent.getSize().width
        //               - (insets.left + insets.right);
        //int maxHeight = parent.getSize().height
        //                - (insets.top + insets.bottom);
		  int maxWidth=preferredWidth;
		  int maxHeight=preferredHeight;
		  
        int nComps = parent.getComponentCount();
        int previousWidth = 0, previousHeight = 0;
        int x = 0, y = insets.top;
        int rowh = 0, start = 0;
        int xFudge = 0, yFudge = 0;
        boolean oneColumn = false;

		  //System.out.println("Maxwidth="+maxWidth);

        // Go through the components' sizes, if neither 
        // preferredLayoutSize nor minimumLayoutSize has 
        // been called.
        if (sizeUnknown) {
            setSizes(parent);
        }
		  /*
        if (maxWidth <= minWidth) {
            oneColumn = true;
        }

        if (maxWidth != preferredWidth) {
            xFudge = (maxWidth - preferredWidth)/(nComps - 1);
        }

        if (maxHeight > preferredHeight) {
            yFudge = (maxHeight - preferredHeight)/(nComps - 1);
        }
		  */
		  x=insets.left+2;
		  y=insets.top+2;
		  
		  //System.out.println(parent.getSize().width);
        for (int i = 0 ; i < nComps ; i++) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getPreferredSize();
                
					 // if we can't fit any more modules in the row, go to the
					 // next row
					 //System.out.println("x="+x);
					 if (direction==HORIZONTAL) {
						
						if (x +d.width +2> maxWidth - insets.right) {
						  if (i!=0) y= y +d.height;
						  x=insets.left+2;						  
						} 
						c.setBounds(x,y,d.width,d.height);
						x = x+d.width+2;
					 } else {
						if (y + d.height+2>maxHeight - insets.top) {
						  if (i!=0) x=x+d.width;
						  y=insets.top+2;
						}
						c.setBounds(x,y,d.width,d.height);
						y = y+d.width+2;
					 }
					 

                //c.setBounds(x, y, d.width, d.height);
					 //x=x+d.width+2 ;
                //previousWidth = d.width;
                //previousHeight = d.height;
            }
        }
    }
    
    public String toString() {
        String str = "";
        return getClass().getName() + "[vgap=" + vgap + str + "]";
    }

	 

}
