package adaptive.modulemanager;
import java.util.Vector;

/**
  * A mapping is just a vector to store the mappings for a set of ports.
  * A normal mapping is used for Input ports since each port will only
  * have one mapping to it.  For output ports use MultipleMapping.
  *
  * @see MultipleMapping
  */
public class Mapping implements  java.io.Serializable
{

	private Vector data;
	
  /**
	 * Create a new mapping of the given size
	 *
	 * @param size The size of the mapping
	 */
	public Mapping(int size)
	{
		data = new Vector(size);
		// Insert nulls for each element
		// is this really necessary?
		for (int x=0;x<size;x++)
			data.addElement(null);
		
	}


  /**
	* Clone method
	*
	* @return A cloned Mapping
	*/
  public Object clone() {
	 Mapping m = new Mapping(data.size());
	 m.data = new Vector(data.size());
	 for (int x=0;x<data.size();x++) {
		IOPort iop = (IOPort)data.elementAt(x);
		m.data.addElement(iop.clone());
	 }
	 return m;
  }
  

  /**
	 *	Returns the mapping to a specific port in this mapping.
	 *
	 * @param portNumber the port to get the mapping of
	 * @return The mapping for the specified port
	 */
	public IOPort getMap(int portNumber)
	{
		return (IOPort)data.elementAt(portNumber);
	}

  /**
	 *	Returns the number of mapped inputs/outputs in this mapping.
	 *
	 * @return the number of mappings
	 */
	public int numMapped()
	{
		return data.size();
	}

	/*
	*	Set the mapping for a specific port
	*/
  /*
	public void setMap(int portNumber,Module m, String port)
	{
		data.setElementAt(new IOPort(m,port),portNumber);
	}
	*/

  /**
	 *	Set the mapping for a specific port
	 *
	 * @param portnum the port in this mapping 
	 * @param port The port to map to
	 */
  public void setMap(int portnum,IOPort port) {
	 data.setElementAt(port,portnum);
  }

  /**
	 * Remove the mapping from the specified port
	 *
	 * @param portnum the port to remove the mapping from
	 */
  public void removeMap(int portnum) {
	 data.setElementAt(null,portnum);
  }

}
