package adaptive.modulemanager;

import java.awt.*;

/*
 * Represents a segment of a ConnectLine. Makes a buffer around the
 * segment so users can click on it without being on the exact pixel.
 */
public class LineSegment 
{

	 private Rectangle rect;
	 private Point startPoint;
	 private Point finishPoint;
	 private ConnectLine parent;


	 public LineSegment(ConnectLine p,Point sp, Point ep)
	 {
		  parent=p;
		  startPoint=sp;
		  finishPoint=ep;
		  makeRectangle(sp,ep);
	 }
		  
  public String toString() {
	 return "Start="+startPoint.x+","+startPoint.y +
		" Finish="+finishPoint.x+","+finishPoint.y;
  }
  

	 private void makeRectangle(Point sp, Point ep)
	 {
		  // We go to the right 2, and down two, so that way rectangles
		  // won't overlap.
		  
		  // We have to check to see which way the line goes, if the
		  // x's are the same, it's vertical, if the y's are the same
		  // it's horizontal.  
		  //
		  // Vertical line segments will have width 5, and height y
		  // If the end y is a lower value than the start y, the rectangle
		  // has to start at the end and go down.  otherwise do the opposite.
		  //
		  // We have to do the same thing if the line is horizontal
		  //System.out.println("sp="+sp+" ep="+ep);
		  if (sp.x==ep.x) {
				if (sp.y<=ep.y) 
					 rect = new Rectangle(sp.x-2,sp.y+2,5,ep.y-sp.y);
				else
					 rect = new Rectangle(ep.x-2,ep.y+2,5,sp.y-ep.y);
		  } else {
				if (sp.x<=ep.x)
					 rect = new Rectangle(sp.x+2,sp.y-2,ep.x-sp.x,5);
				else
					 rect = new Rectangle(ep.x+2,ep.y-2,sp.x-ep.x,5);
		  }
	 }
	 /*
	  * Move the x location.  This only works if the line is vertical.
	  */
	 public void setX(int x) 
	 {
		  // Check to see if the line is vertical
		  if (startPoint.x==finishPoint.x) {
				// Since startPoint and finishPoint are basically pointers
				// to the actual Points in the parents bendPoints vector, we
				// can simply change there values here and it will change in
				// the parent.
				startPoint.x=x;
				finishPoint.x=x;

				// Need to redo the whole set of line segments because we
				// moved the two points.
				parent.createLineSegments();
				//makeRectangle(startPoint,finishPoint);		  
		  }
	 }

	 public boolean isHorizontal() 
	 {
		  return (startPoint.y==finishPoint.y);
	 }
	 
	 public boolean isVertical()
	 {
		  return (startPoint.x==finishPoint.x);
	 }

	 public void setY(int y)
	 {
		  if (startPoint.y==finishPoint.y) {
				startPoint.y=y;
				finishPoint.y=y;
				parent.createLineSegments();
				//makeRectangle(startPoint,finishPoint);
		  }
	 }

	 public void setRectangle(Rectangle r) 
	 {
		  rect=r;
	 }

	 public void setStartPoint(Point p)
	 {
		  startPoint=p;
	 }

	 public void setFinishPoint(Point p)
	 {
		  finishPoint = p;
	 }

	 public Rectangle getRectangle()
	 {
		  return rect;
	 }
	 
	 public Point getStartPoint()
	 {
		  return startPoint;
	 }

	 public Point getFinishPoint()
	 {
		  return finishPoint;
	 }

	 public ConnectLine getParent()
	 {
		  return parent;
	 }

	 public boolean contains(Point p)
	 {
		  return rect.contains(p);
	 }

	 public boolean contains(int x, int y)
	 {
		  return rect.contains(x,y);
	 }

	 public void draw(Graphics g,Color c)
	 {
		  g.setColor(c);
		  g.drawLine(startPoint.x,startPoint.y,finishPoint.x,finishPoint.y);
	 }

}
