package adaptive.modulemanager;
public class IOPort  implements java.io.Serializable
{	
  //rivate String port;
  private int port;
  private int type;
  
	 private adaptive.modulemanager.Module module;

	 public static final int INPUT=0;
	 public static final int OUTPUT=1;


	 public IOPort()
	 {
		port = 0;
		type=INPUT;
	 }

	 public IOPort(Module m,int p, int t)
	 {
		  module=m;
		  port = p;
		  type = t;
		  /*
		  if (t==INPUT) 
				port = new String("I"+String.valueOf(p));
		 else
			  port = new String("O"+String.valueOf(p));*/
	 }

  public Object clone() {
	 IOPort iop = new IOPort();
	 iop.module=(Module)module.clone();
	 iop.port=port;
	 iop.type=type;
	 return iop;
  }

  public String toString() {
	 if (type==INPUT) 
		return "Input "+String.valueOf(port)+" on "+module.getName();
	 return "Output "+String.valueOf(port)+" on "+module.getName();
  }
  
	public void setPort(int p)
	{
		port=p;	
	}

	public void setModule(Module m) {
	  module=m;
	}

  public int getPort() {
	 return port;
  }

  public adaptive.modulemanager.Module getModule() {
	 return module;
  }

  public int getType() {
	 return type;
  }

  public String getTypeAsString() {
	 if (type==INPUT) return "Input";
	 if (type==OUTPUT) return "Output";
	 return null;
  }	

  public String getPortString() {
	 if (type==INPUT) return "I"+String.valueOf(port);
	 if (type==OUTPUT) return "O"+String.valueOf(port);
	 return null;
  }
  


  public boolean isInput() {
	 return (type==INPUT);
  }

  public boolean isOutput() {
	 return (type==OUTPUT);
  }
  
}
