/* Host Macro, by Andrea Byrnes */

package adaptive.modulemanager;

import adaptive.core.*;
import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

/** This class is meant strictly for the run time viewer and in no way
  *  should it be thought to represent any actual underlying agent structure, 
  *  nor should it even be sent to the Launcher.  With that in mind, this 
  *  class is how the top level of the runtime viewer is displayed to show 
  *  communication channels between hosts.
  */

public class HostMacro extends Macro {
  private int numInputs = 0;
  private int numOutputs = 0;
  private int numInMapped = 0;
  private int numOutMapped = 0;  
  private ConfigAndLayout config;

  /* Default constructor */
  public HostMacro(int debugLevel){
    super(debugLevel);
  }

  /* Takes in the host name for the machine this represents, as well as the 
   *  ManagerModel from which to make this HM. */
  public HostMacro(String name, ConfigAndLayout cal, ModuleManager mm,
						 int debugLevel){
    super(mm,cal.systemConfiguration, cal.layout,debugLevel);
    setName(name);  /* Should be the name of the host */
    config = cal;
    agentDescription.setNumInputs(numInputs);
    agentDescription.setNumOutputs(numOutputs);    
    init();
  }

  /* Needed for compatibility with parent classes */
  public Object clone(boolean b, String s){
    return clone();
  }

  /* Standard clone function */
  public Object clone(){
    HostMacro h = new HostMacro(getName(), config, moduleManager,debugLevel);
    return h;
  }

  /* This is the main reason for making this class.  I want to be able to 
   *  dynamically add ports as I find new hosts that need to communicate 
   *  with this one.  The connectLine that's passed in is from the edit 
   *  view and therefore will have pointers to Modules at the ends, not 
   *  other HostMacros.
   */
  public int addPort(ConnectLine cl){
    int io = -1;
    HostMacro other;
    String otherHost = cl.getStartModule().getHostName();
    if(getName().compareTo(otherHost) == 0) 
      /* Then this is me, and not the _other_host */
      otherHost = cl.getFinishModule().getHostName();

    other = (HostMacro)((ManagerModel)owner).getModule(otherHost);

    /* Figure out on which side to put the port */
    Point p = other.getLocation();
    if(p.x > getLocation().x) { /* Then 'other' is to the right */
      ((MacroDescription)agentDescription)
	.setOutputAgent(new PortLocation("",numOutputs,agentDescription),
			numOutputs);
      /* All ports are named 'Kevin' for now */
      agentDescription.setOutputPortName("Kevin",numOutputs++);
      io = IOPort.OUTPUT;

    } else {  /* 'other' is to the left or in the same column */
      if(p.x == getLocation().x) { /* Then they're in the same column */
	if(p.y < getLocation().y) {
	  ((MacroDescription)agentDescription)
	    .setOutputAgent(new PortLocation("",numOutputs,agentDescription),
			    numOutputs); 
	  /* All ports are named 'Kevin' for now */
	  agentDescription.setOutputPortName("Kevin",numOutputs++);
	  io = IOPort.OUTPUT;
	}
      }
      if( (p.x != getLocation().x) || (p.y > getLocation().y) ) {
	((MacroDescription)agentDescription)
	  .setInputAgent(new PortLocation("",numInputs,agentDescription),
			 numInputs);
	agentDescription.setInputPortName("Kevin",numInputs++);
	io = IOPort.INPUT;
      }
    }

    agentDescription.setNumOutputs(numOutputs);
    agentDescription.setNumInputs(numInputs);
    init();

    return io;
  }

  /* I need a little extra information than my parent class gives me, so 
     I'll record it before calling the parent class to actually do the work. */
  public void setInputMapping(ConnectLine cl) {
    numInMapped++;
    super.setInputMapping(cl);
  }

  /* I need a little extra information than my parent class gives me, so 
     I'll record it before calling the parent class to actually do the work. */
  public void setOutputMapping(ConnectLine cl) {
    numOutMapped++;
    super.setOutputMapping(cl);
  }

  /* Info I need for drawing lines */
  public int getNumInputsMapped() {
    return numInMapped;
  }

  /* Info I need for drawing lines */
  public int getNumOutputsMapped() {
    return numOutMapped;
  }

  /* Information to print in string form... */
  public String toString() {
    return ("HostMacro for "+getName());
  }

  /* I'm making all ports Boolean so that they can all map to each other.  I 
   *  could make another port type such as HostPort or something, but that 
   *  seems a little overboard for such a small portion of the GUI 
   */
  public Class getInputPortType(int i) {
    Class c = this.getClass();
    try {
      c = Class.forName("java.lang.Boolean");
    } catch (ClassNotFoundException cnfe) {
      System.err.println("It's a bad sign when you can't find class "+
			 "'java.lang.Boolean'.");
    }
    return c;
  }
  
  /* I'm making all ports Boolean so that they can all map to each other.  I 
   *  could make another port type such as HostPort or something, but that 
   *  seems a little overboard for such a small portion of the GUI 
   */
  public Class getOutputPortType(int i) {
    Class c = this.getClass();
    try {
      c = Class.forName("java.lang.Boolean");
    } catch (ClassNotFoundException cnfe) {
      System.err.println("It's a bad sign when you can't find class "+
			 "'java.lang.Boolean'.");
    }
    return c;
  }

  /* I really don't think this information will be needed, so this is 
     kind of a hack, but setting everything up for this seems pointless at 
     this point. */
  public void setMapping(String myPort,IOPort destination) {

  }
}
