/**
 * System properties window
 *
 */
package adaptive.modulemanager;

import adaptive.core.SystemConfiguration;
import adaptive.core.PortLocation;
import java.util.Vector;
import java.util.Enumeration;


import java.awt.*;
import java.awt.event.*;

public class FrmSystemProperties extends Frame implements ActionListener,ItemListener {

  private Font font;
  private TextArea txtDescription;
  private TextArea txtLastRevision;
  private TextField txtSystemName;
  private TextField txtVersion;
  private TextField txtAuthor;
  private TextField txtDate;
  private Button btnOK;
  private Button btnCancel;
  private ManagerModel model;
  private SystemConfiguration sc;
  private List lstInputPortNames,lstOutputPortNames;
  private TextField txtInputPortName,txtOutputPortName;
  private Button btnInputChange,btnOutputChange;
  private Button btnInputUp,btnInputDown;
  private Button btnOutputUp,btnOutputDown;
  private Button btnOutputAdd,btnOutputRemove;

  public FrmSystemProperties(ManagerModel m) {
	 model=m;
	 sc=(SystemConfiguration)model.getSystemConfiguration().clone();

	 setLayout(new GridBagLayout());
	 setTitle("System Properties");
	 //setSize(300,400);
	 font = new Font("SansSerif",Font.PLAIN,12);
	 //Panel labels = new Panel();

	 GridBagConstraints cLabel= new GridBagConstraints();
	 GridBagConstraints cText = new GridBagConstraints();	 
	 GridBagConstraints cBox = new GridBagConstraints();
	 GridBagConstraints cButton = new GridBagConstraints();
	 // don't expand at all
	 cLabel.weightx=0;
	 cLabel.weighty=0;
	 cLabel.fill=GridBagConstraints.BOTH;
	 cLabel.anchor=GridBagConstraints.WEST;
	 
	 // only expand in the x direction
	 cText.weightx=100;
	 cText.weighty=0;
	 cText.fill=GridBagConstraints.BOTH;
	 cText.anchor=GridBagConstraints.WEST;
	 cText.insets=new Insets(2,5,2,5);
	 
	 // expand in both x and y
	 cBox.weightx=100;
	 cBox.weighty=100;
	 cBox.fill=GridBagConstraints.BOTH;
	 cBox.insets=new Insets(2,3,2,3);

	 cButton.weightx=0;
	 cButton.weighty=0;
	 cButton.fill=GridBagConstraints.BOTH;
	 cButton.anchor=GridBagConstraints.CENTER; 

	 Label l = new Label("System Name:");
	 //l.setBounds(0,30,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,1,3,1,cLabel);
	 
	 l = new Label("Version:");
	 //l.setBounds(0,60,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,2,3,1,cLabel);
	 
	 l = new Label("Author: ");
	 //l.setBounds(0,90,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,3,3,1,cLabel);
	 
	 l = new Label("Date: ");
	 //l.setBounds(0,120,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,4,3,1,cLabel);

	 l = new Label("Description: ");
	 //l.setBounds(0,150,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,5,3,1,cLabel);

	 l = new Label("Last Revision: ");
	 //l.setBounds(0,250,100,30);
	 l.setFont(font);
	 l.setAlignment(l.RIGHT);
	 add(l,1,8,3,1,cLabel);

	 txtSystemName=new TextField(model.getSystemName());
	 //txtSystemName.setBounds(105,30,180,30);
	 txtSystemName.setFont(font);
	 txtSystemName.setEditable(false);//editing this here causes bunches of problems, and there are other places to edit the system name
	 add(txtSystemName,4,1,cText.REMAINDER,1,cText);
	 
	 txtVersion=new TextField(model.getVersion());
	 //txtVersion.setBounds(105,60,180,30);
	 txtVersion.setFont(font);
	 add(txtVersion,4,2,cText.REMAINDER,1,cText);

	 txtDescription = new TextArea(model.getDescription(),5,50,
				       TextArea.SCROLLBARS_VERTICAL_ONLY);
	 //txtDescription.setBounds(105,150,190,100);
	 txtDescription.setFont(font);
	 add(txtDescription,4,5,cText.REMAINDER,3,cBox);

	 txtLastRevision = new TextArea(model.getLastRevision(),5,50,
					TextArea.SCROLLBARS_VERTICAL_ONLY);
	 //txtLastRevision.setBounds(105,250,190,100);
	 txtLastRevision.setFont(font);
	 add(txtLastRevision,4,8,cText.REMAINDER,3,cBox);

	 txtAuthor=new TextField(model.getAuthor());
	 //txtAuthor.setBounds(105,90,180,30);
	 txtAuthor.setFont(font);
	 add(txtAuthor,4,3,cText.REMAINDER,1,cText);

	 txtDate=new TextField(model.getDate());
	 //txtDate.setBounds(105,120,180,30);
	 txtDate.setFont(font);
	 add(txtDate,4,4,cText.REMAINDER,1,cText);


	 l = new Label("Input Port        Port       Name");
	 //l.setBounds(7,150,120,30);
	 l.setFont(font);
	 add(l,1,11,cText.REMAINDER,1,cLabel);

	 lstInputPortNames = new List();
	 lstInputPortNames.setFont(font);
	 //lstInputPortNames.setBounds(7,180,235,100);
	 lstInputPortNames.addItemListener(this);
	 add(lstInputPortNames,1,12,cBox.RELATIVE,4,cBox);

	 txtInputPortName= new TextField("");
	 txtInputPortName.setFont(font);
	 //txtInputPortName.setBounds(7,285,175,30);
	 txtInputPortName.addActionListener(this);
	 add(txtInputPortName,4,16,1,1,cText);
	 
	 btnInputChange = new Button("Change");
	 btnInputChange.setFont(font);
	 // btnInputChange.setBounds(185,285,60,30);
	 btnInputChange.addActionListener(this);
	 add(btnInputChange,1,16,1,1,cButton);

	 btnInputUp = new Button("Up");
	 btnInputUp.setFont(font);
	 // btnInputUp.setBounds(185,285,60,30);
	 btnInputUp.addActionListener(this);
	 add(btnInputUp,5,12,cText.REMAINDER,2,cButton);

	 btnInputDown = new Button("Dn");
	 btnInputDown.setFont(font);
	 // btnInputDown.setBounds(185,285,60,30);
	 btnInputDown.addActionListener(this);
	 add(btnInputDown,5,14,cText.REMAINDER,2,cButton);


	 l = new Label("Output Port        Port      Name");
	 //l.setBounds(7,150,120,30);
	 l.setFont(font);
	 add(l,1,17,5,1,cLabel);

	 lstOutputPortNames = new List();
	 lstOutputPortNames.setFont(font);
	 //lstOutputPortNames.setBounds(7,180,235,100);
	 lstOutputPortNames.addItemListener(this);
	 add(lstOutputPortNames,1,18,cBox.RELATIVE,4,cBox);

	 txtOutputPortName= new TextField("");
	 txtOutputPortName.setFont(font);
	 //txtOutputPortName.setBounds(7,285,175,30);
	 txtOutputPortName.addActionListener(this);
	 add(txtOutputPortName,4,22,1,1,cText);
	 
	 btnOutputChange = new Button("Change");
	 btnOutputChange.setFont(font);
	 // btnInputChange.setBounds(185,285,60,30);
	 btnOutputChange.addActionListener(this);
	 add(btnOutputChange,1,22,1,1,cButton);
	 
	 btnOutputUp = new Button("Up");
	 btnOutputUp.setFont(font);
	 // btnInputUp.setBounds(185,285,60,30);
	 btnOutputUp.addActionListener(this);
	 add(btnOutputUp,5,18,cText.REMAINDER,2,cButton);

	 btnOutputDown = new Button("Dn");
	 btnOutputDown.setFont(font);
	 // btnInputDown.setBounds(185,285,60,30);
	 btnOutputDown.addActionListener(this);
	 add(btnOutputDown,5,20,cText.REMAINDER,2,cButton);

	 btnOutputAdd = new Button("Add");
	 btnOutputAdd.setFont(font);
	 // btnInputDown.setBounds(185,285,60,30);
	 btnOutputAdd.addActionListener(this);
	 add(btnOutputAdd,2,22,1,1,cButton);

	 btnOutputRemove = new Button("Remove");
	 btnOutputRemove.setFont(font);
	 // btnInputDown.setBounds(185,285,60,30);
	 btnOutputRemove.addActionListener(this);
	 add(btnOutputRemove,3,22,1,1,cButton);

	 btnOK=new Button("OK");
	 //btnOK.setBounds(105,360,50,30);
	 btnOK.setFont(font);
	 btnOK.addActionListener(this);
	 add(btnOK,4,23,2,1,cButton);

	 btnCancel=new Button("Cancel");
	 //btnCancel.setBounds(190,360,50,30);
	 btnCancel.setFont(font);
	 btnCancel.addActionListener(this);
	 add(btnCancel,1,23,3,1,cButton);
	 
	 
	 WindowListener windowListener = new WindowListener();
	 addWindowListener(windowListener);



	 displayPorts();
	 

	 pack();
  }
  private void add(Component c,int x, int y, int w, int h,
						 GridBagConstraints gbc) {
	 gbc.gridx=x;
	 gbc.gridy=y;
	 gbc.gridwidth=w;
	 gbc.gridheight=h;
	 add(c,gbc);
  }
  protected void displayPorts(){
    displayOutputPorts();
    displayInputPorts();
  }
  protected void displayOutputPorts(){
    //    SystemConfiguration sc = model.getSystemConfiguration();
    PortLocation pl;
    
    StringBuffer sb= new StringBuffer("     ");
    lstOutputPortNames.clear();
    for (int k=0;k<sc.getNumOutputs();k++) {
      sb=sb.insert(0,String.valueOf(k));
      sb.setLength(5);
      pl=sc.getOutputAgent(k);
      lstOutputPortNames.add(sb.toString()+"          "+String.valueOf(pl.getPortNumber())+"     "+pl.getAgentName());
      
      // System.out.println("k="+k+" "+module.getInputPortName(k));
      sb=new StringBuffer("     ");
    } 
  }
  protected void displayInputPorts(){
    //    SystemConfiguration sc = model.getSystemConfiguration();
    PortLocation pl;
    
    StringBuffer sb= new StringBuffer("     ");
    lstInputPortNames.clear();
    for (int k=0;k<sc.getNumInputs();k++) {
      sb=sb.insert(0,String.valueOf(k));
      sb.setLength(5);
      pl=sc.getInputAgent(k);
      lstInputPortNames.add(sb.toString()+"          "+String.valueOf(pl.getPortNumber())+"     "+pl.getAgentName());
      // System.out.println("k="+k+" "+module.getInputPortName(k));
      sb=new StringBuffer("     ");
    } 
  }

  public void itemStateChanged(ItemEvent event)
  {
	 Object o = event.getSource();
	 if (o==lstInputPortNames) {
		String portName=lstInputPortNames.getSelectedItem();
		//System.out.println(portName);
		portName=portName.substring(portName.lastIndexOf(" ")+1);
		txtInputPortName.setText(portName);
	 } else if(o==lstOutputPortNames) {
		String portName=lstOutputPortNames.getSelectedItem();
		//System.out.println(portName);
		portName=portName.substring(portName.lastIndexOf(" ")+1);
		txtOutputPortName.setText(portName);
	 }
	 
  }
  
  public void actionPerformed(ActionEvent event) {
	 Object src = event.getSource();
	 //	 SystemConfiguration sc=model.getSystemConfiguration();
	 int first,second,i,j;
	 String name;
	 if (src==btnOK) {
	   // model.setSystemName(txtSystemName.getText());
	   model.setVersion(txtVersion.getText());
	   model.setLastRevision(txtLastRevision.getText());
	   model.setDescription(txtDescription.getText());
	   model.setAuthor(txtAuthor.getText());
	   model.setDate(txtDate.getText());
	   model.setSystemConfiguration(sc);
	   setVisible(false);
	   dispose();
	 } 
	 else if(src==btnCancel) {
	   setVisible(false);
	   dispose();
	 } 
	 else if (src==btnInputChange) {
	   //what exactly is this supposed to do??--jrj
	   if (lstInputPortNames.getSelectedIndex()>=0) {
	     i = lstInputPortNames.getSelectedIndex();
	      StringBuffer sb=new StringBuffer("     ");
	     sb.insert(0,String.valueOf(i));
	     sb.setLength(5);
	     lstInputPortNames.replaceItem(sb+"          "+txtInputPortName.getText(),i);

	   } else {
	     txtInputPortName.setText("Change What?");
	   }
	   
	 } 
	 else if(src==btnOutputChange) {
	   //what exactly is this supposed to do??--jrj
	   if (lstOutputPortNames.getSelectedIndex()>=0) {
	     i = lstOutputPortNames.getSelectedIndex();
	      StringBuffer sb=new StringBuffer("     ");
	     sb.insert(0,String.valueOf(i));
	     sb.setLength(5);
	     lstOutputPortNames.replaceItem(sb+"          "+txtOutputPortName.getText(),i);

	   } else {
	     txtOutputPortName.setText("Change What?");
	   }
	 }
	 else if (src==btnOutputAdd){
	   System.out.println("Pushed button output add--not implemented yet, but this should bring up a list of all output ports in the system and allow you to select one to make an output of the whole system");
	 }
	 else if (src==btnOutputRemove){
	   System.out.println("Pushed button output remove");
	   i= lstOutputPortNames.getSelectedIndex();
	   //get the parent of this ManagerModel
	   /*
	   //get from the parent the module producing that output
	   PortLocation pl=sc.getOutputAgent(i);
	   String moduleName=pl.getAgentName();
	   Module producer=model.getModule(moduleName);
	   //get Connectlines that are connected to the output
	   int portNum=pl.getPortNumber();
	   Vector connectLines=producer.getOutputConnectLines(portNum);
	   //remove ConnectLine
	   ConnectLine cl;
	   Enumeration enum=connectLines.elements();
	   while(enum.hasMoreElements()){
	       cl=(ConnectLine)enum.nextElement();
	       model.deleteConnection(cl);
	   }
	   */
	   
	   //delete the output from the system configuration
	   sc.deleteOutputPort(i);
	   displayOutputPorts();
	 }
	 else if (src==btnOutputUp){
	   System.out.println("Pushed button output up");
	   
	   first  = lstOutputPortNames.getSelectedIndex();
	   second = first-1;
	   if (sc.swapOutputPorts(first,second)){
	     displayOutputPorts();
	   }
	 }
	 else if (src==btnOutputDown){
	   System.out.println("Pushed button output down");
	   first  = lstOutputPortNames.getSelectedIndex();
	   second = first+1;
	   if (sc.swapOutputPorts(first,second)){
	     displayOutputPorts();
	   }
	 }
	 else if (src==btnInputUp){
	   System.out.println("Pushed button input up");
	   
	   first  = lstInputPortNames.getSelectedIndex();
	   second = first-1;
	   if (sc.swapInputPorts(first,second)){
	     displayInputPorts();
	   }
	 }
	 else if (src==btnInputDown){
	   System.out.println("Pushed button output down");
	   first  = lstInputPortNames.getSelectedIndex();
	   second = first+1;
	   if (sc.swapInputPorts(first,second)){
	     displayInputPorts();
	   }
	 }
	 else{
	   System.out.println("You pushed "+src.toString());
	   System.out.println("the functionality for this is not yet implemented");
	 }
  }
  
  

  class WindowListener extends WindowAdapter {
	 public void windowClosing(WindowEvent evt) {
		dispose();

	 }
  }
  
}
