package adaptive.modulemanager;

import java.awt.*;
import java.awt.event.*;


public class FrmAbout extends Frame implements ActionListener {
  public FrmAbout(String pname,String v) {
	 setLayout(new GridBagLayout());
	 setTitle("About");
	 
	 GridBagConstraints  gbc = new GridBagConstraints();
	 gbc.weightx=0;
	 gbc.weighty=50;
	 gbc.fill=GridBagConstraints.BOTH;
	 gbc.anchor=GridBagConstraints.CENTER;
	 
	 Label l = new Label(pname);
	 add(l,1,1,1,1,gbc);
	 l = new Label("Version: "+v);
	 add(l,1,2,1,1,gbc);
	 
	 gbc.weightx=100;
	 gbc.weighty=0;
	 Button b = new Button("Ok");
	 b.addActionListener(this);
	 add(b,1,3,1,1,gbc);
	 
	 pack();
	 
	 addWindowListener(new WindowListener());
  }

  private void add(Component c,int x, int y, int w, int h,
						 GridBagConstraints gbc) {
	 gbc.gridx=x;
	 gbc.gridy=y;
	 gbc.gridwidth=w;
	 gbc.gridheight=h;
	 add(c,gbc);
  }

  public void actionPerformed(ActionEvent evt) {
	 dispose();
  }
  
   

  class WindowListener extends WindowAdapter {
	 public void windowClosing(WindowEvent evt) {
		dispose();
	 }
  } 
}
