package adaptive.modulemanager;

import java.awt.*;
import java.awt.event.*;
/**
 * Folder class. Just a little picture of a folder. Nothing special.
 *
 * @author Yatish Patel
 * @version 1.0
 */
public class Folder extends Canvas {

  private String name;
  private Frame parent;
  private Font font;
  private Font bigFont;
  private boolean bigText;
  

  /**
	 * Construct a new folder.
	 */
  public Folder() {
	 name = null;
	 font = new Font("SansSerif",Font.PLAIN,12);
	 bigFont = new Font("SansSerif",Font.BOLD,16);
	 setSize(80,80);
	 //setBackground(Color.yellow);
	 MouseListener mouseListener = new MouseListener();
	 MouseMotionListener mouseMotionListener = new MouseMotionListener();
	 addMouseListener(mouseListener);
	 addMouseMotionListener(mouseMotionListener);
  }
  
  /**
	 * Construct a new folder with a given name, parent and font.
	 *
	 * @param n The Name of the folder
	 * @param p The parent of the folder
	 * @param f The Font to use when displaying the name
	 */
  public Folder(String n,Frame p,Font f) {
	 this();
	 name=n;
	 parent=p;
	 font=f;
  }

  /**
	 * Tells this folder whether to display it's full name in big text
	 *
	 * @param bigText true if this folder should display it's name big
	 */
  public void setBigText(boolean bigText) {
	 this.bigText=bigText;
	 System.out.println(bigText);
	 repaint();
  }
  
  public void drawText(Graphics g,int x,int y) {
	 //g = ((Browser)parent).getPanelGraphics();
	 //Point p = getLocation();

	 
	 g.setFont(bigFont);
	 g.setColor(Color.black);
	 g.drawString(name,x+8,y+45);
	 
  }
  

  /**
	 * Draws the folder.
	 *
	 * @param g The graphics context to draw on.
	 */
  public void drawFolder(Graphics g) {
	 // System.out.println("Drawing on "+g);
	 
	 g.setColor(Color.yellow);
	 g.fillRect(5,15,60,60);
	 g.fillRect(5,5,20,10);
	 g.setColor(Color.black);
	 g.drawRect(5,15,60,60);
	 g.drawRect(5,5,20,10);
	 

	 if (bigText) {
		// we have to get the parents graphics context
		/*
		g = ((Browser)parent).getPanelGraphics();
		Point p = getLocation();
		g.setFont(bigFont);
		g.setColor(Color.black);
		g.drawString(name,p.x+8,p.y+45); */
	 } else {
		// I have to draw the name in my graphics context and the parents
		// if it's bigText
		g.setFont(font);
		g.setColor(Color.black);
		g.drawString(name,8,45);
	 }
	 
	 
	 
  }
  /*
  public void repaint() {
	 System.out.println("repaint folder");
	 
  }*/
  
  /*
  public void update(Graphics g) {
	 System.out.println("update folder");
	 
  }
  */

  public void paint(Graphics g) {
	 //System.out.println("paint folder");
	 drawFolder(g);
  }
  

	 class MouseListener extends java.awt.event.MouseAdapter
	 {
		  public void mouseClicked(java.awt.event.MouseEvent event)
		  {
				if (event.getClickCount()>=1) {
					 ((Browser)parent).changeLocation(name);
					 
				}
		  }
	 }
  
  class MouseMotionListener extends java.awt.event.MouseMotionAdapter {
	 public void mouseMoved(java.awt.event.MouseEvent event) {
		((Browser)parent).mouseMovement(event);
	 }
  }
  
	 /*

  class FocusListener extends java.awt.event.FocusAdapter {
	 public void focusGained(java.awt.event.ComponentEvent event) {
		System.out.println("focusGained");
	 }

	 public void focusLost(java.awt.event.ComponentEvent event) {
		System.out.println("focusLost");
	 } 
  }*/
  
		  
  
  
}




