package adaptive.modulemanager;
import java.awt.*;
import java.awt.event.*;



/**
 * Save dialog box.  Asks the user if he wants to save the changes that
 * have been made before quitting. 
 *
 * Very similar to the Xemacs warnings when you try to exit without saving.
 *
 * @author Yatish Patel
 * @version 1.0
 */
public class DlgSave extends Dialog implements ActionListener {

  private final byte SAVE = 0;
  private final byte SAVE_ALL = 1;
  private final byte CANCEL = 2;
  private final byte DISCARD = 3;
  private final byte DISCARD_ALL = 4;
  private final byte NONE = 5;
  
  private byte action;
  private Button btnSave,btnSaveAll,btnDiscard,btnDiscardAll,btnCancel;
  

  public DlgSave(Frame f,String systemName,boolean includeAll) {
	 super(f,true);
	 action=NONE;
	 
	 setTitle("Unsaved Views");
	 setLayout(new BorderLayout());
	 
	 Label l = new Label("Save system: "+systemName+"?");
	 Panel buttonPanel = new Panel();
	 buttonPanel.setLayout(new FlowLayout());
	 
	 add(l,"Center");
	 
	 btnSave=new Button("Save");
	 btnSave.addActionListener(this);
	 
	 if (includeAll) {
		btnSaveAll=new Button("Save All");
		btnSaveAll.addActionListener(this);
	 }
	 
	 
	 btnDiscard=new Button("Discard");
	 btnDiscard.addActionListener(this);
	 
	 if (includeAll) {
		btnDiscardAll=new Button("Discard All");
		btnDiscardAll.addActionListener(this);
	 }
	 
	 
	 btnCancel=new Button("Cancel");
	 btnCancel.addActionListener(this);
	 
	 buttonPanel.add(btnSave);
	 if (includeAll) 
		buttonPanel.add(btnSaveAll);
	 buttonPanel.add(btnDiscard);
	 if (includeAll) 
		buttonPanel.add(btnDiscardAll);
	 buttonPanel.add(btnCancel);
	 add(buttonPanel,"South");

	 addWindowListener(new WindowListener());
	 
	 pack();
	 
	 
  }

  public boolean isSave() {
	 return action==SAVE;
  }
  
  public boolean isSaveAll() {
	 return action==SAVE_ALL;
  }
  
  public boolean isDiscard() {
	 return action==DISCARD;
  }
  
  public boolean isDiscardAll() {
	 return action==DISCARD_ALL;
  }
  
  public boolean isCancel() {
	 return action==CANCEL;
  }
  

  
  public void actionPerformed(ActionEvent evt) {
	 Object o = evt.getSource();
	 if (o==btnSave) {
		action=SAVE;
	 } else if (o==btnSaveAll) {
		action=SAVE_ALL;
	 } else if (o==btnDiscard) {
		action=DISCARD;
	 } else if (o==btnDiscardAll) {
		action=DISCARD_ALL;
	 } else if (o==btnCancel) {
		action=CANCEL;
	 }
	 if (!(action==NONE)) {
		setVisible(false);
	 }
	 
  }
  

  class WindowListener extends WindowAdapter {
	 public void windowClosing(WindowEvent evt) {
		action=CANCEL;
		setVisible(false);
	 }
  }
  
  
}
