package adaptive.modulemanager;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.lang.reflect.*;

// YODA: problems when edit array values then hit cancel... array values are saved!

/**
 * The Default State Editor object.  Make it simple for agent writers to
 * add state editing support to an agent.  The agent/module is responsible
 * for verification of the format of the data.
 *
 * @version 1.0
 * @author heller
 * $Log: DefaultStateEditor.java,v $
 * Revision 1.2.2.3  2000/04/28 04:14:36  jrj
 * rewrote part of the state editing stuff so that it works like it
 * should and so that agents actually can provide their own state editor
 *
 */
public class DefaultStateEditor extends Dialog implements StateEditor, ActionListener {

  /**
    * Default constructor.  does nothing
    */
    public DefaultStateEditor(Frame parent) {
	this(parent,true);
    }
    public DefaultStateEditor(Frame parent,boolean modal){
	super(parent,modal);
	btnHashTable = new Hashtable();
    }

  /**
    * editState()
    * gets mod's state and then displays a window with the data
    *
    * @param mod The module whose state will be edited
    */
  public void editState( adaptive.modulemanager.Module mod ) {
    editMod = mod;
    setTitle( "Edit State: " + editMod.getName() );

    // YODA: am i using these functions right???
    // YODA: no... i think... maybe though...
    state = editMod.getInternalParameters();
    Object labels = editMod.getAgent().getStateDescription();
    String[] stateStrs;

    // make sure we have two good arrays before continuing...
    if( state == null ) {
      state = editMod.getAgent().getDefaultState();
      if( state == null ) {
	return;
      }
    }

    String[] labelStrsTmp;
    if( labels == null ) {
      labelStrsTmp = null;
    } else {
      if( labels instanceof String[] ) {
	labelStrsTmp = (String []) labels;
      } else {
	labelStrsTmp = null;
      }
    }

    // use GB... yatish uses absolute... GB is more code, but what the hell...
    Panel panel = new Panel();
    panel.setLayout( new GridBagLayout() );

    GridBagConstraints gbc0 = new GridBagConstraints();
    GridBagConstraints gbc1 = new GridBagConstraints();
    gbc0.gridx = 0;
    gbc1.gridx = 1;
    gbc0.gridwidth = 1;
    gbc1.gridwidth = 1;
    gbc0.gridheight = 1;
    gbc1.gridheight = 1;
    gbc0.weightx = 100;
    gbc1.weightx = 100;
    gbc0.weighty = 100;
    gbc1.weighty = 100;
    gbc0.fill = GridBagConstraints.NONE;
    gbc1.fill = GridBagConstraints.HORIZONTAL;

    stateStrs = stateToStrs( state );
    if( stateStrs == null ) {
      System.out.println( "DefaultStateEditor: State is not default" );
      return;
    }

    textFields = new TextField[ stateStrs.length ];
    arrayEds = new ArrayEditor[ stateStrs.length ];
    labelStrs = new String[ stateStrs.length ];
    int j = 0;
    for( int i = 0; i < stateStrs.length; i++ ) {
      // make sure that labelStrs is same len as stateStrs
      if( labelStrsTmp != null && i < labelStrsTmp.length ) {  // fill labelStrs
	labelStrs[i] = labelStrsTmp[i];
      } else {
	labelStrs[i] = "";
      }

      if( stateStrs[i] != null ) {
	try {
	  if( ( (Object []) state)[i].getClass().isArray() ) {
	    // if it is an array, then allow to edit size and values
	    Button btn;
	    gbc0.gridy = j;
	    gbc1.gridy = j;
	    panel.add( new Label( labelStrs[i] + " Size" ), gbc0 );
	    panel.add( textFields[i] = new TextField( stateStrs[i], 12 ), gbc1 );
	    j++;  // only increment j if there is an field to display
	    gbc0.gridy = j;
	    gbc1.gridy = j;
	    panel.add( new Label( labelStrs[i] + " Values" ), gbc0 );
	    panel.add( btn = new Button( "Edit Values" ) , gbc1 );
	    btn.addActionListener( this );
	    // knowing i gives access to size (textFields) and array (state)
	    btnHashTable.put( btn, new Integer( i ) );
	    j++;  // only increment j if there is an field to display
	  } else {
	    gbc0.gridy = j;
	    gbc1.gridy = j;
	    panel.add( new Label( labelStrs[i] ), gbc0 );
	    panel.add( textFields[i] = new TextField( stateStrs[i], 12 ), gbc1 );
	    j++;  // only increment j if there is an field to display
	  }
	} catch( ClassCastException e ) {
	  gbc0.gridy = j;
	  gbc1.gridy = j;
	  panel.add( new Label( labelStrs[i] ), gbc0 );
	  panel.add( textFields[i] = new TextField( stateStrs[i], 8 ), gbc1 );
	  j++;  // only increment j if there is an field to display
	}
      } else {
	textFields[i] = null;
      }
    }

    Button okB = new Button( "OK" );
    Button canB = new Button( "Cancel" );
    Button clearB = new Button("Clear");
    okB.addActionListener( this );
    canB.addActionListener( this );
    clearB.addActionListener(this);
    
    gbc0.gridy = gbc1.gridy = j;
    gbc0.weighty = 0;
    gbc1.weighty = 0;
    gbc1.fill = GridBagConstraints.NONE;
    gbc0.anchor = GridBagConstraints.EAST;
    gbc1.anchor = GridBagConstraints.WEST;
    panel.add( okB, gbc0 );
    panel.add( canB, gbc1 );
    gbc1.gridx=2;
    panel.add(clearB,gbc1);
    add( "Center", panel );

    /* just a guess at the needed size, seems to work well */
    //setSize( 250, 30 * ( 2 + j ) );
    pack();
    addWindowListener( new
      WindowAdapter() {
	public void windowClosing( WindowEvent e ) {
	  dispose();
	}
      }
    );

    show();
  }

  /** stateToStrs returns the string representation of the state
  */
  protected static String[] stateToStrs( Object state ) {
    String[] retStrings = null;

    if( state.getClass().isArray() ) {
      if( state.getClass().getComponentType() == java.lang.Integer.TYPE ) {
	int[] intArr = (int []) state;
	retStrings = new String[ intArr.length ];
	for( int i = 0; i < intArr.length; i++ ) {
	  retStrings[i] = Integer.toString( intArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Long.TYPE ) {
	long[] longArr = (long []) state;
	retStrings = new String[ longArr.length ];
	for( int i = 0; i < longArr.length; i++ ) {
	  retStrings[i] = Long.toString( longArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Short.TYPE ) {
	short[] shortArr = (short []) state;
	retStrings = new String[ shortArr.length ];
	for( int i = 0; i < shortArr.length; i++ ) {
	  retStrings[i] = Short.toString( shortArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Float.TYPE ) {
	float[] floatArr = (float []) state;
	retStrings = new String[ floatArr.length ];
	for( int i = 0; i < floatArr.length; i++ ) {
	  retStrings[i] = Float.toString( floatArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Double.TYPE ) {
	double[] doubleArr = (double []) state;
	retStrings = new String[ doubleArr.length ];
	for( int i = 0; i < doubleArr.length; i++ ) {
	  retStrings[i] = Double.toString( doubleArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Character.TYPE ) {
	char[] charArr = (char []) state;
	retStrings = new String[ charArr.length ];
	for( int i = 0; i < charArr.length; i++ ) {
	  retStrings[i] = new Character( charArr[i] ).toString();
	}
      } else if( state.getClass().getComponentType() == java.lang.Byte.TYPE ) {
	byte[] byteArr = (byte []) state;
	retStrings = new String[ byteArr.length ];
	for( int i = 0; i < byteArr.length; i++ ) {
	  retStrings[i] = Byte.toString( byteArr[i] );
	}
      } else if( state.getClass().getComponentType() == java.lang.Boolean.TYPE ) {
	boolean[] booleanArr = (boolean []) state;
	retStrings = new String[ booleanArr.length ];
	for( int i = 0; i < booleanArr.length; i++ ) {
	  retStrings[i] = new Boolean( booleanArr[i] ).toString();
	}
      } else if( state instanceof Object[] ) {
	Object[] objArr = (Object[]) state;
	retStrings = new String[ objArr.length ];
	for( int i = 0; i < objArr.length; i++ ) {
	  if( objArr[i] == null ) {
	    throw new NullPointerException( "Object " + i + " is null" );
	  } else if( ( objArr[i] instanceof Integer ) ||
		      ( objArr[i] instanceof Long ) ||
		      ( objArr[i] instanceof Short ) ||
		      ( objArr[i] instanceof Float ) ||
		      ( objArr[i] instanceof Double ) ||
		      ( objArr[i] instanceof Character ) ||
		      ( objArr[i] instanceof Byte ) ||
		      ( objArr[i] instanceof Boolean ) ||
		      ( objArr[i] instanceof String ) ) {
	    retStrings[i] = objArr[i].toString();
	  } else if( objArr[i].getClass().isArray() ) {
	    retStrings[i] = Integer.toString( Array.getLength( objArr[i] ) );
	  } else {
	    retStrings[i] = null;
	  }
	}
      }

      return retStrings;
    } else {
      return null;
    }
  }

  /** strsToState takes the strings from the user and sets the state
  */
  protected static Object strsToState( String[] userStrs, Object state, Frame parent ) {
    try {
      if( state.getClass().isArray() ) {
	if( state.getClass().getComponentType() == java.lang.Integer.TYPE ) {
	  int[] intArr = (int []) state;
	  for( int i = 0; i < intArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      intArr[i] = Integer.parseInt( userStrs[i] );
	    }
	  }
	  state = intArr;
	} else if( state.getClass().getComponentType() == java.lang.Long.TYPE ) {
	  long[] longArr = (long []) state;
	  for( int i = 0; i < longArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      longArr[i] = Long.parseLong( userStrs[i] );
	    }
	  }
	  state = longArr;
	} else if( state.getClass().getComponentType() == java.lang.Short.TYPE ) {
	  short[] shortArr = (short []) state;
	  for( int i = 0; i < shortArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      shortArr[i] = Short.parseShort( userStrs[i] );
	    }
	  }
	  state = shortArr;
	} else if( state.getClass().getComponentType() == java.lang.Float.TYPE ) {
	  float[] floatArr = (float []) state;
	  for( int i = 0; i < floatArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      floatArr[i] = Float.valueOf( userStrs[i] ).floatValue();
	    }
	  }
	  state = floatArr;
	} else if( state.getClass().getComponentType() == java.lang.Double.TYPE ) {
	  double[] doubleArr = (double []) state;
	  for( int i = 0; i < doubleArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      doubleArr[i] = Double.valueOf( userStrs[i] ).doubleValue();
	    }
	  }
	  state = doubleArr;
	} else if( state.getClass().getComponentType() == java.lang.Character.TYPE ) {
	  char[] charArr = (char []) state;
	  for( int i = 0; i < charArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      charArr[i] = userStrs[i].charAt( 0 );  // only use the first char
	    }
	  }
	  state = charArr;
	} else if( state.getClass().getComponentType() == java.lang.Byte.TYPE ) {
	  byte[] byteArr = (byte []) state;
	  for( int i = 0; i < byteArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      byteArr[i] = Byte.parseByte( userStrs[i] );
	    }
	  }
	  state = byteArr;
	} else if( state.getClass().getComponentType() == java.lang.Boolean.TYPE ) {
	  boolean[] booleanArr = (boolean []) state;
	  for( int i = 0; i < booleanArr.length; i++ ) {
	    if( userStrs[i] != null && ! userStrs[i].equals( "" ) ) {
	      booleanArr[i] = Boolean.valueOf( userStrs[i] ).booleanValue();
	    }
	  }
	  state = booleanArr;
	} else if( state instanceof Object[] ) {
	  Object[] objArr = (Object[]) state;
	  for( int i = 0; i < objArr.length; i++ ) {
	    if( userStrs[i] != null ) {
	      if( objArr[i] instanceof Integer ) {
		objArr[i] = Integer.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Long ) {
		objArr[i] = Long.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Short ) {
		objArr[i] = Short.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Float ) {
		objArr[i] = Float.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Double ) {
		objArr[i] = Double.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Character ) {
		objArr[i] = new Character( userStrs[i].charAt( 0 ) );
	      } else if( objArr[i] instanceof Byte ) {
		objArr[i] = Byte.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof Boolean ) {
		objArr[i] = Boolean.valueOf( userStrs[i] );
	      } else if( objArr[i] instanceof String ) {
		objArr[i] =  userStrs[i];
	      }
	    }
	  }
	  state = objArr;
	}
      }
      return state;
    } catch( Exception e ) {
      if( e instanceof NumberFormatException ) {
	(new ErrorDialog( parent, "Improperly Formatted Number: " + e.getMessage(), true ) ).show();
      } else {
	(new ErrorDialog( parent, e.toString(), true ) ).show();
      }
      return null;
    }
  }

  /* resize and copy the array if necessary
     if the array is shrunk, then the data is lost */
  private void resizeArray( Object[] state, int index, int size ) {
    if( state[index] != null && state[index].getClass().isArray() ) {
      int length = Array.getLength( state[index] );
      if( length == size ) {
	return;
      } else {
	Object newObjArr = Array.newInstance( state[index].getClass().getComponentType(), size );
	for( int i = 0; i < size; i++ ) {
	  if( i < length ) {
	    Array.set( newObjArr, i, Array.get( state[index], i ) );
	  } else {
	    // Array.set( newObjArr, i, null );
	    Array.set( newObjArr, i, Array.get( newObjArr, i - 1 ) );
	    /*
	    try{
	      Array.set( newObjArr, i, Array.get( newObjArr, i - 1 ).clone() );
	    } catch( Exception e ) {
	      System.out.println( "resizeArray: " + e.toString() );
	      return;
	    }
	    */
	  }
	    /*
	    try{
	      newObjArr[i] = state[index].getClass().getComponentType().newInstance();
	    } catch( Exception e ) {
	      System.out.println( "resizeArray: " + e.toString() );
	      return;
	    }
	    newObjArr[i] = newObjArr[i-1].clone();
	    */
	}
	state[index] = newObjArr;
      }
    }
  }

  /** handles events.  only handles button clicks
    * @param e The event that just occurred
    */
  public void actionPerformed( ActionEvent e ) {
    String s = e.getActionCommand();
    if( s.equals( "OK" )  ) {
      String[] stateStrs = new String[ textFields.length ];
      for( int i = 0; i < stateStrs.length; i++ ) {
	if( textFields[i] != null ) {
	  stateStrs[i] = textFields[i].getText();
	} else {
	  stateStrs[i] = null;
	}
      }
      // YODA: what if array size is edited, but values not edited?
      if( ( state = strsToState( stateStrs, state, (Frame)this.getParent() ) ) != null ) {
	String err = editMod.getAgent().verifyState( state );
	if( err == null ) { // state was saved back to module successfully
	  editMod.setInternalParameters( state );
	  dispose();
	  return;
	} else { // problem with setInternalParameters, report to user
	  (new ErrorDialog( (Frame)this.getParent(), err, true ) ).show();
	}
      } else {
	// YODA: do we need to do anything if strsToState returns null?
      }
    } else if( s.equals( "Cancel" ) ) {
      dispose(); 
    }
    else if (s.equals("Clear")){
      state=null;
      editMod.setInternalParameters(state);
      textFields=null;
      // removeAll();
      dispose();
      return;
    } else if( s.equals( "Edit Values" ) ) {
      Object obj = btnHashTable.get( e.getSource() );
      if( obj instanceof Integer ) {
	Integer i = (Integer) obj;

	// see if the array is currently being edited
	if( arrayEds[i.intValue()] == null ) {
	  arrayEds[i.intValue()] = new ArrayEditor( (Frame)this.getParent() );
	} else {
	  if( arrayEds[i.intValue()].editing() ) {
	    return;
	  }
	}

	int size;
	try {
	  // resize then edit the array
	  size = Integer.parseInt( textFields[ i.intValue() ].getText() );
	  resizeArray( (Object[]) state, i.intValue(), size );
	  arrayEds[i.intValue()].editArray( (Object []) state, i.intValue(), labelStrs[i.intValue()] );
	} catch( Exception ex ) {
	  if( ex instanceof NumberFormatException ) {
	    (new ErrorDialog( (Frame)this.getParent(), "Invalid Size: " + ex.getMessage(), true ) ).show();
	  } else {
	    (new ErrorDialog((Frame) this.getParent(), "Edit Values: " + ex.toString(), true ) ).show();
	  }
	}
      } else {
	System.out.println( "DefaultStateEditor: button not found" );
      }
    }
  }

  private ArrayEditor[] arrayEds;
  private TextField[] textFields;
  private String[] labelStrs;
  private Object state;
  private adaptive.modulemanager.Module editMod;
  private Hashtable btnHashTable; // hash table for the buttons
}


class ArrayEditor extends Dialog implements ActionListener {
  public ArrayEditor( Frame parent ) {
    super( parent, false );
  }

  public void editArray( Object[] inState, int inIndex, String inLabel ) {
    // needs the whole state in case the array needs to be resized and copied and all
    state = inState;
    index = inIndex;
    label = inLabel;
    setTitle( "Edit " + label + " Values" );
    editing = true;

    // YODA:
    // check size/resize array  - - who does this???
    // draw window and textfields and labels and all
    Panel panel = new Panel();
    panel.setLayout( new GridBagLayout() );

    GridBagConstraints gbc0 = new GridBagConstraints();
    GridBagConstraints gbc1 = new GridBagConstraints();
    GridBagConstraints gbc2=new GridBagConstraints();
    gbc0.gridx = 0;
    gbc1.gridx = 1;
    gbc2.gridx=2;
    gbc0.gridwidth = 1;
    gbc1.gridwidth = 1;
    gbc2.gridwidth=1;
    gbc0.gridheight = 1;
    gbc1.gridheight = 1;
    gbc2.gridheight=1;
    gbc0.weightx = 100;
    gbc1.weightx = 100;
    gbc2.weightx = 100;
    gbc0.weighty = 100;
    gbc1.weighty = 100;
    gbc2.weighty=100;
    gbc0.fill = GridBagConstraints.NONE;
    gbc1.fill = GridBagConstraints.HORIZONTAL;
    gbc2.fill = GridBagConstraints.NONE;
    String[] stateStrs;
    try {
      stateStrs = DefaultStateEditor.stateToStrs( state[index] );
    } catch( Exception ex ) {
      return;
    }

    if( stateStrs == null ) {
      System.out.println( "ArrayEditor: index is not an array" );
      return;
    }

    textFields = new TextField[ stateStrs.length ];
    int j = 0;
    for( int i = 0; i < stateStrs.length; i++ ) {
      if( stateStrs[i] != null ) {
	gbc0.gridy = j;
	gbc1.gridy = j;
	panel.add( new Label( label + " [ " + i + " ]" ), gbc0 );
	panel.add( textFields[i] = new TextField( stateStrs[i], 12 ), gbc1 );
	j++;
      } else {
	textFields[i] = null;
      }
    }

    Button okB = new Button( "OK" );
    Button canB = new Button( "Cancel" );
    Button clearB = new Button("Clear");
    okB.addActionListener( this );
    canB.addActionListener( this );
    clearB.addActionListener(this);

    gbc0.gridy = gbc1.gridy = gbc2.gridx=j;
    gbc0.weighty = 0;
    gbc1.weighty = 0;
    gbc2.weighty = 0;
    gbc1.fill = GridBagConstraints.NONE;
    gbc0.anchor = GridBagConstraints.EAST;
    gbc1.anchor = GridBagConstraints.WEST;
    gbc2.anchor=GridBagConstraints.CENTER;
    panel.add( okB, gbc0 );
    panel.add( canB, gbc1 );
    panel.add(clearB,gbc2);
    

    add( "Center", panel );

    /* just a guess at the needed size, seems to work well */
    //setSize( 250, 30 * ( 2 + j ) );
    pack();

    addWindowListener( new
      WindowAdapter() {
	public void windowClosing( WindowEvent e ) {
	  removeAll();
	  dispose();
	}
      }
    );

    show();
  }

  public void actionPerformed( ActionEvent e ) {
    String s = e.getActionCommand();
    if( s.equals( "OK" ) ) {
      String[] stateStrs = new String[ textFields.length ];
      for( int i = 0; i < stateStrs.length; i++ ) {
	if( textFields[i] != null ) {
	  stateStrs[i] = textFields[i].getText();
	} else {
	  stateStrs[i] = null;
	}
      }
      Object arrObj;
      if( ( arrObj = DefaultStateEditor.strsToState( stateStrs, state[index], (Frame) this.getParent() ) ) != null ) {
	// String err = editMod.getAgent().verifyState( state );  do we need this here?
	// if( err == null ) { // state was saved back to module successfully
	  // YODA: save state back to array  - - is this right?
	  state[index] = arrObj;
	  editing = false;
	  textFields = null;
	  removeAll();
	  dispose();
	  return;
	// } else { // problem with setInternalParameters, report to user
	  // (new ErrorDialog( this.getParent(), err, true ) ).show();
	// }
      } else {
	// YODA: do we need to do anything if strsToState returns null?
      }
    } else if( s.equals( "Cancel" ) ) {
      editing = false;
      textFields = null;
      removeAll();
      dispose();
    }
    else if (s.equals("Clear")){
      state=null;
      editing=false;
      textFields=null;
      removeAll();
      dispose();
    }
  }

  public boolean editing() {
    return editing;
  }

  private boolean editing;
  private Object[] state;
  private int index;
  private String label;
  private TextField[] textFields;
}
