package adaptive.modulemanager;

import java.util.*;
import adaptive.core.net.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import adaptive.core.*;
/***********
CoordinatorInfo
* $Log: CoordinatorInfo.java,v $
* Revision 1.1.2.6  2000/05/20 22:17:10  jrj
* Updated error message handling so an exception in Coordinator when
* trying to execute a configuration will appear in ModuleManager's
* status window
*
* Revision 1.1.2.5  2000/04/10 20:18:06  ntolia
*
* Provides support for the ModuleManager to send messages as an applet.
* HandshakeProtocol has been created to perform authentication across
* different modules.
* Changed CoordinatorInfo and ModuleManager to be able to work as an applet.
* Uses the Redirector to send (redirected) messages to a Coordinator via
* the server.
*
* Revision 1.1.2.4  2000/03/07 02:25:01  jrj
* I may have made some minor changes so that it plays better with
* ConfigurationExecutor, but I'm not positive.  It was a couple weeks
* ago I actually made any changes here.
*
*/
public class CoordinatorInfo extends Thread {
  Socket socket;
  String host;
  int port;
  SystemConfiguration sc;
  ObjectOutputStream outStream;
  ObjectInputStream inStream;
  Vector agentServer;
  public boolean goon;

    protected Observable signal; //used to send messages to anything watching the execution--namely, ConfigurationExecutor
  
  // Adding the following boolean in the Constructor to make provision for when
  // this is running as an applet.
  private boolean isApplet;
  // Create a Vector to pass to the redirector when running as an applet
  // The connection parmas are going to be a Vector of size 2. 
  // The Vector contains - at location 0 - host (String)
  //                     - at location 1 - port (Integer). 
  private Vector connectParams=null;
  private Redirector red = null;
  private String serverName;
  
  StopWindow s;
  

  public CoordinatorInfo(String host,int port,SystemConfiguration sc,Vector v,boolean isApplet,String serverName){
    this.host=host;
    this.port=port;
    this.sc=sc;
    this.agentServer=v;
    this.isApplet = isApplet;// isApplet;
    this.serverName = serverName;

    // Is this running as an applet ?
    if (this.isApplet == true)
      {
	// This is an applet. Initialize the Vector to pass to the redirector.
	connectParams = new Vector (2);
	connectParams.insertElementAt(host,0);
	connectParams.insertElementAt(new Integer(port) , 1);
	//	red.start();
      }
    goon=true;
    signal=new MessageSender();
    s = new StopWindow(this);
    s.show();
  }
  
  
  // Included to maintain code compatability. Is the old constructor. Should
  // be removed soon.
  public CoordinatorInfo(String host,int port,SystemConfiguration sc,Vector v){
    this.host=host;
    this.port=port;
    this.sc=sc;
    this.agentServer=v;
    goon=true;
    signal=new MessageSender();
    s = new StopWindow(this);
    s.show();
  }
    public synchronized void addObserver(Observer o){
	System.out.println("Added observer "+o);
	signal.addObserver(o);
    }

    
  public void run() {
    try {
      if ( isApplet == false ) 
	{
	  socket = new Socket(host,port);
	  outStream = new ObjectOutputStream(socket.getOutputStream());
	  inStream = new ObjectInputStream(socket.getInputStream());
	}
      else if ( isApplet == true ) 
	{
	  	   
	  System.out.println ("!!!!!!!!!!!!!!!!!  Using the Message Redirector  !!!!!!!!!!!!!!!!!!!!");
	  System.out.println ("Trying to connect on server name "+ serverName);
	  
	  socket = new Socket(serverName,8700);
	  outStream = new ObjectOutputStream(socket.getOutputStream());
	  inStream = new ObjectInputStream(socket.getInputStream());
	  outStream.flush();

	  // TODO : Do authentication here.. find out for sure if we are ACTUALLY 
	  // connecting to a Redirector.
	  System.out.println ("Checking for Redirector at the other end...trying to Handshake");
	  
	  if (HandshakeProtocol.goodReceiver(HandshakeProtocol.kIAMAMODULEMANAGER,HandshakeProtocol.kIAMAREDIRECTOR,inStream,outStream))
	    {
	      System.out.println ("Handshake successful");
	      outStream.writeObject(connectParams);
	      outStream.flush();
	    }
	  else 
	    {
	      System.out.println ("Handshake failed! Closing socket..");
	      socket.close();
	      return;
	    }
	  // Authentication for Redirector done.. 
	}
      System.out.print("Sending identification..");
      if (CoordinatorProtocol.goodReceiver(CoordinatorProtocol.kIAMAMODULEMANAGER,CoordinatorProtocol.kIAMACOORDINATOR,inStream,outStream)) {
	System.out.println("..success.");
      } else {
	System.out.println("..unable to identify");
	socket.close();
	return;
      }
    } catch (Exception e) {
      System.out.println("Socket closed in run. Closing down."+e);
      
      signal.notifyObservers(e);
    }
  }

  public void startUp(){
    try{
      Byte d;
      
      outStream.writeObject(CoordinatorProtocol.kRECEIVESYSTEM);
      if (CoordinatorProtocol.isOK(inStream.readObject())) {
	System.out.print("Sending sysconfig...");
	Vector v = new Vector(2);
	v.setSize(2);
	v.setElementAt(sc,0);
	v.setElementAt(agentServer,1);
	outStream.writeObject(v);
	outStream.flush();
	d=(Byte)inStream.readObject();
	if (CoordinatorProtocol.isOK(d)) {
	  System.out.println("..success");
	} else {
	  System.out.println("..FAILED!");
	  Exception e=(Exception)inStream.readObject();
	  System.err.println("The following exception was the cause:");
	  e.printStackTrace();

	  
	  signal.notifyObservers(e);

	  System.err.println();
	  socket.close();
	  s.dispose();
	  this.stop();
	  return;
	} 
      }

      System.out.print("Starting system..");
      outStream.writeObject(CoordinatorProtocol.kSTARTRUN);
      outStream.writeObject(sc.getType());
      if (CoordinatorProtocol.isOK(inStream.readObject())) {
	System.out.println("Success..");
	
	signal.notifyObservers(ConfigurationExecutor.STARTED);
	//	System.out.println("#observers="+signal.countObservers());
      }
      // read in the kSYSTEMSTARTED message
      d=(Byte)inStream.readObject();
      System.out.println("message:"+d); 
    } catch (Exception e) {
      e.printStackTrace();
      
      signal.notifyObservers(e);
      System.out.println("Socket closed. Closing down.");
    }
  }  /* end run() method */

  public void stopSystem(){
    try{
      System.out.print("Stopping system..");
      outStream.writeObject(CoordinatorProtocol.kSTOPRUN);
      Byte c = (Byte)inStream.readObject();
      if (CoordinatorProtocol.isOK(c)) {
	System.out.println("..success.");
      } else if(c.equals(CoordinatorProtocol.kERROR)) {
	  Exception e;
	System.out.print("..Error ");
	e=(Exception)inStream.readObject();
	System.out.println(e);
	
	signal.notifyObservers(e);
      }
      System.out.println("response=="+c);
    } catch (Exception e) {
      System.out.println("Socket closed. Closing down.");
      
      signal.notifyObservers(e);//not sure if I need this one--jrj
    }
  }

  public void shutDown(){
    try{
      System.out.print("shutting down system..");
      outStream.writeObject(CoordinatorProtocol.kSHUTDOWN);
      Byte c=(Byte)inStream.readObject();
      System.out.print(c);
      if (CoordinatorProtocol.isOK(c)) {
	System.out.println("..success");
      } else {
	if (c.equals(CoordinatorProtocol.kERROR)) {
	  Exception j = (Exception)inStream.readObject();
	  System.out.print(j);
	  
	  signal.notifyObservers(j);
	}
	System.out.println("..failed");
      }
      outStream.writeObject(CoordinatorProtocol.kGOODBYE);
      socket.close();
    } catch (Exception e) {
      e.printStackTrace();
      System.out.println("Socket closed. Closing down.");
    }
    System.out.println("end run");
    s.dispose();
    
    signal.notifyObservers(ConfigurationExecutor.FINISHED);
  }

  class StopWindow extends Frame implements ActionListener{
    private CoordinatorInfo ci;
    private Button bStop, bStart, bShutdown;

    public StopWindow(CoordinatorInfo c){
      ci = c;

      Panel p = new Panel();
      p.setLayout(new FlowLayout());

      bStart = new Button("Start");
      bStart.addActionListener(this);
      p.add(bStart);

      bStop = new Button("Stop");
      bStop.addActionListener(this);
      p.add(bStop);

      bShutdown = new Button("Shutdown");
      bShutdown.addActionListener(this);
      p.add(bShutdown);

      add(p);
      pack();

    }

    public void actionPerformed(ActionEvent e){
      Object source = e.getSource();
      if(source == bStart){
	ci.startUp();
      } else if(source == bStop){
	ci.stopSystem();
      } else if(source == bShutdown){
	ci.shutDown();
	//	dispose();
      }

    }
  }
    class MessageSender extends Observable{
	public void notifyObservers(Object arg){
	    setChanged();
	    super.notifyObservers(arg);
	    //System.out.println("Should have sent {"+arg+"} to "+countObservers() );
	}
    }
}

