/*
 * The lines that connect modules
 */
package adaptive.modulemanager;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.awt.*;

public class ConnectLine implements java.io.Serializable 
{

	 public final int HORIZ = 0;
	 public final int VERT = 1;

	 private Point start;
	 private Point finish;
	 private Point tempFinish;

	 private IOPort startPort;
	 private Color lineColor=Color.black;
	 private IOPort finishPort;

	 private Vector bendPoints;
	 private int direction;

  /** Store all the line segments indexed by start point */
  private Hashtable lineSegmentsByStart;
  
  /** Store all the line segments indexed by end point */
  private Hashtable lineSegmentsByEnd;
  

	 public ConnectLine()
	 {
		  bendPoints=new Vector(10,5);
		  lineSegmentsByStart= new Hashtable(10);
		  lineSegmentsByEnd = new Hashtable(10);
		  startPort=new IOPort();
		  finishPort=new IOPort();
	 }
	 
	 public ConnectLine(Point s)
	 {
		  this();
		  start=s;
	 }

  /**
	* Create a line froma string
	*
	*/
  public ConnectLine(String s) {
	 this(s,new Point(0,0));
  }
  
  /**
	 * Construct a ConnectLine with only the port information
	 */
  public ConnectLine(IOPort startPort,IOPort finishPort) {
	 this.startPort=startPort;
	 this.finishPort=finishPort;
	 start=null;
  }
  

  /**
   * Create a line from a string read in from the layout file
   */
  public ConnectLine(String s,Point offset){
    this();
    Point p;
    int comma;
    String l;
    StringTokenizer st = new StringTokenizer(s);
    int numPoints = Integer.valueOf(st.nextToken()).intValue();
    
    // start point
    l = st.nextToken();
    comma=l.indexOf(",");
    p=new Point(Integer.valueOf(l.substring(0,comma)).intValue(),
		Integer.valueOf(l.substring(comma+1)).intValue());
    p.translate(offset.x,offset.y);
    start=p;
    
    // bend points
    for (int x=1;x<numPoints-1;x++) {
      l = st.nextToken();
      comma=l.indexOf(",");
      p=new Point(Integer.valueOf(l.substring(0,comma)).intValue(),Integer.valueOf(l.substring(comma+1)).intValue());
      p.translate(offset.x,offset.y);
      bendPoints.addElement(p);
    }
    
    // finish point
    l = st.nextToken();
    comma=l.indexOf(",");
    p=new Point(Integer.valueOf(l.substring(0,comma)).intValue(),Integer.valueOf(l.substring(comma+1)).intValue());
    p.translate(offset.x,offset.y);
    finish=p;			  
  }
  
  /*
   * Move two of the bend points
   */
  public void movePoints(Point p1, Point p2,int deltaX,int deltaY) 
    {
      
      
    }
  
  
  public void setColor(Color c)
    {
      lineColor=c;
    }
  public Point getFinish()
    {
      return finish;
    }
  
  public Point getStart()
    {
      return start;
    }
  
  public void setStartPort(IOPort p)
    {
      startPort=p;
    }
  
  public void setFinishPort(IOPort p)
    {
      finishPort=p;
    }
  
  public IOPort getStartPort()
    {
      return startPort;
    }
  
  public IOPort getFinishPort()
    {
      return finishPort;
    }
  
  public adaptive.modulemanager.Module getStartModule()
    {
      return startPort.getModule();
    }
  
  public adaptive.modulemanager.Module getFinishModule()
    {
      return finishPort.getModule();
    }
  
  /**
    * Get the type 
    *
    */
  public Class getStartPortType() {
    return startPort.getModule().getPortType(startPort.getType(),
															startPort.getPort());
  }
  
  public Class getFinishPortType() {
    return finishPort.getModule().getPortType(finishPort.getType(),
															 finishPort.getPort());
  }
  
  public int getNumberOfPoints()
    {
      return bendPoints.size()+2;
    }
  
  /*
   * Get the port that corresponds to the specified module
   */
  public IOPort getPort(Module m)
    {
      if (finishPort.getModule()==m) return finishPort;
      else if (startPort.getModule()==m) return startPort;
      
      // Maybe i should throw some sort of exception here? argh. too much
      // of a hassle...
      return null;					  
    }
  
  public IOPort getInputPort()
    {
      if (finishPort.isInput()) return finishPort;
      else if (startPort.isInput()) return startPort;
      return null;
    }
  
  public IOPort getOutputPort()
    {
      if (finishPort.isOutput()) return finishPort;
      else if (startPort.isOutput()) return startPort;
      return null;
    }
  
  public void setInputPortModule(Module m) {
    if (finishPort.isInput()) {
      finishPort.setModule(m);
    } else if (startPort.isInput()) {
      startPort.setModule(m);
    }
  }
  
  public void setOutputPortModule(Module m) {
    if (finishPort.isOutput()) {
      finishPort.setModule(m);
    } else if (startPort.isOutput()) {
      startPort.setModule(m);
    }
  }
  
  /*
   * Move the end of the connection line that touches the specified
   * module.
   */
  public void adjustPointOf(Module m)
    {
      Point bend;
      LineSegment ls;
      
      if (finishPort.getModule()==m) {
		  finish=m.getLineLocation(finishPort.getPort(),
				 finishPort.getType());
		  bend=(Point)bendPoints.lastElement();
		  bend.y=finish.y;

	// If the port is an input, and the bend is to the right of it, that
	// means it looks really funny on the screen, we have to try and
	// fix it.
	
	if ((finishPort.isInput()) && (bend.x>finish.x) && 
	    (start.x<finish.x-1)) {
	  ls=(LineSegment)lineSegmentsByEnd.get(bend);
	  if (ls!=null) ls.setX(finish.x-1);
	} else if ((finishPort.isOutput()) && (bend.x<finish.x) &&
		   (start.x>finish.x+1)) {
	  ls=(LineSegment)lineSegmentsByEnd.get(bend);
	  if (ls!=null) ls.setX(finish.x+1);
	}
	
	// elementAt(bendPoints.size()-2)  <- second to last element
      }

      if(startPort.getModule()==m) {
		  start=m.getLineLocation(startPort.getPort(),
										  startPort.getType());
		  bend=(Point)bendPoints.firstElement();
		  bend.y=start.y;
		  if ((startPort.isInput()) && (bend.x>start.x) &&
				(finish.x<start.x-1)) {
			 ls=(LineSegment)lineSegmentsByStart.get(bend);
			 if (ls!=null) ls.setX(start.x-1);
		  } else if ((startPort.isOutput()) && (bend.x<start.x) && 
						 (finish.x>start.x+1)) {
			 ls=(LineSegment)lineSegmentsByStart.get(bend);
			 if (ls!=null) ls.setX(start.x+1);
		  }
		  
		  
      }
      createLineSegments();
    }
  
  
  public void setDirection(int type)
    {
      direction=type;
    }
  
  /**
    * Add a bend in the line.
    */
  public void addBend(Point p)
    {
      Point lastPoint;
      if (bendPoints.size()>0) {
	//there are other points in the vector, so we make a box
	//around the current point and the last point to make
	//a linesegment
	
	lastPoint = (Point)bendPoints.lastElement();
	//LineSegment ls= new LineSegment(lastPoint,p);
	//lineSegments.put(lastPoint,ls);
	//System.out.println("created a rectangle:"+ls.getRectangle());
      }
      else
	lastPoint = start;
      
      if (direction==HORIZ) {
	p.y=lastPoint.y;
	direction=VERT;
      }
      else {
	p.x=lastPoint.x;
	direction=HORIZ;
      }
      bendPoints.addElement(p);
      //if (direction==HORIZ) direction=VERT; else direction=HORIZ;
      //System.out.println("bend = "+p);
    }
  
  /**
    * Create line segments for the current line.
    */
  public void createLineSegments()
    {
      lineSegmentsByStart.clear();
      lineSegmentsByEnd.clear();
      Enumeration e = bendPoints.elements();
      Point sp=null;
      Point ep;
      LineSegment ls;
      if (e.hasMoreElements()) {
	sp=(Point)e.nextElement();
	while (e.hasMoreElements()) {
	  ep=(Point)e.nextElement();
	  ls = new LineSegment(this,sp,ep);
	  lineSegmentsByStart.put(sp,ls);
	  //System.out.println("start="+sp);
	  
	  lineSegmentsByEnd.put(ep,ls);
	  sp=ep;
	}
      }
    }
  
  /**
    * Set the start point.
    */
  public void setStart(Point p)
    {
      start=p;
    }
  
  /**
    * return ONLY the bend points.
    */
  public Enumeration getBendPoints()
    {
      return  bendPoints.elements();
    }	 
  
  /**
    * Returns the number of bend points in this line.
    *
    * @return the number of bend points in this line.
    */
  public int getNumberOfBendPoints() {
    return bendPoints.size();
  }
  
  /**
    * Returns the linesegment that contains the specified point anywhere in it.
    *
    * @param p The point
    * @return the linesegment containing p
    */
  public LineSegment getSegmentByPoint(Point p) 
    {
      
      Enumeration e = lineSegmentsByStart.elements();
      LineSegment ls;
      while (e.hasMoreElements()) {
	ls = (LineSegment)e.nextElement();
	if (ls.contains(p)) 
	  return ls;
      }
      return null;
      
    }
  
  /**
    * Returns the linesegment that has the end point p.
    *
    * @param p The point
    * @return the linesegment with end point p
    */
  /*
    private LineSegment getSegmentByEndPoint(Point p) 
    {
    LineSegment ls=null;
    ls=(LineSegment)lineSegmentsByStart.get(p);
    if (ls==null) {
    ls = (LineSegment)lineSegmentsByEnd.get(p);
    }
    
    return ls;
    }
  */
  
  
  
  /*
   * Set the finish point.
   */
  public void setFinish(Point p)
    {
      Point beforeLast = (Point)bendPoints.lastElement();
      // The user might not line up the points properly, so we have to
      // compenstate for human error. :-)  we'll move the y coordinate
      // of the last bend point to match the y coordinate of the module
      // port.  that way we'll have nice straight lines.
      beforeLast.y=p.y;
      finish=p;
      
      // Once the line has been finished we can make all the line
      // segments.
      createLineSegments();
    }
  
  //	 public void moveFinish(Point p)
  //{
  
  public void eraseLine(Graphics g)
    {
      if (tempFinish!=null) {
	Color c = lineColor;
	lineColor=Color.lightGray;
	drawLine(g,tempFinish);
	lineColor=c;
      }
    }
  
  public String toString() 
    {
      String b;
      Point s = getStart();
      b = new String(String.valueOf(getNumberOfPoints())+" "+s.x+","+s.y);
      Enumeration e = getBendPoints();
      while (e.hasMoreElements()) {
	s = (Point)e.nextElement();
	b = new String(b+" "+s.x+","+s.y);
      }
      s = getFinish();
      b = new String(b+" "+s.x+","+s.y);
      return b;
    }
  
  public String toString2() {
    return "CL: "+startPort.toString()+" to "+finishPort.toString();
  }
  
  /*
    public void drawLine(Graphics g,Point currentLocation) {
    drawLine(g,currentLocation,1);
    }
  */

  public void drawLine(Graphics g,Point currentLocation)
    {
      int zoomFactor=1;
      
      Enumeration e = bendPoints.elements();
      Point p;
      Point start = this.start;
      g.setColor(lineColor);
      while (e.hasMoreElements()) {
	p = (Point)e.nextElement();
	g.drawLine(start.x*zoomFactor,start.y*zoomFactor,
		   p.x*zoomFactor,p.y*zoomFactor);
	start=p;
      }
      if (finish==null) {
	tempFinish=currentLocation;
	if (direction==HORIZ) currentLocation.y=start.y; else
	  currentLocation.x=start.x;
	
	g.drawLine(start.x*zoomFactor,start.y*zoomFactor,
		   currentLocation.x*zoomFactor,currentLocation.y*zoomFactor);
      } else {
	g.drawLine(start.x*zoomFactor,start.y*zoomFactor,finish.x*zoomFactor,finish.y*zoomFactor);
      }
      
    }
  
  public void drawLineSegment(Graphics g,LineSegment ls)
    {
      g.setColor(Color.blue);
      Point start = ls.getStartPoint();
      Point finish = ls.getFinishPoint();
      g.drawLine(start.x,start.y,finish.x,finish.y);
    }
}
