/*
	Module Class
	By: Yatish Patel
*/

package adaptive.modulemanager;
import java.awt.*;
import java.util.Vector;
import java.util.Enumeration;
import java.awt.event.*;
import adaptive.core.*;
import java.lang.reflect.*;

/**
 * RectangleModule class
 *
 * Draws a rectangular module
 *
 * @author Yatish Patel <yatish@cmu.edu>
 * @version 1.0
 */
public class CircleModule extends adaptive.modulemanager.Module 
{


  
	 public CircleModule(int debugLevel) {
		  super(debugLevel);
		  agentDescription.setNumInputs(1);
		  agentDescription.setNumOutputs(1);
		  
	 }
	 public CircleModule(Agent a,int debugLevel) {
		  super(a,debugLevel);
	 }
 
	 public CircleModule(Module m,int debugLevel ) {
		  super(m,debugLevel); 
	 }

  /* Added by Andrea so that we can make modules from AgentDesctiptions */
	 public CircleModule(AgentDescription ad,int debugLevel) {
		  super(ad,debugLevel); 
	 }

  /*
	 public CircleModule(Class c) {
		  super(c);
	 }

  
	 public CircleModule(Object p,String mID,String name,int i, int o) {
		  super(p,mID,name,i,o);
	 }
  */

	 protected void localInit() {
		  resizeShape = new Rectangle();
		  moveShape = new Rectangle();
		  resizeModule(moduleSize.width,moduleSize.height);
		  //moduleClass=getClass().getName();
		  // Create the resize rectangle, when the users mouse cursor is
		  // over this rectangle the module will be resized if the user
		  // clicks and drags.
		  //resizeShape= new Rectangle(moduleSizeX-(Xinset)-6,moduleSizeY-(Yinset)-6,5,5);

		  // The move shape is the same as the resize, if the user clicks
		  // and drags and he is over the move shape, the module will be
		  // moved.
		  //moveShape=new Rectangle(Xinset+1,Yinset,moduleSizeX-(Xinset*2)-2,moduleSizeY-(Yinset*2)-1);
	 }

	 public Object clone() {
		  CircleModule rt= new CircleModule(this,debugLevel);
		  return rt;
	 }





	 /**
	  * Draw text inside the module.  Will display either the name
	  * of the module, or the module class.  When this method is called
	  * from paint() the offset is 0.  When this method 
	  *
	  * @param g The graphics context of the module
	  * @param offset The offset of the module.
	  * @param highlight whether or not the module is highlighted
	  */
	 protected void drawText(Graphics g, Point offset,boolean highlight) {
		  g.setFont(labelBoxFont);
		  String moduleClass=agentDescription.getType();
		  // If the module is in the toolbar, than display it's class, otherwise
		  // we don't want to see the class name
		  if ((agentDescription.getType()!=null) && (owner instanceof BrowserModel))
		
				// Get the agent name after the first two dots
				// ie: adaptive.agents.PBAgent -> PBAgent
		    //	g.drawString(moduleClass.substring(moduleClass.indexOf(".",moduleClass.indexOf(".")+1)+1),Xinset+3+offset.x,moduleSize.height/2+4+offset.y);
      g.drawString(moduleClass.substring(moduleClass.lastIndexOf(".")+1),Xinset+3+offset.x,moduleSize.height/2+4+offset.y);
		  // If the module has a name display it.
		  if (agentDescription.getName() !=null) 
				g.drawString(agentDescription.getName(),Xinset+4+offset.x,moduleSize.height/2+4+offset.y);		  
	 }



	 /**
	  * Draw the outline and/or other graphics the module requires
	  * to be displayed on the canvas.
	  *
	  * @param g The graphics context of the module
	  * @param offset The offset of the module on the screen
	  * @param highlight whether or not to highlight to module
	  */
	 protected void drawModuleGraphics(Graphics g, Point offset,boolean highlight) 
	 {
		  int x;
		  int lineY;




		  if (highlight) {
				g.setColor(backSelectedColor);
				g.fillOval(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
				g.setColor(selectedColor);
				g.drawOval(Xinset+2+offset.x,Yinset+1+offset.y,moduleSize.width-(Xinset*2)-4,moduleSize.height-(Yinset*2)-3);
		  } else {
				g.setColor(backgroundColor);
				g.fillOval(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
				g.setColor(normalColor);

		  }
		  // draw the rectangle.  this is also used in the mousemoved part
		  // so if you change this, change the part in mousemoved.

			 
		  g.drawOval(Xinset+1+offset.x,Yinset+offset.y,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);

		  for (x=0;x<agentDescription.getNumInputs();x++) {
				drawPortLine(g,offset,IOPort.INPUT,x,false);
		  }
		  for (x=0;x<agentDescription.getNumOutputs();x++) {
				drawPortLine(g,offset,IOPort.OUTPUT,x,false);
		  }	  

		  g.setColor(normalColor);		  
	 }
	 /**
	  *	Get the location of where we should draw the line to connect the
	  *	specified input port.  
	  *
	  *	@return a Point in the parents coordinate system.
	  */
	 protected Point getInputLineLocation(int inputNumber)
	 {
		  Point p = getLocation();		
		  return (new Point(p.x,(inputNumber+1)*inputLineSpacing+p.y));		 
		  
	 }

	 /**
	  *	Get the location of where we should draw the line to conenct the
	  *	specified output port.
	  *
	  *	@return a Point in the parent's coordinate system.
	  */
	 protected Point getOutputLineLocation(int outputNumber)
	 {
		  //System.out.println("correct");
		  Point p = getLocation();
		  return (new Point(p.x+moduleSize.width,p.y+(outputNumber+1)*outputLineSpacing));
	 }

	 /**
	  * Draw a port line.
	  *
	  * @param g The graphics context for this module.
	  * @param o The offset of the module
	  * @param type The type of port input/output
	  * @param port The port number
	  * @param highlight Is the line highlighted
	  */
    protected void drawPortLine(Graphics g, Point o,int type, int port,boolean highlight)
    {
	// x^2/+y^2 = r^2     
	int mouthWidth=minInputLineSpacing-2;
	Point p = new Point();
	Point temp;
	Point l=getLocation();
	// 	  g.drawOval(Xinset+1+offset.x,
	//               Yinset+offset.y,
	//               moduleSize.width-(Xinset*2)-2,
	//               moduleSize.height-(Yinset*2)-1);
	int a=(moduleSize.width-(Xinset*2)-2)/2;
	int b=(-1)*(moduleSize.height-(Yinset*2)-1)/2;
	int x1=moduleSize.width/2;
	int y1=(-1)*moduleSize.height/2;
	int y;
	
	if (type==IOPort.INPUT) {
	    p= getInputLineLocation(port);
	    p.x=p.x-l.x;
	    p.y=p.y-l.y;
	    //l.x=(int)Math.sqrt(xRadius^2-(xRadius^2/yRadius^2)*(p.y+yRadius)^2)+xRadius;
	    l.y=p.y;
	    y=(-1)*p.y;
				//System.out.println("x1="+x1+", y1="+y1+", a="+a+", b="+b+", y="+y);
	    double t=(Math.sqrt(2*(a*a)*y*y1-(a*a)*(y1*y1)-(a*a)*(y*y)+(a*a)*(b*b)));
	    double t1=x1*b;
	    double t2=1/b;
				//System.out.println("t="+t+" t1="+t1+" t2="+t2);
	    l.x=(int)((t1 + t)/b);
				//System.out.println("l.x="+l.x+" l.y="+l.y);
				//System.out.println("-------------");
				//l.x=xRadius;
	    
				//g.drawLine(p.x-l.x,  p.y-l.y,   p.x+Xinset-l.x,  p.y-l.y);
            
	} else if (type==IOPort.OUTPUT) {
	    p= getOutputLineLocation(port);			
	    p.x=p.x-l.x;
	    p.y=p.y-l.y;
	    y=(-1)*p.y;
	    double t=(Math.sqrt(2*(a*a)*y*y1-(a*a)*(y1*y1)-(a*a)*(y*y)+(a*a)*(b*b)));
	    double t1=x1*b;
	    double t2=1/b;
	    
	    l.x=(int)((t1 - t)/b);
	    l.y=p.y;
				//g.drawLine(p.x-l.x,p.y-l.y,p.x-Xinset-l.x,p.y-l.y);
	    temp=l;
	    l=p;
	    p=temp;
	}
	
	/*
	  g.drawLine(p.x+o.x,p.y+o.y,l.x+o.x,p.y+o.y); 
	  //g.drawLine(p.x+o.x,p.y+o.y-5,l.x+o.x,p.y+o.y);
	  if (highlight) { 
	  g.drawLine(p.x+o.x,p.y-1+o.y,l.x+o.x,p.y-1+o.y);
	  g.drawLine(p.x+o.x,p.y+1+o.y,l.x+o.x,p.y+1+o.y);
	  }*/
	//draw port
	g.drawLine(o.x+p.x,o.y+p.y+mouthWidth,o.x+l.x,o.y+l.y);
	g.drawLine(o.x+p.x,o.y+p.y-mouthWidth,o.x+l.x,o.y+l.y);
	
	if (highlight){
	    g.drawLine(o.x+p.x,o.y+p.y+mouthWidth-1,o.x+l.x,o.y+l.y);
	    g.drawLine(o.x+p.x,o.y+p.y-mouthWidth+1,o.x+l.x,o.y+l.y);
	    g.drawLine(o.x+p.x,o.y+p.y+mouthWidth-2,o.x+l.x,o.y+l.y);
	    g.drawLine(o.x+p.x,o.y+p.y-mouthWidth+2,o.x+l.x,o.y+l.y);
	}		
    }	  
    

	 /**
	  * Resize the module to the spcified size.
	  *
	  * @param x X coordinate of the point to check.
	  * @param y Y coordinate of the point to check. 
	  */
	 public void  resizeModule(int x, int y) {

		x=x;
		y=y;
		
		  moduleSize.width=x;
		  moduleSize.height=y;
		  setSize(moduleSize.width,moduleSize.height);
		  ((Rectangle)resizeShape).setBounds(moduleSize.width-(Xinset)-6,moduleSize.height-(Yinset)-6,5,5);
		  ((Rectangle)moveShape).setBounds(Xinset+1,Yinset,moduleSize.width-(Xinset*2)-2,moduleSize.height-(Yinset*2)-1);
		  
		  
		  // now we need to determine a good linespacing for the port lines
		  
		  // First try and place each line with the default line spacing
		  int lastLineLoc=(agentDescription.getNumInputs()+1)*minInputLineSpacing;
		  if (lastLineLoc<=moduleSize.height-2) {
				// There is enough space so we should try and center
				// the lines
				if (agentDescription.getNumInputs()>0)
				inputLineSpacing=moduleSize.height/(agentDescription.getNumInputs()+1);
		  } else 
				inputLineSpacing=minInputLineSpacing;

		  lastLineLoc=(agentDescription.getNumOutputs()+1)*minOutputLineSpacing;
		  if (lastLineLoc<=moduleSize.height-2) {
				if (agentDescription.getNumOutputs()>0)
				outputLineSpacing=moduleSize.height/(agentDescription.getNumOutputs()+1);
		  } else
				outputLineSpacing=minOutputLineSpacing;

		  if (!initialized) return;
		  addLineRectangles();
		  adjustConnectLines();
		  if (owner instanceof ModuleManager) 
				((ModuleManager)owner).repaint();
		  //System.out.println("in="+inputLineSpacing+" out="+outputLineSpacing);
	 }






}
