package adaptive.modulemanager;

import java.awt.*;
import java.awt.event.*;

public class CanvasSizeDialog extends Dialog implements ActionListener {

  private Font font;
  private Button btnOk;
  private Button btnCancel;
  private Dimension size;
  private TextField txtX,txtY;
  
  public CanvasSizeDialog(Frame f,String s,boolean m,Dimension d) {
	 super(f,s,m);
	 size=d;
	 
	 font = new Font("SansSerif",Font.PLAIN,12);	 
	 setLayout(null);
	 setSize(120,150);
	 setTitle("Canvas Size");
	 
	 Label l = new Label("X=");
	 l.setBounds(7,30,20,30);
	 l.setFont(font);
	 add(l);
	 
	 txtX = new TextField();
	 txtX.setBounds(30,30,40,30);
	 txtX.setFont(font);
	 txtX.setText(String.valueOf(d.width));
	 add(txtX);
	
	 l = new Label("Y=");
	 l.setBounds(7,60,20,30);
	 l.setFont(font);
	 add(l);
	 
	 txtY = new TextField();
	 txtY.setBounds(30,60,40,30);
	 txtY.setFont(font);
	 txtY.setText(String.valueOf(d.height));
	 add(txtY);
	 

	 btnOk = new Button("Ok");
	 btnOk.setFont(font);
	 btnOk.setBounds(7,100,50,30);
	 add(btnOk);
	 
	 btnCancel = new Button("Cancel");
	 btnCancel.setFont(font);
	 btnCancel.setBounds(60,100,50,30);
	 add(btnCancel);
	
	 btnOk.addActionListener(this);	 
	 btnCancel.addActionListener(this);
	 
  }
  
  public void actionPerformed(ActionEvent event) {
	 if (event.getSource()==btnOk) {
		size.setSize(Integer.parseInt(txtX.getText()),Integer.parseInt(txtY.getText()));
		dispose();
	 } else if(event.getSource()==btnCancel) {
		dispose();
	 }
	 
	 
  }
  
  
}
