/**
 * Browser.  This will allow the user to browse the directories/network
 * to find the available agents.  The browser keeps track of what agents
 * have been loaded, and will tell the moduleToolbar what to display.
 *
 * @author Yatish Patel
 * @version 1.0
 * $Log: Browser.java,v $
 * Revision 1.9.2.6  2000/05/09 19:12:43  jrj
 * added check whether the SystemConfiguration is valid before we try to
 * execute.  Changed ModuleManager to use ConfigurationExecutor to launch
 * configurations.
 *
 * Revision 1.9.2.5  2000/03/07 02:23:34  jrj
 * made it so that selecting an agent in the Browser caused its class
 * type to appear in the status window
 *
 */

package adaptive.modulemanager;

import java.awt.*;
import adaptive.core.*;
import java.util.*;
import java.awt.event.*;

public class Browser extends Frame implements ActionListener,Observer {

  private Component currentComponent;
  private Button btnRefresh;
  private Button btnNewBrowser;
  private Button btnClose;

  /** The panel that contains the folders */
  private Panel browserWindow;

  /** A refrence to the moduleToolbar. */
  // private ModuleToolbar moduleToolbar;
  
  /** Parent of this frame */
  private ModuleManager moduleManager;

  private adaptive.modulemanager.Module selectedModule;
  
  /** Current location of the browser */
  private String currentLocation;
  
  private ScrollPane scrollPane;
  private Font font;

  private BrowserModel browserModel;

  /** Is the directory we're displaying over the network */
  private boolean isLocal=true;
  private int debugLevel=0;
  
	 public Browser(BrowserModel bm,int debugLevel) {
		//setSize(550,150);
		browserModel=bm;
		this.debugLevel=debugLevel;
		font = new Font("SansSerif",Font.PLAIN,12);
		  setLayout(new BorderLayout());
		  setTitle("Module Browser");
		  Panel buttons = new Panel();
		  buttons.setLayout(new FlowLayout());
		  btnRefresh = new Button("Refresh");
		  btnRefresh.setEnabled(true);
		  btnRefresh.setFont(font);
		  btnRefresh.addActionListener(this);

		  btnNewBrowser= new Button("New Browser");
		  btnNewBrowser.setFont(font);
		  btnNewBrowser.addActionListener(this);

		  btnClose=new Button("Close");
		  btnClose.setFont(font);
		  btnClose.addActionListener(this);
		  
		  buttons.add(btnRefresh);
		  buttons.add(btnNewBrowser);
		  buttons.add(btnClose);
		  
		  add(buttons,"North");


		  browserWindow = new Panel();
		  browserWindow.setLayout(new ModuleLayout(ModuleLayout.HORIZONTAL));
		  //browserWindow.setLayout(null);
		  
		  //add(browserWindow,"Center");
		  //browserWindow.setSize(400,150);
		  //browserWindow.pack();		  
		  scrollPane = new ScrollPane();
		  //scrollPane.setSize(400,150);
		  scrollPane.add(browserWindow);		  
		  scrollPane.doLayout();
		  
		  add(scrollPane,"Center");
		  //pack();
		  setSize(550,150);

		  
		  ComponentListener componentListener=new ComponentListener();
		  KeyListener keyListener = new KeyListener();
		  MouseMotionListener mouseMotionListener = new MouseMotionListener();
		  addKeyListener(keyListener);
		  browserWindow.addMouseMotionListener(mouseMotionListener);
		  browserWindow.addKeyListener(keyListener);
		  browserWindow.addMouseListener(new MouseListener());
		  addWindowListener(new WindowListener());
		  
		  buttons.addKeyListener(keyListener);
		  scrollPane.addKeyListener(keyListener);
		  addComponentListener(componentListener);
	 }

	 public Browser(BrowserModel bm,ModuleManager p,Font f,int debugLevel) {
		  this(bm,debugLevel);
		  moduleManager=p;
		  //moduleToolbar=mt;
		  font=f;
	 }

	 public Browser(BrowserModel bm,ModuleManager p,Font f,String directory,
						 int debugLevel) {
		  this(bm,debugLevel);
		  moduleManager=p;
		  //moduleToolbar=mt;
		  font=f;
		  currentLocation="";
		  //System.out.println("const:"+directory);
		  changeLocation(directory);
	 }

  public void update(Observable ob,Object o) {
	 if (o!=null) {
		if (o instanceof String) {
		  String s = (String)o;
		  if (s.equals("setVisible(false)")) {
			 setVisible(false);
		  } else if(s.equals("setVisible(true)")) {
			 setVisible(true);
		  }
		}
	 } else 
		changeLocation(".");
  }

	 public void addModule(Module a)
	 {
		  browserWindow.add(a);
	 }


	 /**
	  * Clears all the modules from the toolbar
	  */
	 public void clear() {
		  browserWindow.removeAll();
		  browserWindow.repaint();
	 }





	 /**
	  * Add folders to the broswer.
	  *
	  * @param folders An array containing a list of all the folders to add
	  */
	 public void addFolders(String[] folders) {
		  Folder f;
		  //System.out.println("Adding folders: "+folders.length);
		  if (folders!=null) {
			 for (int x=0;x<folders.length;x++) {
				f= new Folder(folders[x],this,font);
				browserWindow.add(f);
			 }
		  }
		  
		  //pack();
		  scrollPane.doLayout();	
		  pack();
		  
	 }

  /**
	* Set the current AgentLoader.
	*
	* @param al The agentLoader to set to.
	*/
  public void setAgentLoader(AgentLoader al,String lpr,String npr,boolean un) {
	 browserModel.setAgentLoader(al,lpr,npr,un);
  }
  
	 /**
	  * Display all the folders available in the specified directory.
	  * If the directory is the same as the packageRoot and the
	  * network stuff has been enabled, display a folder for the
	  * for the network also.
	  *
	  * @param directory The directory name.
	  */
	 public void displayFoldersInDirectory(String directory) {


		  browserWindow.removeAll();
		  browserWindow.repaint();

		  // When the directory is null, that means we give the user an
		  // option to choose from either local agents, or remote agents
		  if (directory==null) {
			 Folder g = new Folder("Local",this,font);
			 browserWindow.add(g);
			 if (browserModel.isUsingNetwork()) {
                           g= new Folder("Network",this,font);
                           browserWindow.add(g);
			 }
			 scrollPane.doLayout();
			 pack();
		  } else {
                         if (directory.equals("Local"))  {
				directory=browserModel.getLocalPackageRoot();
				isLocal=true;
			 }
			 if (directory.equals("Network")) {
				directory=browserModel.getNetworkPackageRoot();
				isLocal=false;
			 } 
			 Folder f = new Folder("..",this,font);
			 browserWindow.add(f);
			 try {
				//System.out.println("going to add folders");
				addFolders(browserModel.listDirectoriesIn(directory,isLocal));
				currentLocation=directory;
			 } catch (Exception e) {
				System.err.println("displayFoldersInDirectory: "+e);
				e.printStackTrace();
				
			 }
		  }
		  
	 }

	 /**
	  * Query the specified directory for agents, and add them to the
	  * moduleToolbar.  The browser will
	  * pass the directory name to the agentloader, which will
	  * (supposedly) return a string array of all the agents in the
	  * directory.
	  *
	  * @param directory The directory name.
	  */
	 public void displayAgentsInDirectory(String directory) {

		if (directory==null) return;
		  // Special 240 mode, I put this in for myself,
		  // I can use the modmanager to make schematics
		  // for 240.  Loads special module shapes, and/or
		  // not, multiplexer, etc..
		/*
		  if (directory.equals("240")) {

				Module t = new TriangleModule();
				t.setParent(moduleToolbar);
				availableModules.put(t.getClass().getName(),t);
				moduleToolbar.addModule(t);	


				t=new AndModule();
				t.setParent(moduleToolbar);
				availableModules.put(t.getClass().getName(),t);
				moduleToolbar.addModule(t);

				t = new RectangleModule();
				t.setParent(moduleToolbar);
				availableModules.put(t.getClass().getName(),t);
				moduleToolbar.addModule(t);


				moduleToolbar.pack();
				return;
		  }
		*/
		
		Enumeration e= browserModel.getAgentsIn(directory,isLocal).elements();
		Module m;
		while (e.hasMoreElements()) {
		  m =(Module)e.nextElement();
		  addModule(m);
		}

		e = browserModel.getMacrosIn(directory,isLocal).elements();
		while (e.hasMoreElements()) {
		  m =(Module)e.nextElement();
		  addModule(m);
		} 
		pack();

 	 }



	 /**
	  * Get a module with the given class
	  *
	  */
	 public adaptive.modulemanager.Module getModule(String s,int location) {
		//System.out.println("getModule: s="+s);
		//location=AgentDescription.LOCAL_FILE;
		return browserModel.getModule(s,location);
	 }
  
  public Graphics getPanelGraphics() {
	 return browserWindow.getGraphics();
  }
  
	 /**
	  * Changes into the specified location
	  *
	  * @param loc Location to change into
	  */
	 public void changeLocation(String loc) {
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		if (loc!=null) {
		  if (loc.equals("..")) {
			 if (currentLocation.equals
				  (browserModel.getLocalPackageRoot())) {
				currentLocation=null;
			 } else if(currentLocation.equals
						  (browserModel.getNetworkPackageRoot())) {
				currentLocation=null;
			 } else {
				int slash=currentLocation.lastIndexOf("/",
																  currentLocation.length()-2);
				currentLocation=currentLocation.substring(0,slash+1);
			 }
		  } else if (loc.equals("Local")) {
			 currentLocation="Local";
		  } else if (loc.equals("Network")) {
			 currentLocation="Network";
		  } else if (!loc.equals(".")) {
			 currentLocation=new String(currentLocation+loc+"/");
		  }
		} else currentLocation=null;
		
		//System.out.println("changeLoc="+currentLocation);
		displayFoldersInDirectory(currentLocation);
		displayAgentsInDirectory(currentLocation);
		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	 } 

	 public void resizeScrollPane (Dimension d) {
		  //System.out.println(d);
		  // panelX=d.width-15;
		//scrollPane.setSize(d.width-15,d.height-40);
		//d = getSize();
		
		//	System.out.println("-!-!-!-!");
		
		  browserWindow.setSize(d.width-15,d.height-40);
		  //  System.out.println("new size="+d);
		  
		//pack();	  		
		scrollPane.doLayout();
		pack();
		//	System.out.println("-----------");
		
		
	 }
  /**
	 * Tells the browser if there was mouse movement
	 *
	 * @param evt The MouseEvent for this event
	 */
  public void mouseMovement(MouseEvent evt) {
	 // System.out.println(child+" movement");
	 /*
	 int x = evt.getX();
	 int y = evt.getY();
	 Component c = evt.getComponent();
	 
	 if(c==browserWindow) 
		c = browserWindow.getComponentAt(x,y);

	 if (currentComponent!=c) {
		//		browserWindow.setBigComponent(c);
		currentComponent=c;
		browserWindow.repaint();
	 }
	 */
	 
  }
  

  public void actionPerformed(ActionEvent ae) {
	 Object source=ae.getSource();
	 if (source==btnRefresh) {
		// This will simply reload the current directory
		changeLocation(".");
	 } else if (source==btnNewBrowser) {
		String loc=currentLocation;
		if (loc!=null)
		  loc=loc.substring(0,loc.length()-1);
		//System.out.println("new b:"+loc);
		
		Browser b=new Browser(browserModel,moduleManager,font,loc,debugLevel);
		browserModel.addObserver(b);
		b.show();
	 } else if (source==btnClose) {
		dispose();
	 }
	 
	 
	 
  }
  
  class KeyListener extends KeyAdapter
  {
	 /*
	  * Triggered whenever a key is pressed 
	  */
	 public void keyPressed(KeyEvent evt)
	 {
		//System.out.println("browser key");
		
		moduleManager.dispatchEvent(evt);
		
	 }
  }


	class ComponentListener extends java.awt.event.ComponentAdapter
	{
		 public void componentResized(java.awt.event.ComponentEvent evt)
		 {
			  Component c = evt.getComponent();
			  resizeScrollPane(c.getSize());		  
		 }
	}

  class MouseMotionListener extends MouseMotionAdapter {
	 public void mouseMoved(java.awt.event.MouseEvent evt) {
		mouseMovement(evt);
	 }
	 
  }
  
  class MouseListener extends MouseAdapter {
	 public void mouseClicked(java.awt.event.MouseEvent evt) {
		Panel p =(Panel)evt.getComponent();
		Component c=p.getComponentAt(evt.getX(),evt.getY());
		if (c instanceof Module) {
		  //System.out.println("browser: "+c);
		  browserModel.selectAgent((Module)c);
		  moduleManager.setCurrentTool(moduleManager.PLACE);

		  moduleManager.getStatusWindow().setStatusInfo((Module)c);//added jrj 3/6/00
		}
	 }
  }

  class WindowListener extends java.awt.event.WindowAdapter
  {
	 public void windowClosing(java.awt.event.WindowEvent event) {
		dispose();
	 }
	 public void windowActivated(java.awt.event.WindowEvent event) {
		//moduleManager.setBrowser((Browser)event.getComponent());
		//browserModel.setSelectedModule(selectedModule);
		
	 }
	 
  }
}

class BrowserPanel extends Panel {
  Component currentComponent;


  
  /*public void repaint() {
	 System.out.println("repaint");
  }*/
  /*
  public void paint(Graphics g) {
   Component c[] = getComponents(); 
	int x = getComponentCount();
	// g.setColor(Color.yellow);
	// g.fillRect(5,15,90,60);
	for (int y=0;y<x;y++) {
	  ((Folder)c[y]).drawFolder(g);
	  // System.out.println("painting "+c);
	  //System.out.println("clipbounds="+g.getClipBounds());
	  
	}
	
	
	if (currentComponent==null) return;
	
	if (currentComponent instanceof Folder) {
	  Point p = currentComponent.getLocation();
	  ((Folder)currentComponent).drawText(g,p.x,p.y);
	  //System.out.println("drawing text");
	  
	} else if (currentComponent instanceof Module) {
  }
  }
*/


  public void setBigComponent(Component c) {
	 currentComponent=c;
  }
  
}

