package adaptive.modulemanager;
import java.awt.*;
import java.awt.event.*;


/*****************************************************************************
 *
 * Copyright 2000, Institute for Complex Engineered Systems,
 *                 Carnegie Mellon University
 * PROJECT: Self-adaptive Software
 * DESCRIPTION: base class to simplify creating a specialized state editor
 *
 * @author Jonathan R Jackson <A HREF="mailto:jackson4@andrew.cmu.edu">jackson4@andrew.cmu.edu>/A>
 *
 * REVISION HISTORY:
 *
 * $Log: BaseStateEditor.java,v $
 * Revision 1.1.2.1  2000/04/28 04:14:35  jrj
 * rewrote part of the state editing stuff so that it works like it
 * should and so that agents actually can provide their own state editor
 *
 *
 * 
 ****************************************************************************/
public abstract class BaseStateEditor extends Dialog implements StateEditor, ActionListener {

    protected Panel base;
    private Panel buttonPanel;
    private adaptive.modulemanager.Module editMod;
    protected Object state;
  /**
    * Default constructor.  does nothing
    */
    public BaseStateEditor(Frame parent) {
	this(parent,true);
    }
    public BaseStateEditor(Frame parent,boolean modal){
	super(parent,modal);
    }

  /**
    * editState()
    * gets mod's state and then displays a window with the data
    *
    * @param mod The module whose state will be edited
    */
    public final void editState( adaptive.modulemanager.Module mod ) {

	editMod = mod;
	setTitle( "Edit State: " + editMod.getName() );
	
	state = editMod.getInternalParameters();

	if( state == null ) {
	    state = editMod.getAgent().getDefaultState();
	    if( state == null ) {
		return;
	    }
	}

	setupGUI();
	show();
    }
    protected final void setupGUI(){
	setLayout(new GridLayout(2,1));
	base=setupPanel();

	add(base);
	buttonPanel=new Panel();
	add(buttonPanel);
	
	buttonPanel.setLayout(new GridBagLayout());
	GridBagConstraints gbc=new GridBagConstraints();
	Button okB = new Button( "OK" );
	Button canB = new Button( "Cancel" );
	Button clearB = new Button("Clear");
	okB.addActionListener( this );
	canB.addActionListener( this );
	clearB.addActionListener(this);
	gbc.fill=GridBagConstraints.NONE;
	gbc.anchor=GridBagConstraints.CENTER;
	setConstraints(gbc,0,0,1,1,10,10);
	buttonPanel.add(okB,gbc);
	setConstraints(gbc,1,0,1,1,10,10);
	buttonPanel.add(canB,gbc);
	setConstraints(gbc,2,0,1,1,10,10);
	buttonPanel.add(clearB,gbc);
	
	pack();
	addWindowListener( new
			   WindowAdapter() {
	    public void windowClosing( WindowEvent e ) {
		dispose();
	    }
	}
			   );
    }

  /** handles events.  only handles button clicks
    * @param e The event that just occurred
    */
    public void actionPerformed( ActionEvent e ) {
	String s = e.getActionCommand();
	Object newState;
	if( s.equals( "OK" )  ) {
	    newState=commitState();
	    editMod.setInternalParameters(newState);
	    dispose();
	}
	else if( s.equals( "Cancel" ) ) {
	    dispose(); 
	}
	else if (s.equals("Clear")){
	    state=null;
	    editMod.setInternalParameters(null);
	    dispose();
	}
	else {
	    System.err.println( "BaseStateEditorGUI: button not found" );
	}
    }
    /*********
    setConstraints
    utility method to better organize using a GridBagLayout
    **********/
    protected void setConstraints(GridBagConstraints gbc, int gx, int gy, 
				int gw, int gh, int wx, int wy){
	gbc.gridx=gx;
	gbc.gridy=gy;
	gbc.gridwidth=gw;
	gbc.gridheight=gh;
	gbc.weightx=wx;
	gbc.weighty=wy;
    }
    /*****************
    commitState
    place new state into the returned Object, using whatever format is proper for this state
    ******************/
    protected abstract Object commitState();
    /**************
    setupPanel
    return a panel that contains the elements for viewing/editing the state
    The state has been read in before this function is called
    **************/
    protected abstract Panel setupPanel();

}



