package adaptive.modulemanager;
import adaptive.core.*;
import java.awt.*;
import java.util.Vector;
/**
  * A adaptive.modulemanager.Module thats shaped like a triangle.
  *
  * @author Yatish Patel
  * @version 1.0
  */
public class AndModule extends adaptive.modulemanager.Module {

	 int[] xPoints; 
	 int[] yPoints;
	 int[] xPointsH;
	 int[] yPointsH; 

	 public AndModule(int debugLevel) {
		  super(debugLevel);
		  //agentClass=getClass();
	 }
	 
	 public AndModule(Agent a,int debugLevel) {		  
		  super(a,debugLevel);
	 }

  public AndModule(boolean b,int debugLevel) {
	 super(b,debugLevel);
  }
  
  /*	 
	 public AndModule(Class c) {
		  super(c);
	 }

	 public AndModule(Frame p,String mID,String name,int i, int o) {
		  super(p,mID,name,i,o);
	 }
  */

	 protected void localInit() {

		  xPoints = new int[3];
		  yPoints = new int[3];
		  xPointsH = new int[3];
		  yPointsH = new int[3];

		  agentDescription.setNumInputs(1);
		  agentDescription.setNumOutputs(1);
		  agentDescription.setType(getClass().getName());		 
		  resizeModule(50,50);
		  moveShape = new Polygon(xPoints,yPoints,3);
		  resizeShape = new Rectangle(getLocation().x+moduleSize.width-5,getLocation().y+moduleSize.height-5,5,5);
	 }
	 
	 public void resizeModule(int x,int y) {
		  moduleSize.width=x;
		  moduleSize.height=y;
		  setSize(moduleSize.width,moduleSize.height);
		  xPoints[0]=Xinset;
		  xPoints[1]=moduleSize.width-Xinset;
		  xPoints[2]=Xinset;
		  
		  yPoints[0]=Yinset;
		  yPoints[1]=moduleSize.height/2;
		  yPoints[2]=moduleSize.height-(2*Yinset);
		  
		  xPointsH[0]=xPoints[0]+1;
		  xPointsH[1]=xPoints[1]-1;
		  xPointsH[2]=xPoints[2]+1;
		  
		  yPointsH[0]=yPoints[0]-1;
		  yPointsH[1]=yPoints[1];
		  yPointsH[2]=yPoints[2]-1;	

		  moveShape = new Polygon(xPoints,yPoints,3);
		  resizeShape = new Rectangle(getLocation().x+moduleSize.width-5,getLocation().y+moduleSize.height-5,5,5);
		  

	 }
	 /**
	  * Is the point specified within the resize region.
	  *
	  * @param x X coordinate of the point to check.
	  * @param y Y coordinate of the point to check.
	  * @return true if the point is within the resize region otherwise false.
	  */
	 protected boolean insideResizeRegion(int x, int y) {
		  if (resizeShape!=null) {
				return ((Rectangle)resizeShape).contains(x,y);
		  }
		  else
				return false;
	 }

	 /**
	  * Is the point specified within the move region.
	  *
	  * @param x X coordinate of the point to check.
	  * @param y Y coordinate of the point to check.
	  * @return true if the point if within the move region otherwise false.
	  */
	 protected boolean insideMoveRegion(int x, int y) {
		  if (moveShape!=null) {
				return ((Polygon)moveShape).contains(x,y);
		  }
		  else
				return false;
	 }  


  /**
	 * Draws the module on the screen.  This is needed so we can print
	 * the whole screen. It will get called by ModuleManager with the
	 * location of the module, so we know where to draw it.  
	 *
	 * By default the module doesn't have a location since it's canvas
	 * is controlled by java and it's an object in my panel.
	 */
  
  public void drawModuleGraphics(Graphics g, Point offset,boolean highlight) 
	 {
		int x;
		int lineY;
		if (highlight) {
			 g.setColor(backSelectedColor);
			 g.fillArc(Xinset+1+offset.x-(moduleSize.width-(Xinset*2)-2),Yinset+offset.y,(moduleSize.width-(Xinset*2)-2)*2,moduleSize.height-(Yinset*2)-1,-90,180);
			 g.setColor(selectedColor);
			 //g.drawPolygon(xPointsH,yPointsH,3);
		} else {
			 g.setColor(backgroundColor);
			 g.fillArc(Xinset+1+offset.x-(moduleSize.width-(Xinset*2)-2),Yinset+offset.y,(moduleSize.width-(Xinset*2)-2)*2,moduleSize.height-(Yinset*2)-1,-90,180);
			 g.setColor(normalColor);
		}

		// draw the rectangle.  this is also used in the mousemoved part
		// so if you change this, change the part in mousemoved.

		//g.drawPolygon(xPoints,yPoints,3);
		
		g.drawLine(Xinset+1+offset.x,Yinset+offset.y,Xinset+1+offset.x,moduleSize.height-(Yinset*2)-1);

		// rectangle center Xinset+1+offset.x
		// rectangle width (moduleSizeX-(Xinset*2)-2)*2
		g.drawArc(Xinset+1+offset.x-(moduleSize.width-(Xinset*2)-2),Yinset+offset.y,(moduleSize.width-(Xinset*2)-2)*2,moduleSize.height-(Yinset*2)-1,-90,180);

		g.setFont(labelBoxFont);


		// If the module is in the toolbar, than display it's class, otherwise
		// we don't want to see the class name
		String moduleClass=agentDescription.getType();
		if ((moduleClass !=null) && (owner instanceof BrowserModel))
			 g.drawString(moduleClass.substring(moduleClass.lastIndexOf(".")+1),Xinset+3+offset.x,moduleSize.height/2+offset.y);

		if (agentDescription.getName() !=null) 
		  g.drawString(agentDescription.getName(),offset.x+Xinset+4,offset.y+moduleSize.height/2);

		for (x=0;x<agentDescription.getNumInputs();x++) {
			 drawPortLine(g,offset,IOPort.INPUT,x,false);
		}
		for (x=0;x<agentDescription.getNumOutputs();x++) {
			 drawPortLine(g,offset,IOPort.OUTPUT,x,false);
		}
		g.setColor(normalColor);		  
	 }
  
  /**
	 *	Get the location of where we should draw the line to connect the
	 *	specified input port.  
	 *
	 *	@return a Point in the parents coordinate system.
	 */
  public Point getInputLineLocation(int inputNumber) {
		Point p = getLocation();
		//return (new Point(p.x,(inputNumber+1)*lineSpacing+p.y));
		return (new Point(p.x,p.y+moduleSize.height/2));
	 }

  /**
	 *	Get the location of where we should draw the line to conenct the
	 *	specified output port.
	 *
	 *	@return a Point in the parent's coordinate system.
	*/
  public Point getOutputLineLocation(int outputNumber) {
		Point p = getLocation();
		//return (new Point(p.x+moduleSizeX,p.y+(outputNumber+1)*lineSpacing));
		return (new Point(p.x+moduleSize.width,p.y+moduleSize.height/2));
	}

}
