package adaptive.core.util;

/*****************************************************************************
 * <! Copyright 1999, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: LinkedList.java 
 * >
 *
 * Utility linked list that does NOT do synchronization.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 11/10/1999<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: LinkedList.java,v $
 * Revision 1.1.2.3  2000/02/17 01:17:57  telamon
 * initial demo 2/16 checkin
 *
 * >
 ****************************************************************************/
public class LinkedList {

  private class ListNode {
    Object value;
    ListNode next;
    
    ListNode( Object value, ListNode next ) {
      this.value = value;
      this.next = next;
    }
    
    Object getValue() {
      return value;
    }
    
    ListNode getNext() {
      return next;
    }
    
    void setNext( ListNode next ) {
      this.next = next;
    }
  }
  
  private ListNode first = null;
  private ListNode last = null;
  private int size = 0;
  
  public void addLast( Object o ) {
    if( first == null ) {
      first = last = new ListNode( o, null );
      size = 1;
    } else {
      last.setNext( new ListNode( o, null ) );
      last = last.getNext();
      size++;
    }
  }
  
  public Object getFirst() {
    if( first == null ) {
//      size = 0;
      return null;
    } else {
      Object retVal = first.getValue();
      first = first.getNext();
      size--;
      return retVal;
    }
  }
  
  public int size() {
    return size;
  }
}
