package adaptive.core.util;

/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: BooleanFlag.java 
 * >
 *
 * A synchronized boolean flag used for threaded programming. Used
 * primarily in the servers to signal that an interrupted thread
 * should shutdown cleanly.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 2/2/2000<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: BooleanFlag.java,v $
 * Revision 1.1.2.2  2000/04/28 04:23:15  jrj
 * made it Serializable so it can be shipped across a network connection
 *
 * Revision 1.1.2.1  2000/02/07 15:30:25  telamon
 * Agent.class screwiness CVS
 *
 * >
 ****************************************************************************/
public class BooleanFlag implements java.io.Serializable{
  private boolean val;

  public BooleanFlag() {
    val = false;
  }

  public BooleanFlag(boolean val) {
    this.val = val;
  }

  public synchronized void setVal(boolean val) {
    this.val = val;
  }

  public synchronized boolean getVal() {
    return this.val;
  }
}
