package adaptive.core.net;

import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.io.ObjectStreamClass;
import java.io.InputStream;
import java.io.IOException;


/*****************************************************************************
 * <! Copyright 2000, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: RemoteClassObjectInputStream.java 
 * >
 *
 * An ObjectInputStream that resolves classes using the NetAgentLoader.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 xx/xx/2000<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: RemoteClassObjectInputStream.java,v $
 * Revision 1.1.2.1  2000/03/02 06:53:27  telamon
 * fixed namespace problem in loading system configurations
 *
 * >
 ****************************************************************************/
public class RemoteClassObjectInputStream extends ObjectInputStream {

  private ClassLoader cl;

  public RemoteClassObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
    super(in);
  }
  
  public void setClassLoader(ClassLoader cl) {
    this.cl = cl;
  }

  protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
    Class retVal = null;
    if(cl != null) {
      try {  
        retVal = cl.loadClass(v.getName());
      }
      catch(ClassNotFoundException cnfe) {
        cnfe.printStackTrace();
      }
    }

    if (retVal == null) {
      retVal = super.resolveClass(v);
    }
    return retVal;
  }
} 
