package adaptive.core.net;

import java.util.StringTokenizer;
import java.util.NoSuchElementException;


/*****************************************************************************
 * <! Copyright 1999, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: PhoneEntry.java 
 * >
 *
 * These correspond to Rave phone entries, but we ignore the normal RAVE
 * port and use the port number in the optional data field.
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.00 xx/xx/99<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: PhoneEntry.java,v $
 * Revision 1.1.2.2  2000/05/22 23:45:11  telamon
 * synched with the change comms classes
 *
 * Revision 1.1.2.1  1999/10/06 01:11:32  telamon
 * Initial checking of new comms stuff
 *
 * >
 ****************************************************************************/

public class PhoneEntry {
  private String name;
  private String host;
  private int port;

  public PhoneEntry(String phoneStringEx) throws IllegalArgumentException {
    boolean parseError=false;
    try {
      StringTokenizer st = new StringTokenizer(phoneStringEx);
      
      name = st.nextToken();
      host = st.nextToken(); //hostname
      st.nextToken(); //RAVE port
      st.nextToken(); //type of entry
      port = Integer.parseInt( st.nextToken() ); //optional port
    }
    catch(NumberFormatException nfe) {
      parseError = true;
    }
    catch(NoSuchElementException nsee) {
      parseError = true;
    }
    if(parseError) {
      throw new IllegalArgumentException("Phone entry format corrupted.");
    }
  }

  public String getName() {
    return name;
  }

  public String getHost() {
    return host;
  }

  public int getPort() {
    return port;
  }

  public String toString() {
    return name+" "+host+" "+port;
  }
}
