package adaptive.core.net;

import java.net.Socket;
import java.net.ServerSocket;
import java.io.IOException;
import java.net.InetAddress;

/*****************************************************************************
 * <! Copyright 1999, Institute for Complex Engineered Systems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: ObjectServerSocket.java 
 * >
 *
 * A ServerSocket that accepts connections for buffered ObjectSockets.
 * 
 * @author Yatish Patel
 * <A HREF="mailto:ypatel@andrew.cmu.edu">ypatel@andrew.cmu.edu</A>
 * <br> </br>
 *
 * @version  1.00 4/16/99<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: ObjectServerSocket.java,v $
 * Revision 1.3  1999/04/18 20:48:15  telamon
 * added more constructors
 *
 * >
 ****************************************************************************/

public class ObjectServerSocket extends ServerSocket {
  
  /**
   * Creates a server socket on a specified port. A port of 
   * <code>0</code> creates a socket on any free port. 
   * <p>
   * The maximum queue length for incoming connection indications (a 
   * request to connect) is set to <code>50</code>. If a connection 
   * indication arrives when the queue is full, the connection is refused.
   * <p>
   * If the application has specified a server socket factory, that 
   * factory's <code>createSocketImpl</code> method is called to create 
   * the actual socket implementation. Otherwise a "plain" socket is created.
   *
   * @param      port  the port number, or <code>0</code> to use any
   *                   free port.
   * @exception  IOException  if an I/O error occurs when opening the socket.
   * @see        java.net.SocketImpl
   * @see        java.net.SocketImplFactory#createSocketImpl()
   * @see        java.net.ServerSocket#setSocketFactory(java.net.SocketImplFactory)
   */
  public ObjectServerSocket(int port) throws IOException {
    super(port);
  }
  
  /**
   * Creates a server socket and binds it to the specified local port 
   * number. A port number of <code>0</code> creates a socket on any 
   * free port. 
   * <p>
   * The maximum queue length for incoming connection indications (a 
   * request to connect) is set to the <code>count</code> parameter. If 
   * a connection indication arrives when the queue is full, the 
   * connection is refused. 
   * <p>
   * If the application has specified a server socket factory, that 
   * factory's <code>createSocketImpl</code> method is called to create 
   * the actual socket implementation. Otherwise a "plain" socket is created.
   *
   * @param      port     the specified port, or <code>0</code> to use
   *                      any free port.
   * @param      backlog  the maximum length of the queue.
   * @exception  IOException  if an I/O error occurs when opening the socket.
   * @see        java.net.SocketImpl
   * @see        java.net.SocketImplFactory#createSocketImpl()
   * @see        java.net.ServerSocket#setSocketFactory(java.net.SocketImplFactory)
   */
  public ObjectServerSocket(int port, int backlog) throws IOException {
    super(port,backlog);
  }
  
  /** 
   * Create a server with the specified port, listen backlog, and 
   * local IP address to bind to.  The <i>bindAddr</i> argument
   * can be used on a multi-homed host for a ServerSocket that
   * will only accept connect requests to one of its addresses.
   * If <i>bindAddr</i> is null, it will default accepting
   * connections on any/all local addresses.
   * The port must be between 0 and 65535, inclusive.
   * <P>
   * @param port the local TCP port
   * @param backlog the listen backlog
   * @param bindAddr the local InetAddress the server will bind to
   * @see SocketConstants
   * @see SocketOption
   * @see SocketImpl
   */
  public ObjectServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
    super(port,backlog,bindAddr);
  }

  
  /**
   * Listens for a connection to be made to this socket and accepts 
   * it. The method blocks until a connection is made. 
   *
   * @exception  IOException  if an I/O error occurs when waiting for a
   *               connection.
   * @return an ObjectSocket representing the connection.
   */ 
  public ObjectSocket acceptObjectSocket() throws IOException {
    ObjectSocket s = new ObjectSocket();
    implAccept((Socket) s);
    return s;
  }

  /**
   * Listens for a connection to be made to this socket and accepts 
   * it. The method blocks until a connection is made. 
   *
   * @exception  IOException  if an I/O error occurs when waiting for a
   *               connection.
   * @return an ObjectSocket representing the connection.
   * @deprecated Though the return type of this method is Socket,
   *             the actual returned object is ObjectSocket. Use
   *             acceptObjectSocket() instead.              
   */ 
  public Socket accept() throws IOException {
    return acceptObjectSocket();
  }
}
