package adaptive.core;

import adaptive.core.util.*;

public class TriggerThreadPool extends ThreadGroup {
  private static TriggerThreadPool poolInstance;
  private static LinkedList eventQueue;
  
  static final int NUM_THREADS = 12;
  static final int TIMEOUT = 900;

  public static void init() {
    poolInstance = new TriggerThreadPool();
    eventQueue = new LinkedList();
  }
  
  private TriggerThreadPool() {
    super( "Worker Threads" );
    System.out.println( "Starting worker threads - " + Thread.currentThread() + " - " + System.currentTimeMillis() );
    for( int i = 0; i < NUM_THREADS; i++ ) {
      ( new TriggerThread( this, "Worker Thread " + i ) ).start();
    }
  }
  
  public static TriggerThreadPool instance() {
    if(poolInstance == null) {
      init();
    }
    return poolInstance;
  }

  public synchronized void enQueueEvent( TriggerEvent ev ) {
    eventQueue.addLast( ev );
    notify();
  }

  public synchronized TriggerEvent deQueueEvent() {
    return (TriggerEvent) eventQueue.getFirst();
  }
  
  public synchronized boolean isEmpty() {
    return ( eventQueue.size() == 0 );
  }
}
