package adaptive.core;

public class TriggerThread extends Thread {
  private TriggerEvent ev = null;
  private TriggerThreadPool threadPool = null;
  private boolean isRunningFlag = true;

  public TriggerThread( TriggerThreadPool ttp, String name ) {
    super( ttp, name );
    threadPool = ttp;
  }
  
  public boolean isRunning() {
    return isRunningFlag;
  }
  
  public void run() {
    while( true ) {
      isRunningFlag = true;  // is this the right place?
      if( ( ev = threadPool.deQueueEvent() ) != null ) {
	System.out.println( "Dispatching event - " + Thread.currentThread() + " - " + System.currentTimeMillis() );
	ev.dispatch();
      } else {
	isRunningFlag = false;
	try {
	  synchronized( threadPool ) {
	    System.out.println( "waiting - " + Thread.currentThread() + " - " + System.currentTimeMillis() );
	    threadPool.wait();
	    System.out.println( "done waiting - " + Thread.currentThread() + " - " + System.currentTimeMillis() );
	  }
	} catch( Exception e ) {
	  System.out.println( "got exception: " + e );
	}
      }

      /*
      if( threadPool.isEmpty() ) {
	return;  // kill this thread if there is nothing in the queue
		 // after waiting for a while
      }
      */
    }
  }
}
