package adaptive.core;

/********************************************************************
 * This event class is used to send "trigger" events between modules
 * and ports.  A module can trigger any of its output ports, signalling
 * that any trigger-based module connected to that port should look
 * at the data.
 */

public class TriggerEvent {
  BasicPortAgent dst;
  int[] portNumbers;
  
  /******************************************************************
   * Initializes the values of the event
   * @param destination The destination for the event
   * @param portNum The import port number for the destination
   *****************************************************************/
  public TriggerEvent( BasicPortAgent destination, int[] portNums ) {
    dst = destination;
    portNumbers = portNums;
  }
  
  /******************************************************************
   * returns the input port number that was triggered
   * @return the input port number that was triggered
   *****************************************************************/
  public int[] getPortNumbers() {
    return portNumbers;
  }

  /******************************************************************
   * returns the destination of this TriggerEvent
   * @return the destination of this TriggerEvent
   *****************************************************************/
  BasicPortAgent getDestination() {
    return dst;
  }
  
  /******************************************************************
   * Sends this event to the destination
   *****************************************************************/
  void dispatch() {
    // System.out.println( "dispatching event for " + dst );
    dst.runModule( this, false );
  }
}
