package adaptive.core;

/**
  * Stores information about a system.  This gets passed from coordinator
  * to modulemanager.  It stores the system name, and any status about it
  * such as who started it, is it running, etc etc.
  */
public class SystemInfo {
  /** If the system is running */
  public static final byte kRUNNING=(byte)1;
  /** If the system is in the initialization phase. */
  public static final byte kINIT=(byte)2;
  /** If the system is idle and able to run */
  public static final byte kIDLE=(byte)3;
  /** If the system is in limbo */
  public static final byte kLIMBO=(byte)4;
  
  private String name;
  private byte status;
  
  public SystemInfo(String name) {
	 this.name=name;
	 status=kLIMBO;
  }

  public void setName(String name) {
	 this.name=name;
  }
  
  public String getName() {
	 return name;
  }
  

  
  public boolean isRunning() {
	 return status==kRUNNING;
  }

  public boolean isIdle() {
	 return status==kIDLE;
  }

  public void setStatus(byte b) {
	 status=b;
  }
  
  
  
}
