package adaptive.core;

import comms.core.*;
import java.io.*;
import java.util.*;
import adaptive.core.net.*;

class SystemExecutor {
  Hashtable agentTable;
  Hashtable agentDescTable;
  
  String systemName;

  //SystemConfiguration config;
  AgentLoader agentLoader;
  boolean running;

  /** All the hostName mappings */
  //Hashtable hostNames;
  
  boolean netEnable;
  Communications commLink;

  SocketTable sTable;
  ExecutorCallback exCall;
  
  public SystemExecutor( AgentLoader al,  ExecutorCallback ec) {
    exCall = ec;
    agentTable = new Hashtable();
    agentLoader = al;	 
    running = false;
    systemName = "";    
    /*
    commLink = null;
    if(c == null) {
      netEnable = false;
    }
    else {
      netEnable = true;
      commLink = c;
      sTable = new SocketTable(commLink);
    }*/
    netEnable=true;
  }
  



  //synchronized void configureRaveComms(String dirHost, int dirPort)
  void setDirServer(String dirHost, int dirPort) throws IOException {

      System.out.println("Configuring Rave Comms...");
    //FileReader fr=null;
    try {

      System.out.println("Host: " + dirHost+" Port: " + dirPort);
      commLink = new Communications(systemName, dirHost,
                                    dirPort, false, false);
      sTable = SocketTable.getSingletonInstance(commLink);
    }
    catch(Exception ex) {
      System.out.println("Error Configuring Rave Comms");
      //if(fr != null)  { fr.close();}
      throw new IOException(ex.getMessage());
    }
    //System.out.println("Done Configuring Rave Comms");
  }
  
  synchronized void setConfiguration(Hashtable at,String name) {
    agentDescTable=at;
    systemName=name;
  }
  


  /** call this method to prepare this executor to run*/
  synchronized boolean setup() throws ConfigLoadException, ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, AgentLoaderException {
    if(!running) {

      AgentDescription agentDes;
      Agent agentInst;
      String agentName;	   
	   
	   
      Enumeration agents;
	   

      //System.out.println(agentDescTable.toString());
	   
      agents=agentDescTable.elements();
      while (agents.hasMoreElements()){
	agentDes=(AgentDescription)(agents.nextElement());
	System.out.println(agentDes.toString(""));
	//System.out.println("SysExec:Agent running at "+agentDes.getRunLocation());

   
	agentInst=instantiateAgent(agentDes);
	if (agentInst!=null){ //it will be null if this agent is not supposed to run on this host
	  System.out.println("Adding to agentTable: "+agentInst.getID());
	  agentTable.put(agentInst.getID(),agentInst);
	}
      }
	   
      //get the names from our agent instance hashtable
      agents = agentTable.keys();
      String curAgName;
	   
      while(agents.hasMoreElements()) {
	curAgName = (String) agents.nextElement();
	agentDes = (AgentDescription) agentDescTable.get(curAgName);        
	agentInst = (Agent) agentTable.get(curAgName);
	System.out.println("Agent name:"+curAgName);
	//	if (agentDes instanceof MacroDescription) continue;

	connectPorts(agentInst,agentDes);

      }
	   
      agentLoader.disconnectAgentServer();
      if (sTable!=null) sTable.trimToSize();
      EventTriggerThreadPool.init();
      return true;
    }
    return false;
}
    //helper function to connect ports for an individual agent according to its agentDescription, using agents available in aTable--jrj 5/3/00
  boolean connectPorts(Agent agentInst,AgentDescription agentDes) throws ConfigLoadException{
    boolean regGood=true;
    InputLocation inputLoc;
    Agent provider;
    System.out.println("Connecting ports on "+agentInst.getID());
    for(int j = 0; j < agentDes.getNumMappedInputs() && regGood;j++) {
      inputLoc = agentDes.getInputMapping(j);
      System.out.println("Input "+j+" is from "+agentDes.getInputMapping(j));
      System.out.println("trying to map:"+inputLoc.toString());
      provider = (Agent) agentTable.get(inputLoc.getAgentID());
      regGood = false;
      
      //System.out.println("   provider="+provider);
      
      regGood = agentInst.setInputMapping(inputLoc.getInputNum(),
					  provider,
					  inputLoc.getOutputNum());

      	if(!regGood) {
	  throw new ConfigLoadException("Agent "+agentInst.getID()+
					" does not have an input port "+
					inputLoc.inputNum+
					" or other port mapping error");
	} 
    }
    return regGood;
  }


    //helper function to setup an individual agent--jrj 5/3/00
    //I made it package accessable so PBAMacro could call it(and I want it to call this function so that I don't have to have multiple copies of this function)
  Agent instantiateAgent(AgentDescription agentDes) throws ClassNotFoundException, InstantiationException, IllegalAccessException, AgentLoaderException, java.net.UnknownHostException{
    Agent agentInst=null;
    String localHost=adaptive.core.net.LocalHost.getFullLocalHostName();
    if((agentDes).runsOnLocation(localHost)){
      //changed to check against local host name --jrj 7/8/99
      
      //agent runs on the local system
      //instantiate the agent
      if (agentDes instanceof MacroDescription) {
	//if any part of the macrodescription runs on this host, start a PBAMacro to hold it	
	agentInst=new PBAMacro((MacroDescription)agentDes,this);
      } 
      else {
	//depending on the location argument, this can come from the
	//network or from the local file system	      
	agentInst = agentLoader.newInstance(agentDes.getType(),
					    agentDes.getSource()==agentDes.LOCAL_FILE);
	
	
	if( agentInst instanceof BasicPortAgent ) {
	  ((BasicPortAgent) agentInst).setModuleMode( agentDes.getModuleMode() );
	}
	
	if( ( agentDes.getModuleMode() & Agent.LOOP_ONLY ) == 0 ) {
	  if( agentInst instanceof BasicPortAgent ) {
	    ( (BasicPortAgent) agentInst ).setNoThread();
	  }
	}
	
	
	if(agentInst instanceof PBSAgent) {
	  //this is a PBSAgent so give it the Communications and
	  //SocketTable instances
	  ((PBSAgent) agentInst).setup(agentDes.getName(),agentLoader,
				       agentDes.getState(),
				       commLink, sTable);
	} 
	if(agentInst instanceof PBTAgent) {
	  //a configuration changing trigger agent
	  ((PBTAgent) agentInst).setup(agentDes.getName(),agentLoader,
				       agentDes.getState(),
				       exCall);
	}
	else {
	  //normal agent so use the normal setup method.
	  agentInst.setup(agentDes.getName(),agentLoader,
			  agentDes.getState());
	}
	
      }
    }
    else {
      //create, if necessary, a stub for this agent
    }
    
    if (agentInst!=null){
      System.out.println("Instantiated "+agentInst.getID());
    }	
    return agentInst;
  }//end instantiate agent

  

  // rescurse this
  synchronized void start(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	((Agent) agentTable.get(name)).start();
      }
    }
  }

  synchronized void startAll() {
    //System.out.println("se.startAll()");
    if(agentTable != null) {
      Enumeration enum = agentTable.elements();
      Agent tempAg;
      //System.out.println("have an agenttable");
		
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	System.out.print("Have an element...");
	//	if (!(tempAg instanceof PBAMacro)) {
	  System.out.println("Starting "+tempAg);
	  tempAg.start();
	  //	}
		  
      }
      running = true;
    }
  }

  // recurse this
  synchronized void stop(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	((Agent) agentTable.get(name)).stop();
      }
    }
  }

  synchronized void stopAll() {
    if (agentTable != null) {
      Enumeration enum = agentTable.elements();
      Agent tempAg;
		
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//	if (!(tempAg instanceof PBAMacro))
	  tempAg.stop();
      }
      running=false;
    }
  }

  //recurse this
  synchronized void pause(String name){
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	((Agent) agentTable.get(name)).pause();
      }
    }
  }
    
  synchronized void pauseAll() {
    if(agentTable != null ) {
      Enumeration enum = agentTable.elements();
      Agent tempAg;
      boolean retVal = true;
	    
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//	if (!(tempAg instanceof PBAMacro))
	  tempAg.pause();
      }
    }
  }

  // recurse
  synchronized void unpause(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	((Agent) agentTable.get(name)).unpause();
      }
    }
  }
    
  synchronized void unpauseAll(){
    if(agentTable != null) {
      Enumeration enum = agentTable.elements();
      Agent tempAg;
      
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//	if (!(tempAg instanceof PBAMacro))
	  tempAg.unpause();
      }
    }
  }

  synchronized int getNumInputs(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	return ((Agent) agentTable.get(name)).getNumInputs();
      }
      return 0;
    }
    return 0;
  }

  synchronized int getNumOutputs(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	return ((Agent) agentTable.get(name)).getNumOutputs();
      }
      return 0;
    }
    return 0;
  }

  synchronized Object getInput(String name,int num) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	return ((Agent) agentTable.get(name)).getInput(num);
      }
      return new Float(0.0f);
    }
    return new Float(0.0f);
  }

  synchronized Object getOutput(String name, int num) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	return ((Agent) agentTable.get(name)).getOutput(num);
      }
      return new Float(0.0f);
    }
    return new Float(0.0f);
  }

  synchronized String getSystemName() {
    if(systemName != null) {
      return systemName;
    }
    return new String("");
  }

  synchronized String getAgentType(String name) {
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	return ((Agent) agentTable.get(name)).getClass().getName();
      }
      return new String("");
    }
    return new String("");
  }


  /** returns the agent object for a given name
      @param name The agent name in the configuration
      @return The Agent object (not AgentDescription)
  */
  synchronized Agent getAgentObject( String name ) {
    if( agentTable != null ) {
      return (Agent) agentTable.get( name );
    }
    return null;
  }


  synchronized String[] getAgentNames(){
    if(agentTable != null) {
      Enumeration enum = agentTable.keys();
      String[] retVal = new String[agentTable.size()];
	    
      for(int i = 0; i < agentTable.size();i++) {
	retVal[i] = (String)enum.nextElement();
      }
      return retVal;
    }
    return new String[0];
  }

  synchronized void saveState(String name){
    Object theIntState;
    if(agentTable != null) {
      if(agentTable.containsKey(name)) {
	//grab the state from the agent and put it into config
	//replacing whatever was there
	theIntState = ((Agent) agentTable.get(name)).saveState();
	((AgentDescription)agentDescTable.get(name)).setState(theIntState);
      }
    }
  }
 
  synchronized void saveStateAll() {
    if(agentTable != null ) {
      Enumeration enum = agentTable.elements();
      Agent tempAg;
      boolean retVal = true;
      Object theIntState;
      
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//grab the state from the agent and put it into config
	//replacing whatever was there
	//	if (!(tempAg instanceof PBAMacro)) {
	  theIntState = tempAg.saveState();
	  ((AgentDescription)agentDescTable.get(tempAg.getID())).setState(theIntState);
	  //	}
		  
      }
    }
  }

  synchronized void shutdown() {

    //turning off event system
    EventTriggerThreadPool.cleanup();
    //destroy all the agents
    Agent tempAg;
    if(agentTable != null) {
      Enumeration enum = agentTable.elements();
      	    
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//	if (!(tempAg instanceof PBAMacro)) {
	  System.out.println("Destroying agent: "+tempAg.getID());
	  tempAg.destroy();
	  System.out.println("Done destroying agent:"+tempAg.getID());
	  //	}
		  
      }
    }
  }

  synchronized boolean verifyAll() {
    //verify all the agents 
    Agent tempAg;
    if(agentTable != null) {
      Enumeration enum = agentTable.elements();
      	    
      while(enum.hasMoreElements()) {
	tempAg = (Agent) enum.nextElement();
	//	if (!(tempAg instanceof PBAMacro)) 
	  if(!tempAg.verify()) {
	      System.err.println(tempAg.getID()+" failed the verification step");
	    return false;
	  }
      }
      return true;
    }
    return false;
  }
}
