package adaptive.core;

import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;

/** displays a window to edit the fields of a class using reflection.
  * can be called with an object or an object and a list of fields.
  * used along with the @class SelectView class to edit agents
  */

/* this code could be cleaned a lot.  one of the biggest improvements
 * that could be made would be to make a consistent interface to the
 * fields of an object whether it is a class or an array.  a lot of
 * code is duplicated where the only difference is whether Array.get
 * method or the class get method is used.  a private method to make
 * that the same for both would reduce the need for redundancy...
 * another time though...
 */

/* for the component array, booleans are an array of checkboxgroup and
 * two checkboxes.  arrays and objects are buttons, other primitives
 * are textfields.
 */
public class StateViewer extends Frame implements ActionListener {
  private void internalConstructor( Object obj, Field selFields[] ) {
    o = obj;
    cFields = selFields;
    Class c = o.getClass();

    Panel buttons = new Panel();
    Button btn;
    buttons.add( btn = new Button( "OK" ) );
    btn.addActionListener( this );
    buttons.add( btn = new Button( "Save" ) );
    btn.addActionListener( this );
    buttons.add( btn = new Button( "Update" ) );
    btn.addActionListener( this );
    buttons.add( btn = new Button( "Cancel" ) );
    btn.addActionListener( this );
    add( buttons, "South" );


    Panel p = new Panel( new GridBagLayout( ) );
    GridBagConstraints left = new GridBagConstraints();
    GridBagConstraints right = new GridBagConstraints();
    left.gridx = 0; right.gridx = 1;
    int j = 0, wideLabel=0;
    String tempStr;
    if( c.isArray() ) {
      setTitle( "Edit " + c.getComponentType().toString() + "[]" );
      compArr = new Object[Array.getLength( o )];
      editors = new SelectView[Array.getLength( o )];

      for( int i = 0; i < compArr.length; i++ ) {
	Class fieldType = Array.get( o, i ).getClass();
	if( fieldType == Boolean.class || fieldType == Boolean.TYPE ) {
	  boolean value = Array.getBoolean( o, i );
	  Panel boolBox = new Panel();
	  Object objArr[] = new Object[3];
	  CheckboxGroup cbg = new CheckboxGroup();
	  Checkbox cb;
	  boolBox.add( cb = new Checkbox( "True", cbg, value ) );
	  objArr[1] = cb;
	  boolBox.add( cb = new Checkbox( "False", cbg, ! value ) );
	  objArr[2] = cb;
	  objArr[0] = cbg;
	  compArr[i] = objArr;
	  left.gridy = j; right.gridy = j++;
	  p.add( boolBox, right );
	} else if( fieldType.isPrimitive() || fieldType == String.class ||
		   fieldType == Byte.class || fieldType == Character.class ||
		   fieldType == Double.class || fieldType == Float.class ||
		   fieldType == Integer.class || fieldType == Long.class ||
		   fieldType == Short.class ) {
	  compArr[i] = new TextField( Array.get( o, i ).toString(), 12 );
	  left.gridy = j; right.gridy = j++;
	  p.add( (Component) compArr[i], right );
	} else {
	  Button editBtn = new Button( "Edit Object" );
	  editBtn.addActionListener( this );
	  compArr[i] = editBtn;
	  left.gridy = j; right.gridy = j++;
	  p.add( editBtn, right );
	}

	tempStr = c.getComponentType().toString() + "[" + i + "]";
	if( tempStr.length() > wideLabel ) {
	  wideLabel = tempStr.length();
	}
	p.add( new Label( tempStr ), left );
      }
    } else {
      setTitle( "Edit " + c.toString() );
      compArr = new Object[cFields.length];
      editors = new SelectView[cFields.length];

      for( int i = 0; i < cFields.length; i++ ) {
	try {
	  Class fieldType = cFields[i].getType();
	  if( fieldType == Boolean.class || fieldType == Boolean.TYPE ) {
	    boolean value = cFields[i].getBoolean( o );
	    Panel boolBox = new Panel();
	    Object objArr[] = new Object[3];
	    CheckboxGroup cbg = new CheckboxGroup();
	    Checkbox cb;
	    boolBox.add( cb = new Checkbox( "True", cbg, value ) );
	    objArr[1] = cb;
	    boolBox.add( cb = new Checkbox( "False", cbg, ! value ) );
	    objArr[2] = cb;
	    objArr[0] = cbg;
	    compArr[i] = objArr;
	    left.gridy = j; right.gridy = j++;
	    p.add( boolBox, right );
	  } else if( fieldType.isPrimitive() || fieldType == String.class ) {
	    compArr[i] = new TextField( cFields[i].get( o ).toString(), 12 );
	    left.gridy = j; right.gridy = j++;
	    p.add( (Component) compArr[i], right );
	  } else {
	    Button editBtn;
	    if( fieldType.isArray() ) {
	      editBtn = new Button( "Edit Array" );
	    } else {
	      editBtn = new Button( "Edit Object" );
	    }
	    editBtn.addActionListener( this );
	    compArr[i] = editBtn;
	    left.gridy = j; right.gridy = j++;
	    p.add( editBtn, right );
	  }

	  if( Modifier.isFinal( cFields[i].getModifiers() ) ) {
	    ( (Component) compArr[i]).setEnabled( false );
	  }

	  tempStr = cFields[i].getDeclaringClass().getName() + "." + cFields[i].getName();
	  if( tempStr.length() > wideLabel ) {
	    wideLabel = tempStr.length();
	  }
	  p.add( new Label( tempStr ), left );
	} catch( IllegalAccessException e ) {
	  System.out.println( "make components " + e.toString() );
	}
      }
    }

    add( p, "Center" );

    // there has GOT to be a better way to do this...
    if( ( 30 + wideLabel ) * 6 > 240 ) {  // just some numbers that work well
      setSize( ( 30 + wideLabel ) * 6, 32 * ( 2 + j ) );
    } else {
      setSize( 240, 32 * ( 2 + j ) );
    }

    addWindowListener( new
      WindowAdapter() {
	public void windowClosing( WindowEvent e ) {
	  dispose();
	}
      }
    );
  }


  public StateViewer( Object obj, Field selFields[] ) {
    internalConstructor( obj, selFields );
  }


  public StateViewer( Object obj ) {
    if( obj != null ) {
      internalConstructor( obj, obj.getClass().getDeclaredFields() );
    }
  }


  /* convert a single field given its type and the string entered */
  private Object objectFromString( Class c, String s ) {
    try {
      if( c == Boolean.class || c == Boolean.TYPE ) {
	return new Boolean( s );
      } else if( c == Byte.class || c == Byte.TYPE ) {
	return new Byte( s );
      } else if( c == Character.class || c == Character.TYPE ) {
	return new Character( s.charAt( 0 ) );
      } else if( c == Double.class || c == Double.TYPE ) {
	return new Double( s );
      } else if( c == Float.class || c == Float.TYPE ) {
	return new Float( s );
      } else if( c == Integer.class || c == Integer.TYPE ) {
	return new Integer( s );
      } else if( c == Long.class || c == Long.TYPE ) {
	return new Long( s );
      } else if( c == Short.class || c == Short.TYPE ) {
	return new Short( s );
      } else if( c == String.class ) {
	return new String( s );
      } else {
	return null;
      }
    } catch( Exception e ) {
      if( e instanceof NumberFormatException ) {
	/* pop up an ErrorDialog here instead ???? */
	System.out.println( "objectFromString: bad number format: " + s );
	return null;
      } else {
	System.out.println( "objectFromString: " + e.toString() );
	return null;
      }
    }
  }


  /* convert all of the fields from strings back into values in
   * the class or array
   */
  public void saveFields() {
    boolean isArr = o.getClass().isArray();
    for( int i = 0; i < compArr.length; i++ ) {
      if( isArr || ! Modifier.isFinal( cFields[i].getModifiers() ) ) {
	if( compArr[i] != null ) {
	  Class c;
	  if( isArr ) {
	    c = Array.get( o, i ).getClass();
	  } else {
	    c = cFields[i].getType();
	  }
	  try { 
	    if( compArr[i] instanceof TextField ) {
	      TextField t = (TextField) compArr[i];
	      Object value = objectFromString( c, t.getText() );
	      if( value != null ) {
		if( isArr ) {
		  Array.set( o, i, value );
		} else {
		  cFields[i].set( o, value );
		}
	      }
	    } else if( compArr[i] instanceof Object[] ) { // is a boolean
	      Object objArr[] = (Object []) compArr[i];
	      if( objArr[0] instanceof CheckboxGroup ) { 
		CheckboxGroup cbg = (CheckboxGroup) objArr[0];
		Checkbox pickedBox = cbg.getSelectedCheckbox();
		if( pickedBox.getLabel().equals( "True" ) ) {
		  if( isArr ) {
		    Array.set( o, i, new Boolean( true ) );
		  } else {
		    cFields[i].set( o, new Boolean( true ) );
		  }
		} else if( pickedBox.getLabel().equals( "False" ) ) {
		  if( isArr ) {
		    Array.set( o, i, new Boolean( false ) );
		  } else {
		    cFields[i].set( o, new Boolean( false ) );
		  }
		} else {
		  System.out.println( "StateViewer:unknown checkbox selected" );
		}
	      }
	    } else if( compArr[i] instanceof Button ) {
	      Button btn = (Button) compArr[i];
	      if( btn.getLabel().equals( "Edit Array" ) ) { // is an array
		cFields[i].set( o, editors[i].getEditedObject() );
	      }
	    } else {
	      System.out.println( "StateViewer: unknown component type" );
	    }
	  } catch( Exception e ) {
	    System.out.println( "saveFields: " + e.toString() );
	  }
	}
      }
    }
  }


  public void actionPerformed( ActionEvent e ) {
    boolean isArr = o.getClass().isArray();
    String s = e.getActionCommand();
    if( s.equals( "OK" ) ) {
      saveFields();
      dispose();
    } else if( s.equals( "Save" ) ) {
      saveFields();
    } else if( s.equals( "Update" ) ) {
      for( int i = 0; i < compArr.length; i++ ) {
	try {
	  if( compArr[i] instanceof TextField ) {
	    TextField t = (TextField) compArr[i];
	    if( isArr ) {
	      t.setText( Array.get( o, i ).toString() );
	    } else {
	      t.setText( cFields[i].get( o ).toString() );
	    }
	  } else if( compArr[i] instanceof Object[] ) {
	    Object objArr[] = (Object []) compArr[i];
	    if( objArr[0] instanceof CheckboxGroup ) {
	      CheckboxGroup cbg = (CheckboxGroup) objArr[0];
	      boolean value;
	      if( isArr ) {
		value = Array.getBoolean( o, i );
	      } else {
		value = cFields[i].getBoolean( o );
	      }
	      if( value ) {
		cbg.setSelectedCheckbox( (Checkbox) objArr[1] );
	      } else {
		cbg.setSelectedCheckbox( (Checkbox) objArr[2] );
	      }
	    }
	  }
	} catch( Exception ex ) {
	  System.out.println( "StateViewer: " + ex.toString() );
	}
      }
    } else if( s.equals( "Cancel" ) ) {
      dispose();
      // System.exit( 0 );
    } else if( s.equals( "Edit Object" ) || s.equals( "Edit Array" ) ) {
      Button btn = (Button) e.getSource();
      for( int i = 0; i < compArr.length; i++ ) {
	try {
	  if( btn == compArr[i] ) {
	    if( isArr ) {
	      editors[i] = new SelectView( Array.get( o, i ) );
	    } else {
	      editors[i] = new SelectView( cFields[i].get( o ) );
	    }
	    editors[i].show();
	  }
	} catch( IllegalAccessException IAE ) {
	  System.out.println( "Edit Object: illegal access: " + cFields[i].getName() );
	}
      }
    }
  }


  private SelectView editors[];
  private Object o;
  private Field cFields[];
  private Object compArr[];
}
