package adaptive.core;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;

/** SelectView is used to select fields of the object to view.
    used in cojuction with the @class StateViewer class.
    displays a window with a list of all fields in the class
    including inheireted fields */
public class SelectView extends Frame implements ActionListener {
  private Field[] getFieldHierarchy( Class c ) {
    /* make a vector with all of the fields, then return the
     * vector as an array */
    Field fieldArr[];
    if( c == Object.class ) {
      /* don't examine the fields of the object class */
      fieldArr = new Field[0];
    } else {
      Vector fieldVec = new Vector();
      fieldArr = c.getDeclaredFields();
      for( int i = 0; i < fieldArr.length; i++ ) {
	/* right now we can't get access to private fields, but
	 * rumor has it that we will with a future java version */
	if( ! Modifier.isPrivate( fieldArr[i].getModifiers() ) ) {
	  fieldVec.addElement( fieldArr[i] );
	}
      }

      /* recurse and add those fields into the vector too */
      fieldArr = getFieldHierarchy( c.getSuperclass() );
      for( int i = 0; i < fieldArr.length; i++ ) {
	fieldVec.addElement( fieldArr[i] );
      }

      fieldArr = new Field[fieldVec.size()];
      fieldVec.copyInto( fieldArr );
    }

    return fieldArr;
  }


  public SelectView( Object obj ) {
    if( obj == null ) {
      System.out.println( "SelectView: error obj is null" );
      return;
    }

    o = obj;
    Class c = o.getClass();
    
    if( c.isArray() ) {

      /* if we are editing an array, then just ask the user what
       * size to make the array here */
      setTitle( "Set Length: " + c.getComponentType().toString() + "[]" );
      add( new Label( "Set the length of the array:" ), "North" );

      Panel p = new Panel();
      p.add( sizeTF = new TextField( Array.getLength( o ) + "", 5 ) );
      add( p, "Center" );

      p = new Panel();
      Button btn;
      p.add( btn = new Button( "OK" ) );
      btn.addActionListener( this );
      p.add( btn = new Button( "Unchanged" ) );
      btn.addActionListener( this );
      p.add( btn = new Button( "Cancel" ) );
      btn.addActionListener( this );
      add( p, "South" );

      setSize( 230, 120 );
    } else {

      /* if we are editing an object the figure out which fields to
       * actually display to the user in the StateViewer object */
      setTitle( "Select Fields: " + c.toString() );
      add( new Label( "Select fields to view/edit:" ), "North" );

      lst = new java.awt.List( 10, true );
      cFields = getFieldHierarchy( c );
      int longStrLen = 0;
      for( int i = 0; i < cFields.length; i++ ) {
	String fStr = cFields[i].getDeclaringClass().getName() + "." + cFields[i].getName();
	if( fStr.length() > longStrLen ) {
	  longStrLen = fStr.length();
	}
	lst.add( fStr );
      }
      add( lst, "Center" );

      Panel p = new Panel();
      Button btn;
      p.add( btn = new Button( "OK" ) );
      btn.addActionListener( this );
      p.add( btn = new Button( "All" ) );
      btn.addActionListener( this );
      p.add( btn = new Button( "None" ) );
      btn.addActionListener( this );
      p.add( btn = new Button( "Cancel" ) );
      btn.addActionListener( this );
      add( p, "South" );

      setSize( longStrLen * 8, 240 );
    }

    addWindowListener( new
      WindowAdapter() {
	public void windowClosing( WindowEvent e ) {
	  dispose();
	}
      }
    );
  }


  /** resize an array if a new length is needed.  edits the
   * private object o, which should be an array
   * @param newLen the new length of the array
   */
  private void resizeArray( int newLen ) {
    int len = Array.getLength( o );
    if( len != newLen ) {
      Object newO = Array.newInstance( o.getClass().getComponentType(), newLen );
      for( int i = 0; i < newLen; i++ ) {
	if( i < len ) {
	  Array.set( newO, i, Array.get( o, i ) );
	} else {
	  // just copy em
	  Array.set( newO, i, Array.get( newO, i - 1 ) );
	  // should be clone or make newInstance instead?
	}
      }
      o = newO;
    }
  }

  /** returns the object being edited.  needed for the ability
   * to resize the array.
   * @return the object being edited
   */
  public Object getEditedObject() {
    if( o.getClass().isArray() ) {
      return o;
    } else {
      return null;
    }
  }

  public void actionPerformed( ActionEvent e ) {
    String s = e.getActionCommand();
    if( s.equals( "OK" ) ) {
      if( o.getClass().isArray() ) {
	resizeArray( Integer.parseInt( sizeTF.getText() ) );
	if( Array.getLength( o ) > 0 ) {
	  dispose();
	  StateViewer rt = new StateViewer( o );
	  rt.show();
	}
      } else {
	int selectedIndexes[] = lst.getSelectedIndexes();
	if( selectedIndexes.length > 0 ) {
	  Field selectedFields[] = new Field[selectedIndexes.length];
	  for( int i = 0; i < selectedIndexes.length; i++ ) {
	    selectedFields[i] = cFields[selectedIndexes[i]];
	  }
	  dispose();
	  StateViewer rt = new StateViewer( o, selectedFields );
	  rt.show();
	}
      }
    } else if( s.equals( "All" ) ) {
      for( int i = 0; i < cFields.length; i++ ) {
	if( ! lst.isIndexSelected( i ) ) {
	  lst.select( i );
	}
      }
    } else if( s.equals( "None" ) ) {
      for( int i = 0; i < cFields.length; i++ ) {
	lst.deselect( i );
      }
    } else if( s.equals( "Unchanged" ) ) {
      if( Array.getLength( o ) > 0 ) {
	dispose();
	StateViewer rt = new StateViewer( o );
	rt.show();
      }
    } else if( s.equals( "Cancel" ) ) {
      dispose();
    }
  }


  private TextField sizeTF;
  private Object o;
  private Field cFields[];
  private java.awt.List lst;
}
