package adaptive.core;

import comms.core.*;

public class RunControlProtocol {
  /** For each message there is the RCP header and some tokens
      The tokens are below */
  public static final String kHEADER = "RCP";
  /** (RCP REQM whereFrom whereTo) */
  public static final String kREQUESTMOVELOCK = "REQM";
  /** (RCP REQS OldAgent NewAgentType) */
  public static final String kREQUESTSWAPLOCK = "REQS";
  /** (RCP OWNM whereFrom whereTo) */
  public static final String kGIVEMOVELOCK = "OWNM";
  /** (RXP OWNS OldAgent NewAgentType) */
  public static final String kGIVESWAPLOCK = "OWNS";
  /** (RCP DOM) */
  public static final String kMOVEDONE = "DOM";
  /** (RCP FAM) */
  public static final String kMOVEFAIL = "FAM";
  /** (RCP DOS) */
  public static final String kSWAPDONE = "DOS";
  /** (RCP FAS) */
  public static final String kSWAPFAIL = "FAS";
  /** (RCP START) */
  public static final String kSTARTRUN = "STRUN";
  /** (RCP STOP) */
  public static final String kSTOPRUN = "SPRUN";
  /** (RCP PAUSE Agent) */
  public static final String kPAUSEAG = "PAU";
  /** (RCP PAUSE Agent) */
  public static final String kUNPAUSEAG = "UPA";
  /** (RCP SHUT) */
  public static final String kSHUTDOWN ="SHUT";
  /** (RCP REP) */
  public static final String kRESPONSE = "REP";

  public static Message requestMoveLock(String whereFrom, String whereTo) {
    return new Message(kHEADER+" "+kREQUESTMOVELOCK+" "+whereFrom+" "+whereTo);
  }
  
  public static Message requestSwapLock(String oldAgent, String newAgentType) {
    return new Message(kHEADER+" "+kREQUESTSWAPLOCK+" "+oldAgent+" "+
                       newAgentType);
  }
  
  public static Message giveMove(String whereFrom, String whereTo) {
    return new Message(kHEADER+" "+kGIVEMOVELOCK+" "+whereFrom+" "+whereTo);
  }

  public static Message giveSwap(String oldAgent, String newAgentType) {
    return new Message(kHEADER+" "+kGIVESWAPLOCK+" "+oldAgent+" "+newAgentType);
  }

  public static Message moveDone() {
    return new Message(kHEADER+" "+kMOVEDONE);
  }

  public static Message moveFail() {
    return new Message(kHEADER+" "+kMOVEFAIL);
  }

  public static Message swapDone() {
    return new Message(kHEADER+" "+kSWAPDONE);
  }

  public static Message swapFail() {
    return new Message(kHEADER+" "+kSWAPFAIL);
  }

  public static Message startRun() {
    return new Message(kHEADER+" "+kSTARTRUN);
  }
  
  public static Message stopRun() {
    return new Message(kHEADER+" "+kSTOPRUN);
  }

  public static Message pauseAg(String agentName) {
    return new Message(kHEADER+" "+kPAUSEAG+" "+agentName);  
  }

  public static Message unpauseAg(String agentName) {
    return new Message(kHEADER+" "+kUNPAUSEAG+" "+agentName);
  }
  
  public static Message shutdown() {
    return new Message(kHEADER+" "+kSHUTDOWN);
  }

  public static Message response(boolean b) {
    return new Message(kHEADER+" "+kRESPONSE+" "+b);
  }
}
  
