package adaptive.core;

import java.io.Serializable;

public class PortLocation implements Serializable {

 static final long serialVersionUID = 2687110204160241836L;

  private String agentName;
  private int portNumber;
  private AgentDescription agentDescription;
  
  public PortLocation(String an, int pn) {
	 agentName=an;
	 portNumber=pn;
	 agentDescription=null;
  }

  public PortLocation(String an, int pn,AgentDescription ad) {
	 agentName=an;
	 portNumber=pn;
	 agentDescription=ad;
  }
  
  public AgentDescription getAgentDescription() {
      //note:using this is unreliable since both places that use PortLocation do not set the agentDescription--jrj 5/20/2000
	 return agentDescription;
  }
  
  public void setAgentDescription(AgentDescription ad) {
	 agentDescription=ad;
  }
  
  public String getAgentName() {
	 return agentName;
  }

  public int getPortNumber() {
	 return portNumber;
  }
   
  public void setAgentName(String an) {
	 agentName=an;
  }

  public void setPortNumber(int pn) {
	 portNumber=pn;
  }

  public Object clone() {
	 return new PortLocation(agentName,portNumber);
  }
  
  public boolean equals(PortLocation pl) {
	 return ((pl.getAgentName().equals(agentName)) && (pl.getPortNumber()==portNumber));
  }

  public String toString() {
	 return String.valueOf(portNumber)+" on "+agentName;
  }
  
	 
}
