package adaptive.core;

/*****************************************************************
 * <!
 * PROJECT: Adaptable 
 *
 * FILE: Port.java
 * 
 * ABSTRACT:
 * >
 * Port base class. Supports types.
 * 
 * @author Charles Tennent <A HREF="mailto:tennent@andrew.cmu.edu">tennent@andrew.cmu.edu</A>
 * @author <br>Ted Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A></br>
 *
 * @version  1.00 11/19/98
 *
 * <!
 * REVISION HISTORY:
 * Version  Date        Who        What
 * -------  --------    -------    --------------------  
 * 1.00     11/19/98    telamon    Created.
 * >
 *****************************************************************/

abstract class Port {

  private Class type;
  private String name;

  /******************************************************************
   * <!
   * Method: Port()
   *
   * Description:
   * >
   * Constructor that sets type to specified type.
   * 
   * @param portType the type of the port
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  Port(Class portType) {
    super();
    type = portType;
    name = "";
  }

  /******************************************************************
   * <!
   * Method: Port()
   *
   * Description:
   * >
   * Constructor that sets name to specified string.
   * 
   * @param portName the name of the port
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  Port(String portName) {
    super();
    name = portName;
  }

  /******************************************************************
   * <!
   * Method: Port()
   *
   * Description:
   * >
   * Constructor that sets name to specified string and type to 
   * specified type.
   * 
   * @param portName the name of the port
   * @param portType the type of the port
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  Port(Class portType, String portName) {
    super();
    type = portType;
    name = portName;
  }

  /******************************************************************
   * <!
   * Method: setType()
   *
   * Description:
   * >
   * Sets the port's type.
   * 
   * @param tp the type to set to
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  synchronized void setType( Class tp ) {
    type = tp;
  }
  

  /******************************************************************
   * <!
   * Method: getType()
   *
   * Description:
   * >
   * Get the port's type.
   * 
   * @param 
   *
   * @return Class file for the port's type
   *
   * @exception 
   ******************************************************************/

  synchronized Class getType() {
    return( type );
  }

  /******************************************************************
   * <!
   * Method: setName()
   *
   * Description:
   * >
   * Sets the port's name.
   * 
   * @param nm the string to set name to
   *
   * @return 
   *
   * @exception 
   ******************************************************************/

  synchronized void setName( String nm ) {
    name = nm;
  }
  

  /******************************************************************
   * <!
   * Method: getName()
   *
   * Description:
   * >
   * Get the port's name.
   * 
   * @param 
   *
   * @return String of Port's name
   *
   * @exception 
   ******************************************************************/

  synchronized String getName() {
    return( name );
  }

}
