package adaptive.core;

import java.util.*;

/*****************************************************************************
 * <! Copyright 1998, Institute for Complex Engineered Sytems,
 *                    Carnegie Mellon University
 *
 * PROJECT: Adaptable 
 *
 * FILE: PBAgent.java 
 * >
 *
 * Class <code>PBAgent</code> is one of the adaptive.core base 
 * classes for Port Based Agents. It extends from BasicPortAgent.
 * Extend this class to create normal agents.
 *
 * @see Agent
 * @see BasicPortAgent
 * 
 * @author Theodore Q Pham <A HREF="mailto:telamon@CMU.EDU">telamon@CMU.EDU</A>
 *         <br> </br>
 *
 * @version  1.10 11/20/98<br> </br>
 *
 * <!
 * REVISION HISTORY:
 *
 * $Log: PBAgent.java,v $
 * Revision 1.15.4.1  2000/02/17 01:17:54  telamon
 * initial demo 2/16 checkin
 *
 * Revision 1.15  1999/04/03 03:04:09  telamon
 * new BasicPortAgent.java for StateEditor
 *
 * Revision 1.14  1999/02/23 22:46:22  yatish
 * Added port names to andgate
 *
 * Added an unpause to launcher frame
 *
 * Revision 1.13  1999/02/12 18:45:30  telamon
 * updated package names and Makefile
 *
 * Revision 1.12  1999/02/05 21:13:07  telamon
 * new agentloader
 *
 * Revision 1.11  98/12/07  18:38:18  telamon
 * fixed some comments
 * 
 * Revision 1.10  98/12/07  13:17:34  telamon
 * fixed the SystemExecutor
 * 
 * >
 ****************************************************************************/
public abstract class PBAgent extends BasicPortAgent {
  
  /***************************************************************************
   *
   * No argument constructor required for dynamic loading.
   * Calls super().
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public PBAgent() {    
    super();
  }
  
  
  /***************************************************************************
   *
   * Psuedo-constructor to prepare agent for runtime. 
   * Allocate support data. Call allocateInternals() to allow 
   * derived classes to setup. Call processInternalState() to restore 
   * saved state.
   * 
   * @param agentID the agent's name 
   * @param myLoader for use by composed agents 
   * @param internalState the agent's saved internal state 
   *
   * @return  <code>true</code> if setup completed successfully; <br> 
   *          <code>false</code> otherwise </br>    
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setup(String agentID,
			     AgentLoader myLoader, Object internalState ) {
    return super.setup(agentID, myLoader, internalState);
  }


  /***************************************************************************
   *
   * Returns the Agent's name. 
   *
   * @param 
   * 
   * @return the Agent's name
   *
   * @exception 
   *
   **************************************************************************/
  public final String getID() {
    return super.getID();
  }

  /***************************************************************************
   * 
   * Set the Agent's name.
   *
   * @param agentID The Agent's name.
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public final void setID( String agentID ) {
    super.setID(agentID);
  }
  
  /***************************************************************************
   *
   * Get the number of inputs this agent needs.
   *
   * @param 
   *
   * @return the number of inputs this agent needs. 
   *
   * @exception 
   *
   **************************************************************************/
  public final int getNumInputs() {
    return super.getNumInputs();
  }

  /***************************************************************************
   *
   * Get the number of outputs this agent provides.
   *
   * @param 
   *
   * @return the number of outputs this agent provides. 
   *
   * @exception 
   *
   **************************************************************************/
  public final int getNumOutputs() {
    return super.getNumOutputs();
  }

  /***************************************************************************
   *
   * Call to set the agent's number of inputs and outputs. Should be
   * called inside initialize(). Otherwise the agent will have 0 inputs
   * and 0 outputs.
   *
   * @param numin Number of inputs
   * @param numout Number of outputs
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  protected final void setNumInputsOutputs( int numin, int numout ) {
    super.setNumInputsOutputs(numin, numout);
  }

  /***************************************************************************
   *
   * Checks if <code>which</code> is a valid input port index.
   *
   * @param which the input port index
   *
   * @return <code>true</code> if valid;
   *         <br><code>false</code> otherwise</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean isInputIndex(int which) {
    return super.isInputIndex(which);
  }
  
  /***************************************************************************
   *
   * Get the specified InputPort.
   *
   * @param which the input port index
   *
   * @return the InputPort Object at the specified port number;
   *         <code>null</code> if the index is invalid
   *
   * @exception 
   *
   **************************************************************************/
  public final InputPort getInputPort(int which) {
    return super.getInputPort(which);
  }

  /***************************************************************************
   *
   * Set the input port at index to be the given InputPort.
   *
   * @param inp the InputPort object
   * @param which the input port index
   *
   * @return <code>true</code> if the input port was set;
   *         <br><code>false</code> if the index is invalid<br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setInputPort(InputPort inp, int which) {
    return super.setInputPort(inp, which);
  }
  
  /***************************************************************************
   *
   * Get the type of the InputPort at the specified index.
   *
   * @param which the input port index
   *
   * @return the Class Object for the input port's type;
   *         <br><code>null</code> if the index is invalid</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final Class getInputPortType( int which ) {
    return super.getInputPortType(which);
  }

  /***************************************************************************
   *
   * Set the InputPort type. If the input port doesn't yet exist,
   * create it.
   *
   * @param stp the fully qualified class name of the input type 
   * @param which the input port index
   *
   * @return <code>true</code> if the input port type was set;
   *         <br><code>false</code> if the index is invalid</br>
   *
   * @exception ClassNotFoundException thrown when stp does not
   *            indicate a valid java class
   *
   **************************************************************************/
  public final boolean setInputPortType( String stp, int which ) throws ClassNotFoundException{
    return super.setInputPortType(stp, which);
  }
  
  public void bar() {

  }

  /***************************************************************************
   *
   * Set the InputPort type. If the input port doesn't yet exist,
   * create it.
   *
   * @param otp the port should be set to this Object's type 
   * @param which the input port index
   *
   * @return <code>true</code> if the input port type was set;
   *         <br><code>false</code> if the index is invalid</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setInputPortType( Object otp, int which ) {
    return super.setInputPortType(otp, which);
  }

  /***************************************************************************
   *
   * Set the InputPort type. If the input port doesn't yet exist,
   * create it.
   *
   * @param tp the Class object for the type the InputPort should
   *           be set to
   * @param which the input port index
   *
   * @return <code>true</code> if the input port type was set;
   *         <br><code>false</code> if the index is invalid</br>
   *
   * @exception 
   * 
   **************************************************************************/
  public final boolean setInputPortType( Class tp, int which ) {
    return super.setInputPortType(tp, which);
  }
  
  /***************************************************************************
   *
   * Get the input mapping for the specified input port.
   *
   * @param which the input port index
   *
   * @return a space seperated string containing the providing agent's
   *         name and output number; <br><code>null</code> if no
   *         provider is mapped to the specified input port or the if
   *         specified input port doesn't exist
   *
   * @exception 
   * 
   **************************************************************************/
  public String getInputMapping(int which) {
    return super.getInputMapping(which);
  }

  /***************************************************************************
   *
   * Set the output port that will provide data for the specified
   * input port.
   *
   * @param which the index of the input port
   * @param provider the
   *
   * @return <code>true</code> if the mapping was made; <br>
   *         </br><code>false</code> otherwise. Failure results when
   *         the port index are invalid or the provider argument is
   *         <code>null</code>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setInputMapping(int which, Agent provider,
				       int whichOut) {
    return super.setInputMapping(which,provider,whichOut);
  }

  /***************************************************************************
   *
   * Get the current value of the Agent's specified input.
   *
   * @param which the desired input number
   *
   * @return the current input value;
   *
   * @exception 
   *
   **************************************************************************/
  public final Object getInput( int which ) {
    return super.getInput(which);
  }
  
  /***************************************************************************
   *
   * Checks if <code>which</code> is a valid output port index.
   *
   * @param which the output port index
   *
   * @return <code>true</code> if valid;
   *         <br><code>false</code> otherwise</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean isOutputIndex(int which) {
    return super.isOutputIndex(which);
  }

  /***************************************************************************
   *
   * Gets the specified OutputPort.
   *
   * @param which the output port index
   *
   * @return the OutputPort Object;
   *         <br><code>null</code> if index is invalid</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final OutputPort getOutputPort(int which) {
    return super.getOutputPort(which);
  }

  /***************************************************************************
   *
   * Set Agent's specified OutputPort.
   *
   * @param outp the OutputPort object
   * @param which index of the output port to set
   *
   * @return <code>true</code> if the OutputPort was set;
   *         <br><code>false</code> if the specified output port
   *         number is invalid</br>
   *
   * @exception 
   **************************************************************************/
  public final boolean setOutputPort(OutputPort outp, int which) {
    return super.setOutputPort(outp,which);
  }

  /***************************************************************************
   *
   * Get the specified output port's type.
   *
   * @param which index of the output port
   *
   * @return the Class object for the output port's type;
   *         <br><code>null</code> if the output port index is
   *         invalid</br>
   *
   * @exception
   *
   **************************************************************************/
  public final Class getOutputPortType( int which ) {
    return super.getOutputPortType(which);
  }

  /***************************************************************************
   *
   * Set the specified output port's type. If the OutputPort doesn't
   * yet exist, create it.
   *
   * @param stp fully qualified name representing of the type
   * @param which index of the output port to set
   *
   * @return <code>true</code> if the port type was set;
   *         <br><code>false</code> if the output port index is
   *         invalid</br>
   *
   * @exception ClassNotFoundException thrown if stp doesn't indicate a valid
   *            type
   *
   **************************************************************************/
  public final boolean setOutputPortType( String stp, int which ) 
    throws ClassNotFoundException {
    return super.setOutputPortType(stp, which);
  }
  
  /***************************************************************************
   *
   * Set the specified output port's type. If the OutputPort doesn't
   * yet exist, create it.
   *
   * @param otp port's type should be set to this Object's type
   * @param which index of the output port to set
   *
   * @return <code>true</code> if the port type was set;
   *         <br><code>false</code> if the output port index is
   *         invalid</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setOutputPortType( Object otp, int which ) {
    return super.setOutputPortType(otp, which);
  }

  /***************************************************************************
   *
   * Set the specified output port's type. If the OutputPort doesn't
   * yet exist, create it.
   *
   * @param tp the type to set to
   * @param which index of the output port to set
   *
   * @return <code>true</code> if the port type was set;
   *         <br><code>false</code> if the output port index is
   *         invalid</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setOutputPortType( Class tp, int which ) {
    return super.setOutputPortType(tp, which);
  }

  /******************************************************************
   * <!
   * Method: getInputPortName()
   *
   * Description:
   * >
   *
   * Get the type of the InputPort at the specified index.
   *
   * @param which the input port index
   *
   * @return the Class Object for the input port's name;
   *         <br><code>null</code> if the index is invalid</br>
   *
   * @exception 
   *
   ******************************************************************/
  public String getInputPortName( int which ) {
	 return super.getInputPortName(which);
  }

  /******************************************************************
   * <!
   * Method: setInputPortName()
   *
   * Description:
   * >
   *
   * Set the InputPort name. If the input port doesn't yet exist,
   * create it.
   *
   * @param nm the String for the name the InputPort should
   *           be set to
   * @param which the input port index
   *
   * @return <code>true</code> if the input port name was set;
   *         <br><code>false</code> if the index is invalid</br>
   *
   * @exception 
   ******************************************************************/
  public boolean setInputPortName( String nm, int which ) {
	 return super.setInputPortName(nm,which);
  }

  /******************************************************************
   * <!
   * Method: getOutputPortName()
   *
   * Description:
   * >
   *
   * Get the specified output port's type.
   *
   * @param which index of the output port
   *
   * @return the String for the output port's name;
   *         <br><code>null</code> if the output port index is
   *         invalid</br>
   *
   * @exception 
   ******************************************************************/
  public String getOutputPortName( int which ) {
	 return super.getOutputPortName(which);
  }
  

  /******************************************************************
   * <!
   * Method: setOutputPortName()
   *
   * Description:
   * >
   *
   * Set the specified output port's name. If the OutputPort doesn't
   * yet exist, create it.
   *
   * @param nm the name to set to
   * @param which index of the output port to set
   *
   * @return <code>true</code> if the port type was set;
   *         <br><code>false</code> if the output port index is
   *         invalid</br>
   *
   * @exception 
   ******************************************************************/
  public boolean setOutputPortName( String nm, int which ) {
	 return super.setOutputPortName(nm,which); 
  }
  


  /***************************************************************************
   *
   * Get the current value of the Agent's specified output.
   *
   * @param which the desired output number
   *
   * @return the current output value; <br> <code>null</code> if the
   *         specified output does not exist </br>
   *
   * @exception 
   *
   **************************************************************************/
  public final Object getOutput(int which) {
    return super.getOutput(which);
  }
  
  /***************************************************************************
   *
   * Set the value of the Agent's specified output.
   *
   * @param value the new output value
   * @param which the desired output port number
   *
   * @return <code>true</code> if the value was writen to the port;
   *         <br><code>false</code> if the specified port is invalid
   *         or there is a type mismatch</br>
   *
   * @exception 
   *
   **************************************************************************/
  public final boolean setOutput( Object value, int which ) {
    return super.setOutput( value, which);
  }

  /***************************************************************************
   *
   * Put's the Agent to sleep for the specified amount of time. This
   * method automatically releases the internal runLock monitor. DO
   * NOT USE ANY OTHER METHODS THAT WOULD BLOCK YOUR RUNLOOP.
   *
   * @param sleepTime how long to sleep for   
   *
   * @return 
   *
   * @exception InterruptedException when the thread is interrupted
   *
   **************************************************************************/
  public final void sleep(long sleepTime) throws InterruptedException {
    super.sleep(sleepTime);    
  }
         
  /***************************************************************************
   *
   * Called to start execution.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public final void start() {
    super.start();
  }

  /***************************************************************************
   *
   * Called to pause execution. <code>unpause()</code> may be called
   * later to resume execution.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public final void pause() {
    super.pause();
  }

  /***************************************************************************
   *
   * Called to unpause execution. <code>pause()</code> should have
   * been called before. If <code>pause()</code> wasn't called before,
   * then do nothing.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public final void unpause() {
    super.unpause();
  }

  /***************************************************************************
   *
   * Called to end execution. <b>Note:</b> Do not deallocate resources
   * or clear state in this method. Do so in <code>destroy()</code>.
   * <code>dumpState</code> may be called after this method has been
   * called.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   *
   **************************************************************************/
  public final void stop() {
    super.stop();
  }

  /***************************************************************************
   *
   * Returns the Agent's internal state. This will be serialized and
   * saved for later restoration. <b>Note:</b> State may not have been
   * explicitly frozen and Agent may not have been stopped prior to
   * this call. However, this method is internally synchronized such
   * that it will only occur between successive calls to
   * <code>runLoop()</code>.
   *
   * @param 
   *
   * @return a Serializable Object representing the Agent's saved state
   *
   * @exception 
   *
   **************************************************************************/
  public final Object saveState() {
    return super.saveState();
  }
  
  /***************************************************************************
   *
   * Whether the state should currently be frozen. This method,
   * <code>freezeState()</code>, and <code>unfreezeState()</code> are
   * internally synchronized so that they will never freeze or
   * unfreeze state in the middle of a call to
   * <code>runLoop()</code>. The Agent implementer should check to see
   * if state is frozen at the start of <code>runLoop()</code> and trust
   * that it will not change
   *
   * @param 
   *
   * @return an Object representing the Agent's saved state
   *
   * @exception 
   ******************************************************************/
  public final boolean isStateFrozen() {
    return super.isStateFrozen();
  }

  /******************************************************************
   * <!
   * Method: freezeState()
   *
   * Description:
   * >
   *
   * Called to prevent the Agent from changing it's internal state.
   * The Agent should continue to update it's outputs, but internal
   * data structures such as neural net weights or adaptive filter
   * coefficients should not be changed while state is frozen. See
   * <code>isStateFrozen()</code> for notes on synchronization.
   *
   * @see #isStateFrozen
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  public final void freezeState() {
    super.freezeState();
  }

  /******************************************************************
   * <!
   * Method: unfreezeState()
   *
   * Description:
   * >
   *
   * Called to undo a state freeze. The Agent is then free to change
   * it's internal state again. See <code>isStateFrozen()</code> for
   * notes on synchronization.
   *
   * @see #isStateFrozen
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  public final void unfreezeState() {
    super.unfreezeState();
  }

  /******************************************************************
   * <!
   * Method: destroy()
   *
   * Description:
   * >
   *
   * Called at end of Agent's run cycle. Agent should release all
   * resources it's holding and free up memory where necessary. If
   * stop hasn't been called before destroy, destroy will call stop
   * before proceeding with deallocation.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  public final void destroy() {
    super.destroy();
  }

  /******************************************************************
   * <!
   * Method: run()
   *
   * Description:
   * >
   * Satisfies Runnable interface. The main work loop. Derived
   * classes should not override this method. 
   * Override runLoop instead. This is public because java demands
   * that it be public.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  public final void run() {
    super.run();
  }
  
  /******************************************************************
   * 
   * <! Description: >
   * tells us to not use a seperate thread for this agent.
   *
   * @param 
   *
   * @return 
   *
   * @exception 
   ******************************************************************/
  protected final void setNoThread(){
    super.setNoThread();
  }

  /****************************************************************************
   * <!
   * Method: getSleepTime()
   *
   * Description:
   * >
   *
   * Get the current per loop sleep time value.
   *
   * @param 
   *
   * @return the current per loop sleep time value.
   *
   * @exception 
   ***************************************************************************/
  public final long getSleepTime() {
    return super.getSleepTime();
  }
  
  /****************************************************************************
   * <!
   * Method: setSleepTime()
   *
   * Description:
   * >
   *
   * Set's the current per loop sleep value.
   *
   * @param sleepTime the new current sleep value
   *
   * @return 
   *
   * @exception 
   ***************************************************************************/
  protected final void setSleepTime(long sleepTime) {
    super.setSleepTime(sleepTime);
  }
}
